/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components;

import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sun.lwuit.Container;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.CoordinateLayout;
import com.sun.lwuit.plaf.Border;
import java.io.IOException;

public class Softkey
extends Container {
    private static final int HEIGHT = 31;
    private static final int WIDTH = 79;
    private Label label;

    public Softkey() {
        this((String)null);
    }

    public Softkey(String text) {
        this.setStyle();
        this.setLayout(new CoordinateLayout(79, 31));
        this.label = new Label();
        this.setTextPosY(8);
        this.setLabelStyle();
        this.setText(text);
        this.setY(0);
        this.addComponent(this.label);
    }

    private void setLabelStyle() {
        this.label.getStyle().setBgTransparency(0);
        this.label.getStyle().setBorder(Border.createEmpty());
        this.label.getStyle().setMargin(0, 0, 0, 0);
        this.label.getStyle().setPadding(0, 0, 0, 0);
        this.label.getStyle().setFgColor(0xFFFFFF);
    }

    private void setStyle() {
        this.getStyle().setBgTransparency(0);
        this.getStyle().setBorder(Border.createEmpty());
        this.getStyle().setMargin(0, 0, 0, 0);
        this.getStyle().setPadding(0, 0, 0, 0);
    }

    public void setTextPosY(int posY) {
        this.label.setY(posY);
    }

    public void setDimension(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
    }

    public void alignText(int aligment) {
        if (this.label.getText() != null) {
            int posX = 0;
            int width = this.getPreferredW();
            if (aligment != 1) {
                posX = this.label.getStyle().getFont().stringWidth(this.label.getText());
                posX = width - posX - 1;
                if (aligment == 4) {
                    if ((posX /= 2) > 8 && posX <= 20) {
                        posX -= 3;
                    } else if (posX > 20 && posX < 34) {
                        posX -= 6;
                    } else if (posX >= 34) {
                        posX -= 10;
                    }
                }
            }
            this.label.setX(posX);
        }
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public void setBackground(String imageName) {
        try {
            if (SystemProperties.getPhonePlatform() == 2) {
                if (imageName == null) {
                    this.label.getStyle().setBgImage(null);
                    this.label.getStyle().setBgTransparency(0);
                } else {
                    this.label.getStyle().setBgImage(Image.createImage(IOUtility.getImageFromRES(imageName)));
                }
            } else {
                this.getStyle().setBgImage(Image.createImage(IOUtility.getImageFromRES(imageName)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void switchState(String imageName) {
        this.setBackground(imageName);
        this.repaint();
    }

    public Label getLabel() {
        return this.label;
    }
}

