/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.table;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.Style;

public class TableLayout
extends Layout {
    private int currentRow;
    private int currentColumn;
    private static int minimumSizePerColumn = 10;
    private Constraint[][] tablePositions;
    private static final Constraint SPAN_CONSTRAINT = new Constraint();
    private boolean[] rigidColumns;
    private static int defaultColumnWidth = -1;
    private static int defaultRowHeight = -1;

    public TableLayout(int rows, int columns) {
        this.tablePositions = new Constraint[rows][columns];
        this.rigidColumns = new boolean[columns];
    }

    public void setRigidColumn(int column, boolean rigid) {
        this.rigidColumns[column] = rigid;
    }

    public Component getComponentAt(int row, int column) {
        return this.tablePositions[row][column].parent;
    }

    public void layoutContainer(Container parent) {
        Style s = parent.getStyle();
        int top = s.getPadding(false, 0);
        int left = s.getPadding(parent.isRTL(), 1);
        int bottom = s.getPadding(false, 2);
        int right = s.getPadding(parent.isRTL(), 3);
        boolean rtl = parent.isRTL();
        int[] columnSizes = new int[this.tablePositions[0].length];
        int[] columnPositions = new int[this.tablePositions[0].length];
        int[] rowSizes = new int[this.tablePositions.length];
        int[] rowPositions = new int[this.tablePositions.length];
        int pWidth = parent.getLayoutWidth() - parent.getSideGap() - left - right;
        int pHeight = parent.getLayoutHeight() - parent.getBottomGap() - top - bottom;
        int currentX = left;
        for (int iter = 0; iter < columnSizes.length; ++iter) {
            if (parent.isScrollableX()) {
                columnSizes[iter] = this.getColumnWidthPixels(iter, pWidth, pWidth);
            } else {
                int leave = minimumSizePerColumn * (columnSizes.length - iter);
                columnSizes[iter] = this.getColumnWidthPixels(iter, pWidth, pWidth - currentX - leave);
            }
            if (rtl) {
                columnPositions[iter] = pWidth - (currentX += columnSizes[iter]);
                continue;
            }
            columnPositions[iter] = currentX;
            currentX += columnSizes[iter];
        }
        int currentY = top;
        for (int iter = 0; iter < rowSizes.length; ++iter) {
            rowSizes[iter] = parent.isScrollableY() ? this.getRowHeightPixels(iter, pHeight, -1) : this.getRowHeightPixels(iter, pHeight, pHeight - currentY);
            rowPositions[iter] = currentY;
            currentY += rowSizes[iter];
        }
        for (int r = 0; r < rowSizes.length; ++r) {
            for (int c = 0; c < columnSizes.length; ++c) {
                Constraint con = this.tablePositions[r][c];
                if (con == null || con == SPAN_CONSTRAINT) continue;
                Style componentStyle = con.parent.getStyle();
                int leftMargin = componentStyle.getMargin(parent.isRTL(), 1);
                int topMargin = componentStyle.getMargin(false, 0);
                con.parent.setX(left + leftMargin + columnPositions[c]);
                con.parent.setY(top + topMargin + rowPositions[r]);
                if (con.spanHorizontal > 1) {
                    int w = columnSizes[c];
                    for (int sh = 1; sh < con.spanHorizontal; ++sh) {
                        w += columnSizes[c + sh];
                    }
                    if (rtl) {
                        con.parent.setX(left + leftMargin + columnPositions[c + con.spanHorizontal - 1]);
                    }
                    con.parent.setWidth(w - leftMargin - componentStyle.getMargin(parent.isRTL(), 3));
                } else {
                    con.parent.setWidth(columnSizes[c] - leftMargin - componentStyle.getMargin(parent.isRTL(), 3));
                }
                if (con.spanVertical > 1) {
                    int h = rowSizes[r];
                    for (int sv = 1; sv < con.spanVertical; ++sv) {
                        h += rowSizes[r + sv];
                    }
                    con.parent.setHeight(h - topMargin - componentStyle.getMargin(false, 2));
                    continue;
                }
                con.parent.setHeight(rowSizes[r] - topMargin - componentStyle.getMargin(false, 2));
            }
        }
    }

    private int getColumnWidthPixels(int column, int percentageOf, int available) {
        int current = 0;
        for (int iter = 0; iter < this.tablePositions.length; ++iter) {
            Constraint c = this.tablePositions[iter][column];
            if (c == null || c == SPAN_CONSTRAINT || c.spanHorizontal > 1) continue;
            if (c.width > 0) {
                current = Math.max(current, c.width * percentageOf / 100);
            } else {
                Style s = c.parent.getStyle();
                current = Math.max(current, c.parent.getPreferredW() + s.getMargin(false, 1) + s.getMargin(false, 3));
            }
            if (available <= -1) continue;
            current = Math.min(available, current);
        }
        return current;
    }

    private int getRowHeightPixels(int row, int percentageOf, int available) {
        int current = 0;
        for (int iter = 0; iter < this.tablePositions[row].length; ++iter) {
            Constraint c = this.tablePositions[row][iter];
            if (c == null || c == SPAN_CONSTRAINT || c.spanVertical > 1) continue;
            if (c.height > 0) {
                current = Math.max(current, c.height * percentageOf / 100);
            } else {
                Style s = c.parent.getStyle();
                current = Math.max(current, c.parent.getPreferredH() + s.getMargin(false, 2) + s.getMargin(false, 0));
            }
            if (available <= -1) continue;
            current = Math.min(available, current);
        }
        return current;
    }

    public Dimension getPreferredSize(Container parent) {
        int iter;
        Style s = parent.getStyle();
        int w = s.getPadding(false, 1) + s.getPadding(false, 3);
        int h = s.getPadding(false, 0) + s.getPadding(false, 2);
        for (iter = 0; iter < this.tablePositions[0].length; ++iter) {
            w += this.getColumnWidthPixels(iter, Integer.MAX_VALUE, -1);
        }
        for (iter = 0; iter < this.tablePositions.length; ++iter) {
            h += this.getRowHeightPixels(iter, Integer.MAX_VALUE, -1);
        }
        return new Dimension(w, h);
    }

    public void addLayoutComponent(Object value, Component comp, Container c) {
        Constraint con = (Constraint)value;
        if (con == null) {
            con = this.createConstraint();
        } else if (con.parent != null) {
            throw new IllegalArgumentException("Constraint already associated with component!");
        }
        if (con.row < 0) {
            con.row = this.currentRow;
        }
        if (con.column < 0) {
            con.column = this.currentColumn;
        }
        con.parent = comp;
        if (this.tablePositions[con.row][con.column] != null) {
            throw new IllegalArgumentException("Row: " + con.row + " and column: " + con.column + " already occupied");
        }
        this.tablePositions[((Constraint)con).row][((Constraint)con).column] = con;
        if (con.spanHorizontal > 1 || con.spanVertical > 1) {
            for (int sh = 0; sh < con.spanHorizontal; ++sh) {
                for (int sv = 0; sv < con.spanVertical; ++sv) {
                    if (sh <= 0 && sv <= 0 || this.tablePositions[con.row + sv][con.column + sh] != null) continue;
                    this.tablePositions[((Constraint)con).row + sv][((Constraint)con).column + sh] = SPAN_CONSTRAINT;
                }
            }
        }
        this.updateRowColumn();
    }

    private void updateRowColumn() {
        if (this.currentRow >= this.tablePositions.length) {
            return;
        }
        while (this.tablePositions[this.currentRow][this.currentColumn] != null) {
            ++this.currentColumn;
            if (this.currentColumn < this.tablePositions[0].length) continue;
            this.currentColumn = 0;
            ++this.currentRow;
            if (this.currentRow < this.tablePositions.length) continue;
            return;
        }
    }

    public void removeLayoutComponent(Component comp) {
        for (int r = 0; r < this.tablePositions.length; ++r) {
            for (int c = 0; c < this.tablePositions[r].length; ++c) {
                if (this.tablePositions[r][c].parent != comp) continue;
                this.tablePositions[r][c] = null;
                return;
            }
        }
    }

    public Object getComponentConstraint(Component comp) {
        for (int r = 0; r < this.tablePositions.length; ++r) {
            for (int c = 0; c < this.tablePositions[r].length; ++c) {
                if (this.tablePositions[r][c] == null || this.tablePositions[r][c].parent != comp) continue;
                return this.tablePositions[r][c];
            }
        }
        return null;
    }

    public Constraint createConstraint() {
        return new Constraint();
    }

    public Constraint createConstraint(int row, int column) {
        Constraint c = this.createConstraint();
        c.row = row;
        c.column = column;
        return c;
    }

    public static void setMinimumSizePerColumn(int minimumSize) {
        minimumSizePerColumn = minimumSize;
    }

    public static int getMinimumSizePerColumn() {
        return minimumSizePerColumn;
    }

    public static void setDefaultColumnWidth(int w) {
        defaultColumnWidth = w;
    }

    public static int getDefaultColumnWidth() {
        return defaultColumnWidth;
    }

    public static void setDefaultRowHeight(int h) {
        defaultRowHeight = h;
    }

    public static int getDefaultRowHeight() {
        return defaultRowHeight;
    }

    static /* synthetic */ int access$700() {
        return defaultColumnWidth;
    }

    static /* synthetic */ int access$800() {
        return defaultRowHeight;
    }

    public static class Constraint {
        private Component parent;
        private int row = -1;
        private int column = -1;
        private int width = TableLayout.access$700();
        private int height = TableLayout.access$800();
        private int spanHorizontal = 1;
        private int spanVertical = 1;

        public void setVerticalSpan(int span) {
            if (span < 1) {
                throw new IllegalArgumentException("Illegal span");
            }
            this.spanVertical = span;
        }

        public void setHorizontalSpan(int span) {
            if (span < 1) {
                throw new IllegalArgumentException("Illegal span");
            }
            this.spanHorizontal = span;
        }

        public void setWidthPercentage(int width) {
            this.width = width;
        }

        public void setHeightPercentage(int height) {
            this.height = height;
        }
    }
}

