/*
 * Decompiled with CFR 0.152.
 */
public final class BCollisionBox {
    public Sprite[] hit = null;
    public int hitNum = 0;
    public Sprite[] flame = null;
    public int flameNum = 0;
    public int flameYOffset = 0;
    public Sprite[] spark = null;
    public int sparkNum = 0;
    public int sparkYOffset = 0;
    public int curSpark = -1;
    public Sprite[] lightning = null;
    public int lightningNum = 0;
    public int lightningYOffset = 0;

    public void addHit(String[] stringArray, Line[] lineArray, int n, int n2, int n3, int n4, int n5) {
        if (!Use.validObject(stringArray) || !Use.validObject(lineArray)) {
            return;
        }
        this.hitNum = stringArray.length;
        this.hit = new Sprite[this.hitNum];
        for (int i = 0; i < this.hitNum; ++i) {
            this.hit[i] = new Sprite(BImage.CreateColumnByRow(stringArray[i], "HIT" + i, n2, n3, 0, 0, n4, n5), lineArray[i].x2, n);
            this.hit[i].setFrame(1);
        }
    }

    public void addFlame(BImage bImage, int n) {
        if (!Use.validObject(bImage)) {
            return;
        }
        this.flameNum = n;
        this.flame = new Sprite[this.flameNum];
        for (int i = 0; i < this.flameNum; ++i) {
            this.flame[i] = new Sprite(bImage, -100, -100);
        }
        this.flameYOffset = bImage.getImageHeight() / 2;
    }

    public void addSpark(BImage bImage, int n) {
        if (!Use.validObject(bImage)) {
            return;
        }
        this.sparkNum = n;
        this.spark = new Sprite[this.sparkNum];
        for (int i = 0; i < this.sparkNum; ++i) {
            this.spark[i] = new Sprite(bImage, -100, -100);
            this.spark[i].enabled = false;
        }
        this.sparkYOffset = bImage.getImageHeight() / 2;
    }

    public void addLightning(BImage bImage, int n) {
        if (!Use.validObject(bImage)) {
            return;
        }
        this.lightningNum = n;
        this.lightning = new Sprite[this.lightningNum];
        for (int i = 0; i < this.lightningNum; ++i) {
            this.lightning[i] = new Sprite(bImage, -100, -100);
        }
        this.lightningYOffset = bImage.getImageHeight() / 2;
    }

    public void playFlame(NoteEvent noteEvent) {
        if (this.flame == null || noteEvent == null || this.hit == null) {
            return;
        }
        for (int i = 0; i < this.flameNum; ++i) {
            if (noteEvent.pos[i] <= 0) continue;
            this.flame[i].playCurrentAnim(this.hit[i].x, this.hit[i].y - this.flameYOffset);
            if (BBuild.SINGLE_NOTE_PLAY) break;
        }
    }

    public void playSpark(NoteEvent noteEvent) {
        if (this.spark == null || noteEvent == null || this.hit == null) {
            return;
        }
        for (int i = 0; i < this.flameNum; ++i) {
            if (noteEvent.pos[i] <= 0) continue;
            this.spark[i].setPos(this.hit[i].x, this.hit[i].y - this.sparkYOffset);
            this.spark[i].enabled = true;
            if (BBuild.SINGLE_NOTE_PLAY) break;
        }
    }

    public void stopSpark(NoteEvent noteEvent) {
        if (this.spark == null || noteEvent == null || this.hit == null) {
            return;
        }
        for (int i = 0; i < this.sparkNum; ++i) {
            if (noteEvent.pos[i] <= 0) continue;
            this.spark[i].enabled = false;
            if (BBuild.SINGLE_NOTE_PLAY) break;
        }
    }

    public void playLightning(int n) {
        if (this.lightning == null || this.hit == null) {
            return;
        }
        if (n < this.lightningNum && n < this.hitNum) {
            this.lightning[n].playCurrentAnim(this.hit[n].x, this.hit[n].y - this.lightningYOffset);
        }
    }

    public void playHit(boolean[] blArray) {
        if (this.hit == null) {
            return;
        }
        for (int i = 0; i < this.hitNum; ++i) {
            if (blArray[i]) {
                this.hit[i].setFrame(1);
                continue;
            }
            this.hit[i].setFrame(0);
        }
    }

    public void disableHits() {
        if (this.hit == null) {
            return;
        }
        for (int i = 0; i < this.hitNum; ++i) {
            this.hit[i].setFrame(0);
        }
    }

    public void render(BCanvas bCanvas, boolean bl) {
        int n = 0;
        for (n = 0; n < this.hitNum; ++n) {
            this.hit[n].renderCurrentFrame(bCanvas);
        }
        if (bl) {
            return;
        }
        for (n = 0; n < this.flameNum; ++n) {
            this.flame[n].renderCurrentAnim(bCanvas);
        }
        for (n = 0; n < this.sparkNum; ++n) {
            this.spark[n].render(bCanvas);
        }
        for (n = 0; n < this.lightningNum; ++n) {
            this.lightning[n].renderCurrentAnim(bCanvas);
        }
    }

    public void destroy() {
        this.hitNum = 0;
        this.flameNum = 0;
        this.lightningNum = 0;
        this.sparkNum = 0;
        this.hit = null;
        this.flame = null;
        this.lightning = null;
        this.spark = null;
        System.gc();
    }
}

