/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class BSongData {
    public static final byte EASY = 0;
    public static final byte MEDIUM = 1;
    public static final byte EXPERT = 2;
    public int venue = 0;
    public byte index = 0;
    public String artist = null;
    public String title = null;
    public String file = null;
    public int date = 0;
    public int[] score = null;
    public byte[] stars = null;

    public BSongData(int n, int n2, String string, String string2, String string3, int n3) {
        this.venue = n;
        this.index = (byte)n2;
        this.artist = string;
        this.title = string2;
        this.file = string3;
        this.date = n3;
        this.init();
    }

    public BSongData() {
        this.init();
    }

    private void init() {
        if (this.score != null) {
            this.score = null;
            System.gc();
        }
        if (this.stars != null) {
            this.stars = null;
            System.gc();
        }
        this.score = new int[3];
        this.stars = new byte[3];
        for (int i = 0; i < 3; ++i) {
            this.score[i] = 0;
            this.stars[i] = 0;
        }
    }

    public int getTotalScore() {
        return this.score[0] + this.score[1] + this.score[2];
    }

    public int getScore(int n) {
        if (n < 0 || n > 2) {
            return 0;
        }
        return this.score[n];
    }

    public int getStars(int n) {
        if (n < 0 || n > 2) {
            return 0;
        }
        return this.stars[n];
    }

    public boolean check(int n, int n2) {
        return this.venue == n && this.index == n2;
    }

    public static String getLevelLabel(int n) {
        if (n == 0) {
            return BCanvas.bab(46);
        }
        if (n == 1) {
            return BCanvas.bab(47);
        }
        if (n == 2) {
            return BCanvas.bab(48);
        }
        return BCanvas.bab(49);
    }

    public void setData(DataOutputStream dataOutputStream, boolean bl) {
        if (dataOutputStream == null) {
            return;
        }
        int n = 0;
        try {
            if (bl) {
                this.init();
            }
            dataOutputStream.writeShort(this.venue);
            dataOutputStream.writeByte(this.index);
            dataOutputStream.writeUTF(this.artist);
            dataOutputStream.writeUTF(this.title);
            dataOutputStream.writeUTF(this.file);
            dataOutputStream.writeShort(this.date);
            for (n = 0; n < 3; ++n) {
                dataOutputStream.writeInt(this.score[n]);
                dataOutputStream.writeByte(this.stars[n]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void getData(DataInputStream dataInputStream) {
        if (dataInputStream == null) {
            return;
        }
        int n = 0;
        try {
            this.init();
            this.venue = dataInputStream.readShort();
            this.index = dataInputStream.readByte();
            this.artist = dataInputStream.readUTF();
            this.title = dataInputStream.readUTF();
            this.file = dataInputStream.readUTF();
            this.date = dataInputStream.readShort();
            for (n = 0; n < 3; ++n) {
                this.score[n] = dataInputStream.readInt();
                this.stars[n] = dataInputStream.readByte();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void cheat(int n) {
        if (this.score == null) {
            this.init();
        }
        if (n >= 0 && n < 3) {
            this.score[n] = 9999;
            this.stars[n] = 5;
        }
    }
}

