/*
 * Decompiled with CFR 0.152.
 */
class ScrollBar {
    int m_top;
    int m_height;
    int m_xPos;
    int m_width;
    int m_max;
    int m_curVal;
    int thumbHeight;
    private final int MIN_THUMB_HEIGHT;

    ScrollBar(int n, int n2, int n3, int n4, int n5) {
        this.MIN_THUMB_HEIGHT = 10;
        this.setup(n, n2, n3, n4, n5);
    }

    public void setup(int n, int n2, int n3, int n4, int n5) {
        this.m_top = n2;
        this.m_height = n4;
        this.m_xPos = n;
        this.m_width = n3;
        this.m_curVal = 0;
        this.setMax(n5);
    }

    public void scrollUp() {
        this.m_curVal = Use.croll(this.m_curVal - 1, 0, this.m_max - 1);
    }

    public void scrollDown() {
        this.m_curVal = Use.croll(this.m_curVal + 1, 0, this.m_max - 1);
    }

    public void setVal(int n) {
        this.m_curVal = Use.clamp(n, 0, this.m_max);
    }

    public int getValue() {
        return this.m_curVal;
    }

    public int getHeight() {
        return this.m_height;
    }

    public void setMax(int n) {
        this.m_max = n;
        if (this.m_max == 0) {
            return;
        }
        this.thumbHeight = Use.clamp(this.m_height / this.m_max, 10, this.m_height);
        this.m_curVal = Use.clamp(this.m_curVal, 0, this.m_max);
    }

    public int getMax() {
        return this.m_max;
    }

    public void render(BCanvas bCanvas) {
        int n = Use.clamp(Use.MUL(this.m_height - this.thumbHeight, Use.DIV(this.m_curVal, this.m_max - 1)), 0, this.m_height - this.thumbHeight) + this.m_top;
        if (this.thumbHeight < this.m_height) {
            bCanvas.renderFillRect(0x404040, this.m_xPos, this.m_top, this.m_width, this.m_height);
            bCanvas.renderFillRect(16512467, this.m_xPos + 1, this.m_top + 1, this.m_width - 2, this.m_height - 2);
            bCanvas.renderFillRect(0x404040, this.m_xPos - 1, n, this.m_width + 2, this.thumbHeight);
            bCanvas.renderFillRect(16512467, this.m_xPos, n + 1, this.m_width, this.thumbHeight - 2);
        }
    }
}

