/*
 * Decompiled with CFR 0.152.
 */
public class Sprite {
    public int x = 0;
    public int y = 0;
    public BImage image = null;
    public int maxFrame = 0;
    public int frame = 0;
    public int anim = 0;
    public long tick = 0L;
    public int speed = 0;
    public boolean enabled = true;
    public int tag = 0;

    public Sprite() {
    }

    public Sprite(BImage bImage) {
        this.init(bImage, 0, 0);
    }

    public Sprite(BImage bImage, int n, int n2) {
        this.init(bImage, n, n2);
    }

    public Sprite(BImage bImage, int n, int n2, int n3) {
        this.init(bImage, n, n2);
        this.speed = n3;
    }

    public void init(BImage bImage, int n, int n2) {
        this.image = bImage;
        this.x = n;
        this.y = n2;
        this.speed = 4 + Use.rnd(2);
        this.anim = 0;
        this.tick = 0L;
        this.frame = Use.rnd(bImage.maxFrame(this.anim));
        this.enabled = true;
    }

    public void setFrame(int n) {
        this.frame = n;
    }

    public boolean play(boolean bl) {
        return this.play(this.anim, bl);
    }

    public boolean play(int n, boolean bl) {
        if (this.image != null) {
            if (this.anim != n) {
                this.anim = n;
                this.frame = 0;
            }
            int n2 = this.image.maxFrame(this.anim);
            if (BBuild.tickCount > this.tick) {
                this.tick = BBuild.tickCount + (long)Use.MUL(this.speed * 16, BBuild.TE);
                this.frame = bl ? Use.croll(this.frame + 1, 0, n2) : Use.clamp(this.frame + 1, 0, n2);
            }
            if (this.frame == n2) {
                return true;
            }
        }
        return false;
    }

    public void playCurrentAnim(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.frame = 0;
    }

    public void renderCurrentAnim(BCanvas bCanvas) {
        this.renderCurrentAnim(bCanvas, this.image);
    }

    public void renderCurrentAnim(BCanvas bCanvas, BImage bImage) {
        if (bImage == null || !this.enabled) {
            return;
        }
        int n = bImage.maxFrame(this.anim);
        if (this.frame == n) {
            return;
        }
        if (BBuild.tickCount > this.tick) {
            this.tick = BBuild.tickCount + (long)Use.MUL(this.speed * 16, BBuild.TE);
            this.frame = Use.clamp(this.frame + 1, 0, n);
        }
        bImage.renderSprite(bCanvas, this.x, this.y, this.anim, this.frame);
    }

    public void renderCurrentFrameToggledTime(BCanvas bCanvas) {
        if (this.image != null && this.enabled) {
            this.frame = BBuild.tickCount > this.tick ? 0 : 1;
            this.image.renderSprite(bCanvas, this.x, this.y, this.anim, this.frame);
        }
    }

    public void scheduleToggleTime(int n) {
        this.tick = BBuild.tickCount + (long)n;
    }

    public void renderCurrentFrame(BCanvas bCanvas) {
        if (this.image != null && this.enabled) {
            this.image.renderSprite(bCanvas, this.x, this.y, this.anim, this.frame);
        }
    }

    public void renderFrame(BCanvas bCanvas, int n, int n2, int n3) {
        if (this.image != null && this.enabled) {
            this.image.renderSprite(bCanvas, n2, n3, this.anim, n);
        }
    }

    public void render(BCanvas bCanvas) {
        if (this.image != null && this.enabled) {
            this.play(true);
            this.image.renderSprite(bCanvas, this.x, this.y, this.anim, this.frame);
        }
    }

    public void render(BCanvas bCanvas, int n, int n2) {
        if (this.image != null && this.enabled) {
            this.x = n;
            this.y = n2;
            this.play(true);
            this.image.renderSprite(bCanvas, n, n2, this.anim, this.frame);
        }
    }

    public void setPos(int n, int n2) {
        this.x = n;
        this.y = n2;
    }
}

