/*
 * Decompiled with CFR 0.152.
 */
package com.sina.net;

import com.sina.core.CommonUtils;
import com.sina.net.SocketHttpConnection;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class HttpConnectionFactory {
    public static final byte CONNTYPE_PURE_HTTP = 0;
    public static final byte CONNTYPE_PURE_HTTPS = 1;
    public static final byte CONNTYPE_SOCKET_HTTP = 2;

    public static HttpConnection getConnection(String url, byte connType, boolean isUseProxy, String proxyHost, int proxyPort) throws IOException {
        if (url.indexOf("://") < 0) {
            url = "http://" + url;
        }
        switch (connType) {
            case 0: 
            case 1: {
                return HttpConnectionFactory.createPureHttp(url, isUseProxy, proxyHost, proxyPort);
            }
            case 2: {
                return HttpConnectionFactory.createSocketHttp(url, isUseProxy, proxyHost, proxyPort);
            }
        }
        return null;
    }

    private static HttpConnection createSocketHttp(String url, boolean isUseProxy, String proxyHost, int proxyPort) {
        SocketHttpConnection result = null;
        try {
            result = new SocketHttpConnection(url, isUseProxy, proxyHost, proxyPort);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static HttpConnection createPureHttp(String url, boolean isUseProxy, String proxyHost, int proxyPort) throws IOException {
        String host = CommonUtils.getUrlHost(url);
        if (isUseProxy) {
            StringBuffer urlBuffer = new StringBuffer();
            urlBuffer.append("http://");
            urlBuffer.append(proxyHost);
            urlBuffer.append(":");
            urlBuffer.append(proxyPort);
            urlBuffer.append("/");
            urlBuffer.append(CommonUtils.getUrlWithoutHost(url));
            url = urlBuffer.toString();
            urlBuffer = null;
        }
        HttpConnection result = (HttpConnection)Connector.open((String)url, (int)3, (boolean)true);
        if (isUseProxy) {
            result.setRequestProperty("x-online-host", host);
        }
        return result;
    }
}

