/*
 * Decompiled with CFR 0.152.
 */
package com.sina.ui;

import com.sina.ui.ControlItem;
import com.sina.ui.RadioListListener;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RadioButtonList
extends ControlItem {
    public String[] title;
    public int selectedId;
    public Image imageSelect;
    public Image imageNotSelect;
    public int itemwidth;
    public int radioHeight;
    public int titleHeight;
    public RadioListListener listener;
    private String[] list;
    private int focusIndex;
    private int contentColor = 0;
    public static Image buttons;
    public static Image button;

    static {
        try {
            buttons = Image.createImage((String)"/radio_S.PNG");
            button = Image.createImage((String)"/radio.PNG");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public RadioButtonList(String s, String[] list, RadioListListener listener1) {
        this.width = G.W - 10;
        if (s != null) {
            this.title = Tools.stringFormatArray(s, this.width, G.SHOW_FONT);
        }
        this.itemwidth = this.width - 18;
        this.selectedId = 0;
        this.listener = listener1;
        this.list = list;
        this.update();
    }

    public void setWidth(int w) {
        this.width = w;
        this.itemwidth = this.width - 18;
    }

    public void setList(String[] list) {
        this.list = list;
    }

    public void update() {
        if (this.title != null) {
            this.titleHeight = this.title.length * G.SYS_FONTLINE_HEIGHT + 2;
        }
        this.radioHeight = G.SYS_FONTLINE_HEIGHT + 4;
        if (this.radioHeight < buttons.getHeight() + 4) {
            this.radioHeight = buttons.getHeight() + 4;
        }
        this.height = this.titleHeight + this.list.length * this.radioHeight;
    }

    public void paint(Graphics g, int clipx, int clipy) {
        int i;
        int offy = this.painty;
        g.setColor(this.contentColor);
        if (this.title != null) {
            i = 0;
            while (i < this.title.length) {
                g.drawString(this.title[i], this.paintx, offy + i * G.SYS_FONTLINE_HEIGHT, 20);
                ++i;
            }
            offy += this.titleHeight;
        }
        i = 0;
        while (i < this.list.length) {
            if (this.focusIndex == i && this.focus) {
                g.setColor(G.MenuSelectColor);
                g.drawRect(this.paintx, offy, this.itemwidth, this.radioHeight);
            } else {
                g.setColor(G.ContentColor);
            }
            if (this.selectedId == i) {
                g.drawImage(buttons, this.paintx + 5, offy + (this.radioHeight - buttons.getHeight()) / 2, 20);
            } else {
                g.drawImage(button, this.paintx + 5, offy + (this.radioHeight - button.getHeight()) / 2, 20);
            }
            g.drawString(this.list[i], this.paintx + 5 + buttons.getWidth() + 2, offy + (this.radioHeight - g.getFont().getHeight()) / 2, 20);
            offy += this.radioHeight;
            ++i;
        }
    }

    public boolean moveNext() {
        if (this.focusIndex < this.list.length - 1) {
            ++this.focusIndex;
            return false;
        }
        return true;
    }

    public boolean movePre() {
        if (this.focusIndex > 0) {
            --this.focusIndex;
            return false;
        }
        return true;
    }

    public void doEntry() {
        if (this.focusIndex != this.selectedId) {
            this.selectedId = this.focusIndex;
            this.listener.changedRadioList(this);
        }
    }

    public void setContentColor(int color) {
        this.contentColor = color;
    }
}

