/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.view;

import com.sina.ui.Menu;
import com.sina.ui.RollContainer;
import com.sina.weibo.Client4widget;
import com.sina.weibo.ClientManager;
import com.sina.weibo.LCanvas;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import javax.microedition.lcdui.Graphics;

public abstract class AbstractView {
    public ClientManager cm;
    public Menu menu = new Menu("\u9009\u9879", "\u8fd4\u56de");
    protected RollContainer lrc;
    public RollContainer list;
    public int viewID;
    public int offx;

    public AbstractView(ClientManager cm) {
        this.cm = cm;
        this.lrc = new RollContainer(G.W, G.H);
        this.lrc.setBackColor(0xFFFFFF);
    }

    public AbstractView() {
    }

    protected void showMenu() {
    }

    public void keyPressed(int keyCode) {
        if (this.menu.isOpen) {
            this.menuKeyPressed(keyCode);
            return;
        }
        byte keyType = Tools.keyCompare(keyCode);
        switch (keyType) {
            case 5: {
                if (this.menu.isOpen) break;
                this.showMenu();
                break;
            }
            case 6: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 7: {
                if (this.list != null) {
                    this.list.doEntry();
                    break;
                }
                this.lrc.doEntry();
                break;
            }
            case 1: {
                if (this.lrc == null) {
                    return;
                }
                if (!this.lrc.movePre()) break;
                this.lrc.gotFocus((byte)1);
                break;
            }
            case 2: {
                if (this.lrc == null) {
                    return;
                }
                if (!this.lrc.moveNext()) break;
                this.lrc.gotFocus((byte)0);
            }
        }
    }

    public void closeMenuList() {
        this.menu.close();
        this.render();
    }

    public void openMenuList() {
        this.menu.doEntry();
    }

    public void doMenuItem(int id) {
    }

    public void menuKeyPressed(int keyCode) {
        byte keyType = Tools.keyCompare(keyCode);
        switch (keyType) {
            case 5: 
            case 7: {
                this.menu.doEntry();
                break;
            }
            case 4: {
                if (!this.menu.hasChild()) break;
                this.menu.doEntry();
                break;
            }
            case 3: {
                this.menu.closeChild();
                break;
            }
            case 6: {
                this.closeMenuList();
                break;
            }
            case 1: {
                this.menu.movePre();
                break;
            }
            case 2: {
                this.menu.moveNext();
            }
        }
    }

    public void paint(Graphics g) {
        try {
            this.lrc.paint(g);
            this.menu.paint(g);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void tick(long time) {
        if (this.lrc.tick(time)) {
            this.render();
        }
    }

    public abstract void destroy();

    public final void render() {
        Client4widget.mainCanvas.repaint();
        LCanvas.needFlush = true;
    }

    public void move(int offx, int offy) {
        this.lrc.move(offx, offy);
        this.offx += offx;
    }

    public void update(int type) {
    }
}

