/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.view;

import com.sina.ui.AlertListener;
import com.sina.ui.HeadItem;
import com.sina.ui.HeadListener;
import com.sina.ui.ImageItem;
import com.sina.ui.InputBox;
import com.sina.ui.InputListener;
import com.sina.ui.ListRollContainer;
import com.sina.ui.MenuItem;
import com.sina.ui.WeiboLableItem;
import com.sina.ui.WeiboListener;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import com.sina.weibo.data.AbstractBowenList;
import com.sina.weibo.data.Bowen;
import com.sina.weibo.view.AbstractView;
import com.sonyericsson.sina.widget.SinawidgetMIDlet;

public class BowenView
extends AbstractView
implements InputListener,
WeiboListener,
HeadListener,
AlertListener {
    private String[] menuItems = new String[]{"\u8bc4\u8bba", "\u8f6c\u53d1", "\u67e5\u770b\u8bc4\u8bba", "\u8fdb\u5165\u535a\u4e3b\u9996\u9875", "\u4e0a\u4e00\u7bc7(\u2190)", "\u4e0b\u4e00\u7bc7(\u2192)"};
    private AbstractBowenList bowenList;
    private boolean updateList;
    private int selectedID;
    private boolean loading;

    public BowenView(ClientManager cm, AbstractBowenList bowen, int id) {
        super(cm);
        this.viewID = 4;
        this.bowenList = bowen;
        this.selectedID = id;
        this.init();
    }

    public void keyPressed(int keyCode) {
        if (this.menu.isOpen) {
            this.menuKeyPressed(keyCode);
            return;
        }
        byte keyType = Tools.keyCompare(keyCode);
        switch (keyType) {
            case 5: 
            case 7: {
                super.keyPressed(keyCode);
                break;
            }
            case 3: {
                if (this.selectedID <= 0) break;
                Bowen bowen = (Bowen)this.bowenList.bowenvc.elementAt(this.selectedID);
                bowen.pic = null;
                --this.selectedID;
                this.makeMiddle();
                this.init();
                break;
            }
            case 6: {
                this.cm.back(this.updateList);
                Bowen bowen = (Bowen)this.bowenList.bowenvc.elementAt(this.selectedID);
                bowen.pic = null;
                break;
            }
            case 1: {
                this.list.movePre();
                break;
            }
            case 2: {
                this.list.moveNext();
                break;
            }
            case 4: {
                if (this.selectedID >= this.bowenList.bowenvc.size() - 1) break;
                Bowen bowen = (Bowen)this.bowenList.bowenvc.elementAt(this.selectedID);
                bowen.pic = null;
                ++this.selectedID;
                this.makeMiddle();
                this.init();
            }
        }
    }

    public void destroy() {
    }

    public void doMenuItem(int id) {
        if (this.cm.currentAccount == null && id < 3) {
            this.cm.showRegAlert("\u53ea\u6709\u767b\u5f55\u7528\u6237\u624d\u80fd\u4f7f\u7528\u8be5\u529f\u80fd\uff01");
            this.closeMenuList();
            return;
        }
        switch (id) {
            case 0: {
                new InputBox("\u8bc4\u8bba\uff1a", "", 140, 0, this, 0);
                break;
            }
            case 1: {
                Bowen bowen1 = (Bowen)this.bowenList.bowenvc.elementAt(this.selectedID);
                if (bowen1.uid.equals(this.cm.currentAccount.uid)) {
                    this.cm.showAlert("\u4e0d\u80fd\u8f6c\u53d1\u81ea\u5df1\u7684\u5fae\u535a\uff01");
                    break;
                }
                new InputBox("\u8f6c\u53d1\u7406\u7531\uff1a", "", 140, 0, this, 1);
                break;
            }
            case 2: {
                this.cm.changeStageWithObject(this.viewID, 8, this.bowenList.bowenvc.elementAt(this.selectedID), false);
                break;
            }
            case 3: {
                Bowen bowen2 = (Bowen)this.bowenList.bowenvc.elementAt(this.selectedID);
                this.cm.getUser(bowen2.userName);
                break;
            }
            case 4: {
                if (this.selectedID <= 0) break;
                Bowen bowen = (Bowen)this.bowenList.bowenvc.elementAt(this.selectedID);
                bowen.pic = null;
                --this.selectedID;
                this.makeMiddle();
                this.init();
                break;
            }
            case 5: {
                if (this.selectedID >= this.bowenList.bowenvc.size() - 1) break;
                Bowen bowen = (Bowen)this.bowenList.bowenvc.elementAt(this.selectedID);
                bowen.pic = null;
                ++this.selectedID;
                this.makeMiddle();
                this.init();
            }
        }
        this.closeMenuList();
    }

    private void updateBowen() {
        this.loading = false;
        this.list.removeAll();
        if (this.bowenList != null) {
            Bowen bowen = (Bowen)this.bowenList.bowenvc.elementAt(this.selectedID);
            WeiboLableItem content = new WeiboLableItem(bowen.content, bowen.rtreason, this.list, this);
            this.list.addItem(content);
            if (bowen.pic != null) {
                if (bowen.pic.getWidth() > 240) {
                    bowen.pic = Tools.createThumbnail(bowen.pic);
                }
                ImageItem pic = new ImageItem(bowen.pic);
                pic.setWidth(this.list.getWidth());
                pic.setHeight(pic.getHeight() + 10);
                pic.setalign(9);
                this.list.addItem(pic);
            }
        }
    }

    private void makeMiddle() {
        this.menu.setMiddle("(" + (this.selectedID + 1) + "/" + this.bowenList.bowenvc.size() + ")");
    }

    private void init() {
        Bowen bowen = (Bowen)this.bowenList.bowenvc.elementAt(this.selectedID);
        HeadItem head = new HeadItem(bowen.headIcon, bowen.userName, bowen.time, bowen.zhuanfa, bowen.pinglun, (HeadListener)this);
        this.lrc.addItem(head);
        this.list = new ListRollContainer(G.W, G.H - G.MenuBarHeight - head.getHeight());
        this.list.setPainty(head.getHeight());
        this.lrc.addItem(this.list);
        this.updateBowen();
        this.makeMiddle();
    }

    public void update(int type) {
        Bowen bowen = (Bowen)this.bowenList.bowenvc.elementAt(this.selectedID);
        if (bowen.pic != null) {
            ImageItem pic = new ImageItem(bowen.pic);
            pic.setWidth(this.list.getWidth());
            pic.setHeight(pic.getHeight() + 10);
            pic.setalign(9);
            this.list.addItem(pic);
        }
        this.render();
    }

    protected void showMenu() {
        this.menu.clear();
        Bowen bowen = (Bowen)this.bowenList.bowenvc.elementAt(this.selectedID);
        int i = 0;
        while (i < this.menuItems.length) {
            if (!(i == 5 && this.selectedID == this.bowenList.bowenvc.size() - 1 || i == 4 && this.selectedID == 0 || bowen.pinglun == 0 && i == 2 || i == 3 && "\u6211".equals(bowen.userName))) {
                MenuItem menuitem = new MenuItem(this.menuItems[i], i, this);
                this.menu.addItem(menuitem);
            }
            ++i;
        }
        this.openMenuList();
    }

    public void setText(String text, int id) {
        Bowen bowen = (Bowen)this.bowenList.bowenvc.elementAt(this.selectedID);
        if (id == 0) {
            if ("".equals(text)) {
                this.cm.showAlert("\u8bc4\u8bba\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return;
            }
            this.bowenList.addPinglun(this.selectedID, text);
            ++bowen.pinglun;
        } else if (id == 1) {
            this.bowenList.addZhuanfa(this.selectedID, text);
            ++bowen.zhuanfa;
        }
        this.updateBowen();
    }

    public void tick(long time) {
        Bowen bowen = (Bowen)this.bowenList.bowenvc.elementAt(this.selectedID);
        if (!this.loading && bowen.picURL != null && !"".equals(bowen.picURL) && bowen.pic == null) {
            this.loading = true;
            bowen.getPic();
        }
    }

    public void weiboItemPerformed(int type, String value) {
        if (this.cm.currentAccount == null) {
            this.cm.showRegAlert("\u53ea\u6709\u767b\u5f55\u7528\u6237\u624d\u80fd\u4f7f\u7528\u8be5\u529f\u80fd\uff01");
        } else if (type == 2) {
            this.cm.changeStageWithObject(this.viewID, 14, value, false);
        } else if (type == 3) {
            try {
                if (SinawidgetMIDlet.instance.platformRequest(value)) {
                    this.cm.showDialog("url", "\u6253\u5f00\u94fe\u63a5\u9700\u8981\u5173\u95ed\u5ba2\u6237\u7aef\u7a0b\u5e8f\uff0c\u662f\u5426\u786e\u5b9a\u5173\u95ed\uff1f", this);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.cm.getUser(value);
        }
    }

    public void headClicked(int id) {
        if (this.cm.currentAccount == null) {
            this.cm.showRegAlert("\u53ea\u6709\u767b\u5f55\u7528\u6237\u624d\u80fd\u4f7f\u7528\u8be5\u529f\u80fd\uff01");
        } else {
            Bowen bowen = (Bowen)this.bowenList.bowenvc.elementAt(this.selectedID);
            if (id == 1) {
                this.cm.getUser(bowen.userName);
            }
        }
    }

    public void alertKeyPressed(int keyCode, String name) {
        byte keyType = Tools.keyCompare(keyCode);
        switch (keyType) {
            case 5: 
            case 7: {
                SinawidgetMIDlet.instance.showWidget();
            }
            case 6: {
                this.cm.closeAlert();
            }
        }
    }
}

