/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.view;

import com.sina.ui.BackItem;
import com.sina.ui.ListItem;
import com.sina.ui.ListListener;
import com.sina.ui.ListRollContainer;
import com.sina.ui.MenuItem;
import com.sina.ui.WeiboListItem;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import com.sina.weibo.data.Bowen;
import com.sina.weibo.data.HuatiBowenListModel;
import com.sina.weibo.view.AbstractView;

public class HuatiBowenListView
extends AbstractView
implements ListListener {
    private String[] menuItems = new String[]{"\u6253\u5f00", "\u5237\u65b0", "\u53d1\u8868\u5fae\u535a", "\u8fd4\u56de\u6211\u7684\u9996\u9875"};
    private HuatiBowenListModel blm;

    public HuatiBowenListView(ClientManager cm, HuatiBowenListModel blm) {
        super(cm);
        this.viewID = 14;
        this.blm = blm;
        BackItem li = new BackItem("\u8bdd\u9898\uff1a" + blm.title);
        li.setPaintx(0);
        li.setPainty(0);
        li.setWidth(G.W);
        this.lrc.addItem(li);
        this.list = new ListRollContainer(G.W, G.H - G.MenuBarHeight - li.getHeight());
        this.list.setPainty(li.getHeight());
        this.lrc.addItem(this.list);
        this.init();
    }

    private void init() {
        this.lrc.addItem(this.list);
        if (this.blm.bowenvc.size() > 0) {
            this.update(0);
        }
    }

    public void keyPressed(int keyCode) {
        if (this.menu.isOpen) {
            this.menuKeyPressed(keyCode);
            return;
        }
        byte keyType = Tools.keyCompare(keyCode);
        switch (keyType) {
            case 5: 
            case 7: {
                super.keyPressed(keyCode);
                break;
            }
            case 3: 
            case 6: {
                this.cm.back(false);
                break;
            }
            case 1: {
                if (!this.list.movePre()) break;
                this.list.gotFocus((byte)1);
                break;
            }
            case 2: {
                if (!this.list.moveNext()) break;
                this.list.gotFocus((byte)0);
                break;
            }
            case 4: {
                this.cm.changeStageWithId(this.viewID, 10, 0, false);
            }
        }
    }

    public void destroy() {
    }

    public void doMenuItem(int id) {
        switch (id) {
            case 0: {
                this.list.doEntry();
                break;
            }
            case 1: {
                this.blm.getBowenList(0);
                this.blm.pageId = 1;
                break;
            }
            case 2: {
                this.cm.changeStageWithId(this.viewID, 5, 0, false);
                break;
            }
            case 3: {
                this.cm.backToMyList();
            }
        }
        this.closeMenuList();
    }

    public void update(int type) {
        if (type == 1) {
            int i = 0;
            while (i < this.blm.bowenvc.size()) {
                WeiboListItem li = null;
                li = this.blm.pageId > 1 ? (WeiboListItem)this.list.getItem(i + 1) : (WeiboListItem)this.list.getItem(i);
                Bowen bowen = (Bowen)this.blm.bowenvc.elementAt(i);
                li.setIcon(bowen.headIcon);
                ++i;
            }
            this.render();
            return;
        }
        if (type == 0) {
            this.list.removeAll();
            if (this.blm != null && this.blm.bowenvc != null) {
                if (this.blm.pageId > 1) {
                    ListItem li = new ListItem("\u4e0a\u4e00\u9875", -1, (ListListener)this, this.list, 1);
                    this.list.addItem(li);
                }
                this.blm.loadList = false;
                int i = 0;
                while (i < this.blm.bowenvc.size()) {
                    Bowen bowen = (Bowen)this.blm.bowenvc.elementAt(i);
                    WeiboListItem li = new WeiboListItem(bowen.userName, bowen.time, bowen.content, bowen.rtreason, i, this, this.list);
                    li.setIcon(bowen.headIcon);
                    if (bowen.picURL != null && !"".equals(bowen.picURL)) {
                        li.showPic(true);
                    }
                    this.list.addItem(li);
                    ++i;
                }
                if (this.blm.count > this.blm.pagesize * this.blm.pageId) {
                    ListItem li = new ListItem("\u4e0b\u4e00\u9875", -2, (ListListener)this, this.list, 1);
                    this.list.addItem(li);
                }
                this.list.gotFocus((byte)1);
            }
            this.render();
        }
    }

    public void listitemPressed(int id) {
        if (id >= 0) {
            this.cm.changeStageWithObject(id, 4, this.blm, false);
        } else if (id == -1) {
            if (this.blm.pageId > 1) {
                this.blm.getBowenList(--this.blm.pageId);
            }
        } else if (id == -2) {
            this.blm.getBowenList(++this.blm.pageId);
        }
    }

    protected void showMenu() {
        if (this.menu.empty()) {
            int i = 0;
            while (i < this.menuItems.length) {
                MenuItem menuitem = new MenuItem(this.menuItems[i], i, this);
                this.menu.addItem(menuitem);
                ++i;
            }
        }
        this.openMenuList();
    }

    public void tick(long time) {
        if (this.blm.loadHead && !this.blm.loading && this.blm.bowenvc.size() > 0) {
            this.blm.loadNextHead();
        }
    }
}

