/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.view;

import com.sina.ui.BackItem;
import com.sina.ui.InputBox;
import com.sina.ui.InputListener;
import com.sina.ui.ListItem;
import com.sina.ui.ListListener;
import com.sina.ui.ListRollContainer;
import com.sina.ui.MenuItem;
import com.sina.ui.TabBar;
import com.sina.ui.WeiboListItem;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.SMSManager;
import com.sina.weibo.comm.Tools;
import com.sina.weibo.data.Bowen;
import com.sina.weibo.data.MyBlogModel;
import com.sina.weibo.view.AbstractView;

public class MyBlogListView
extends AbstractView
implements ListListener,
InputListener {
    private String[] menuItems = new String[]{"\u6253\u5f00", "\u53d1\u8868\u5fae\u535a", "\u641c\u7d22", "\u5207\u6362\u7528\u6237", "\u63a8\u8350\u597d\u53cb", "\u9000\u51fa"};
    private MyBlogModel blm;

    public MyBlogListView(ClientManager cm, MyBlogModel blm) {
        super(cm);
        this.viewID = 19;
        this.blm = blm;
        this.init();
    }

    public void keyPressed(int keyCode) {
        if (this.menu.isOpen) {
            this.menuKeyPressed(keyCode);
            return;
        }
        byte keyType = Tools.keyCompare(keyCode);
        switch (keyType) {
            case 5: 
            case 7: {
                super.keyPressed(keyCode);
                break;
            }
            case 6: {
                this.blm.getBowenList(0);
                this.blm.pageId = 1;
                break;
            }
            case 3: {
                this.cm.back(false);
                break;
            }
            case 1: {
                if (!this.list.movePre()) break;
                this.list.gotFocus((byte)1);
                break;
            }
            case 2: {
                if (!this.list.moveNext()) break;
                this.list.gotFocus((byte)0);
                break;
            }
            case 4: {
                this.cm.changeStageWithId(this.viewID, 10, 0, false);
            }
        }
    }

    public void destroy() {
    }

    public void doMenuItem(int id) {
        switch (id) {
            case 0: {
                this.list.doEntry();
                break;
            }
            case 1: {
                this.cm.changeStageWithId(this.viewID, 5, 0, false);
                break;
            }
            case 2: {
                this.cm.search();
                break;
            }
            case 3: {
                this.cm.changeStageWithId(this.viewID, 7, 0, false);
                break;
            }
            case 4: {
                new InputBox("\u624b\u673a\u53f7\uff1a", "", 17, 3, this, 1);
                break;
            }
            case 5: {
                this.cm.quit();
            }
        }
        this.closeMenuList();
    }

    private void init() {
        BackItem li = new BackItem("\u5f53\u524d\u7528\u6237\uff1a" + this.cm.currentAccount.nick);
        li.setPaintx(0);
        li.setPainty(0);
        li.setWidth(G.W);
        this.lrc.addItem(li);
        TabBar tb = new TabBar(G.TabItems, 6);
        tb.setPainty(li.getHeight());
        this.list = new ListRollContainer(G.W, G.H - li.getHeight() - G.MenuBarHeight - tb.getHeight());
        this.list.setPainty(li.getHeight() + tb.getHeight());
        this.lrc.addItem(this.list);
        this.lrc.addItem(tb);
        this.menu.setRight("\u5237\u65b0");
        this.update(0);
    }

    public void update(int type) {
        if (this.blm.bowenvc.size() > 0) {
            if (type == 1) {
                int i = 0;
                while (i < this.blm.bowenvc.size()) {
                    WeiboListItem li = null;
                    li = this.blm.pageId > 1 ? (WeiboListItem)this.list.getItem(i + 1) : (WeiboListItem)this.list.getItem(i);
                    Bowen bowen = (Bowen)this.blm.bowenvc.elementAt(i);
                    li.setIcon(bowen.headIcon);
                    ++i;
                }
                this.render();
                return;
            }
            if (type == 0) {
                this.list.removeAll();
                if (this.blm != null && this.blm.bowenvc != null) {
                    if (this.blm.pageId > 1) {
                        ListItem li = new ListItem("\u4e0a\u4e00\u9875", -1, (ListListener)this, this.list, 1);
                        this.list.addItem(li);
                    }
                    this.blm.loadList = false;
                    int i = 0;
                    while (i < this.blm.bowenvc.size()) {
                        Bowen bowen = (Bowen)this.blm.bowenvc.elementAt(i);
                        WeiboListItem li = new WeiboListItem(bowen.userName, bowen.time, bowen.content, bowen.rtreason, i, this, this.list);
                        li.setIcon(bowen.headIcon);
                        if (bowen.picURL != null && !"".equals(bowen.picURL)) {
                            li.showPic(true);
                        }
                        this.list.addItem(li);
                        ++i;
                    }
                    if (this.blm.count > this.blm.pagesize * this.blm.pageId) {
                        ListItem li = new ListItem("\u4e0b\u4e00\u9875", -2, (ListListener)this, this.list, 1);
                        this.list.addItem(li);
                    }
                }
            }
        } else {
            this.list.removeAll();
            ListItem li = new ListItem("\u8bf7\u5237\u65b0\u6570\u636e", -99, (ListListener)this, this.list, 1);
            this.list.addItem(li);
        }
        this.list.gotFocus((byte)1);
        this.render();
    }

    public void listitemPressed(int id) {
        if (id >= 0) {
            this.cm.changeStageWithObject(id, 4, this.blm, false);
        } else if (id == -1) {
            if (this.blm.pageId > 1) {
                this.blm.getBowenList(--this.blm.pageId);
            }
        } else if (id == -2) {
            this.blm.getBowenList(++this.blm.pageId);
        } else if (id == -99) {
            this.blm.getBowenList(0);
        }
    }

    protected void showMenu() {
        if (this.menu.empty()) {
            int i = 0;
            while (i < this.menuItems.length) {
                MenuItem menuitem = new MenuItem(this.menuItems[i], i, this);
                this.menu.addItem(menuitem);
                ++i;
            }
        }
        this.openMenuList();
    }

    public void tick(long time) {
        if (this.blm.loadHead && !this.blm.loading && this.blm.bowenvc.size() > 0) {
            this.blm.loadNextHead();
        }
    }

    public void setText(String text, int id) {
        if (text != null && !"".equals(text)) {
            SMSManager.sendSMS("Hi\uff0c\u6211\u5f00\u901a\u4e86\u5fae\u535a\uff0c\u4f60\u53ef\u4ee5\u901a\u8fc7\u201c\u5173\u6ce8\u6211\u201d\u4e86\u89e3\u6211\u7684\u8fd1\u51b5\uff0c\u968f\u65f6\u4e0e\u6211\u4fdd\u6301\u8054\u7cfb\u3002\nhttp://t.sina.cn/" + this.cm.currentAccount.uid, text);
        }
    }
}

