/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.view;

import com.sina.ui.HeadItem;
import com.sina.ui.HeadListener;
import com.sina.ui.ListItem;
import com.sina.ui.ListListener;
import com.sina.ui.ListRollContainer;
import com.sina.ui.MenuItem;
import com.sina.ui.WeiboListItem;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import com.sina.weibo.data.Bowen;
import com.sina.weibo.data.UserBowenListModel;
import com.sina.weibo.view.AbstractView;

public class UserBowenListView
extends AbstractView
implements ListListener,
HeadListener {
    private String[] menuItems = new String[]{"\u6253\u5f00", "\u5237\u65b0", "\u5173\u6ce8\u535a\u4e3b", "\u53d1\u8868\u5fae\u535a", "\u8fd4\u56de\u6211\u7684\u9996\u9875"};
    private UserBowenListModel blm;
    private HeadItem head;

    public UserBowenListView(ClientManager cm, UserBowenListModel blm) {
        super(cm);
        this.viewID = 13;
        this.blm = blm;
        this.init();
    }

    public void keyPressed(int keyCode) {
        if (this.menu.isOpen) {
            this.menuKeyPressed(keyCode);
            return;
        }
        byte keyType = Tools.keyCompare(keyCode);
        switch (keyType) {
            case 7: {
                this.list.doEntry();
                break;
            }
            case 5: {
                super.keyPressed(keyCode);
                break;
            }
            case 6: {
                this.cm.back(false);
                break;
            }
            case 1: {
                if (!this.list.movePre()) break;
                this.list.gotFocus((byte)1);
                break;
            }
            case 2: {
                if (!this.list.moveNext()) break;
                this.list.gotFocus((byte)0);
            }
        }
    }

    public void destroy() {
    }

    public void doMenuItem(int id) {
        switch (id) {
            case 0: {
                if (this.list.getItemNumber() == 0) {
                    this.cm.showAlert("\u5f53\u524d\u535a\u6587\u5217\u8868\u4e3a\u7a7a");
                    this.cm.setWait(false);
                    break;
                }
                this.list.doEntry();
                break;
            }
            case 1: {
                this.blm.getBowenList(0);
                this.blm.pageId = 1;
                break;
            }
            case 2: {
                this.blm.editUser();
                break;
            }
            case 3: {
                this.cm.changeStageWithId(this.viewID, 5, 0, false);
                break;
            }
            case 4: {
                this.cm.backToMyList();
            }
        }
        this.closeMenuList();
    }

    private void init() {
        this.head = new HeadItem(this.blm.account.headIMG, this.blm.account.nick, this.blm.account.fensishu, this.blm.account.sex, this.blm.account.relation == 4 || this.blm.account.nick.equals(this.cm.currentAccount.nick) ? null : (this.blm.account.relation == 0 || this.blm.account.relation == 2 ? "\u672a\u5173\u6ce8" : "\u5df2\u5173\u6ce8"), (HeadListener)this);
        this.lrc.addItem(this.head);
        this.list = new ListRollContainer(G.W, G.H - G.MenuBarHeight - this.head.getHeight());
        this.list.setPainty(this.head.getHeight());
        this.lrc.addItem(this.list);
        if (this.blm.bowenvc.size() > 0) {
            this.update(0);
        }
    }

    public void update(int type) {
        if (type == 2) {
            this.head.setRelation(this.blm.account.relation == 4 ? null : (this.blm.account.relation == 0 || this.blm.account.relation == 2 ? "\u672a\u5173\u6ce8" : "\u5df2\u5173\u6ce8"));
            this.render();
            return;
        }
        if (type == 1) {
            if (this.head.icon == null) {
                this.head.icon = this.blm.account.headIMG;
            }
            int i = 0;
            while (i < this.blm.bowenvc.size()) {
                WeiboListItem li = null;
                li = this.blm.pageId > 1 ? (WeiboListItem)this.list.getItem(i + 1) : (WeiboListItem)this.list.getItem(i);
                Bowen bowen = (Bowen)this.blm.bowenvc.elementAt(i);
                li.setIcon(bowen.headIcon);
                ++i;
            }
            this.render();
            return;
        }
        if (type == 0) {
            this.list.removeAll();
            if (this.blm != null && this.blm.bowenvc != null) {
                if (this.blm.pageId > 1) {
                    ListItem li = new ListItem("\u4e0a\u4e00\u9875", -1, (ListListener)this, this.list, 1);
                    this.list.addItem(li);
                }
                this.blm.loadList = false;
                int i = 0;
                while (i < this.blm.bowenvc.size()) {
                    Bowen bowen = (Bowen)this.blm.bowenvc.elementAt(i);
                    WeiboListItem li = new WeiboListItem(bowen.userName, bowen.time, bowen.content, bowen.rtreason, i, this, this.list);
                    li.setIcon(bowen.headIcon);
                    if (bowen.picURL != null && !"".equals(bowen.picURL)) {
                        li.showPic(true);
                    }
                    this.list.addItem(li);
                    ++i;
                }
                if (this.blm.count > this.blm.pagesize * this.blm.pageId) {
                    ListItem li = new ListItem("\u4e0b\u4e00\u9875", -2, (ListListener)this, this.list, 1);
                    this.list.addItem(li);
                }
            }
            this.list.gotFocus((byte)1);
            this.render();
        }
    }

    public void listitemPressed(int id) {
        if (id >= 0) {
            try {
                this.cm.changeStageWithObject(id, 4, this.blm, false);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        } else if (id == -1) {
            if (this.blm.pageId > 1) {
                this.blm.getBowenList(--this.blm.pageId);
            }
        } else if (id == -2) {
            this.blm.getBowenList(++this.blm.pageId);
        }
    }

    protected void showMenu() {
        this.menu.clear();
        int i = 0;
        while (i < this.menuItems.length) {
            block3: {
                block4: {
                    if (i == 0 && this.list.getItemNumber() == 0) break block3;
                    if (i != 2) break block4;
                    if (this.blm.account.relation == 4 || this.blm.account.nick.equals(this.cm.currentAccount.nick)) break block3;
                    this.menuItems[2] = this.blm.account.relation == 0 || this.blm.account.relation == 2 ? "\u5173\u6ce8\u535a\u4e3b" : "\u53d6\u6d88\u5173\u6ce8";
                }
                MenuItem menuitem = new MenuItem(this.menuItems[i], i, this);
                this.menu.addItem(menuitem);
            }
            ++i;
        }
        this.openMenuList();
    }

    public void tick(long time) {
        if (this.blm.loadHead && !this.blm.loading && this.blm.bowenvc.size() > 0) {
            this.blm.loadNextHead();
        }
    }

    public void headClicked(int id) {
        if (id == 1) {
            this.cm.getUser(this.blm.account.nick);
        } else if (id == 4) {
            this.blm.editUser();
        }
    }
}

