/*
 * Decompiled with CFR 0.152.
 */
package com.myweather.ui;

import com.myweather.constants.CommandConstants;
import com.myweather.constants.GeneralConstants;
import com.myweather.control.thread.GetCityListThread;
import com.myweather.midlet.MyWeatherMidlet;
import com.myweather.ui.MainUI;
import com.myweather.util.BasicFunction;
import com.myweather.util.RmsUtility;
import de.enough.polish.ui.Form;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Debug;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class AggreementUI
extends Form
implements CommandListener {
    public StringItem label;
    public Vector searchResultList = new Vector();
    private int recordIdOfCity = -1;

    public AggreementUI() {
        super(null);
        this.setCommandListener(this);
    }

    public AggreementUI(Style style) {
        super(null, style);
        this.setCommandListener(this);
        this.addCommand(CommandConstants.NOTAGREE);
        this.addCommand(CommandConstants.AGREE);
        StringItem labelTitle = new StringItem(null, "\u6700\u7ec8\u7528\u6237\u8bb8\u53ef\u534f\u8bae", StyleSheet.titlecenterStyle);
        this.append(labelTitle);
        this.label = new StringItem(null, "\u6b64\u65e0\u7ebf\u8bbe\u5907\u5305\u542b\u8f6f\u4ef6\uff0c\u4e14\u8f6f\u4ef6\u5747\u975e\u7d22\u5c3c\u7231\u7acb\u4fe1\u63d0\u4f9b\uff0c\u8f6f\u4ef6\u7684\u6240\u6709\u6743\u5f52\u5c5e\u5176\u7b2c\u4e09\u65b9\u4f9b\u5e94\u5546\u53ca\u8bb8\u53ef\u65b9\u6240\u6709\u3002\n\u4f7f\u7528\u6b64\u8bbe\u5907\u5373\u8868\u793a\u60a8\u63a5\u53d7\u6b64\u6700\u7ec8\u7528\u6237\u8bb8\u53ef\u534f\u8bae\uff0c\u4e14\u8be5\u8d39\u7528\u5e76\u975e\u7d22\u5c3c\u7231\u7acb\u4fe1\u76f4\u63a5\u6536\u53d6\u3002\n\u5728\u4f7f\u7528\u672c\u4ea7\u54c1\u670d\u52a1\u8fc7\u7a0b\u4e2d\u4f1a\u4ea7\u751f\u6d41\u91cf\u8d39\u7528\u3002", StyleSheet.helptextStyle);
        this.append(this.label);
    }

    public void keyPressed(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        if (this.isMenuOpened() || gameAction != 8) {
            super.keyPressed(keyCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggree(int index) {
        RecordStore aggreeRms = null;
        try {
            aggreeRms = RmsUtility.openRms("AGGREEMENT", true);
            RecordEnumeration recordEnu = aggreeRms.enumerateRecords(null, null, false);
            byte[] data = BasicFunction.serialize(index);
            if (recordEnu.numRecords() == 0) {
                aggreeRms.addRecord(data, 0, data.length);
            } else {
                aggreeRms.setRecord(recordEnu.nextRecordId(), data, 0, data.length);
            }
            BasicFunction.saveCity(0);
        }
        catch (Exception e) {
            System.out.println("exception:" + e.getMessage());
        }
        finally {
            RmsUtility.closeRmsQuietly(aggreeRms);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public void commandAction(Command command, Displayable disp) {
        if (command == CommandConstants.AGREE) {
            this.aggree(1);
            MainUI mainUI = null;
            try {
                mainUI = new MainUI(StyleSheet.mainscreenStyle);
                new GetCityListThread(mainUI, GeneralConstants.CURR_URL).start();
            }
            catch (Exception e) {
                Debug.debug("error", "com.myweather.ui.AggreementUI", 105, "Unable to initialize table completely");
            }
        }
        if (command == CommandConstants.NOTAGREE) {
            MyWeatherMidlet.getInstance().notifyDestroyed();
        }
    }
}

