/*
 * Decompiled with CFR 0.152.
 */
package com.myweather.util;

import com.myweather.util.BasicFunction;
import com.myweather.valueobject.AdInfo;
import com.myweather.valueobject.ChargeInfo;
import com.myweather.valueobject.CityInfo;
import com.myweather.valueobject.ForecastDay;
import com.myweather.valueobject.LifeStyle;
import de.enough.polish.util.Debug;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class CurrentCityParser {
    public static final boolean SKIP_XML_HEADER = true;

    public static CityInfo parseCity(InputStream in) throws Exception, XmlPullParserException {
        CityInfo cityInfo = new CityInfo();
        KXmlParser parser = new KXmlParser();
        parser.setInput(in, "UTF-8");
        int length = -1;
        byte[] buffer = new byte[1];
        int i = 0;
        do {
            length = in.read(buffer, 0, buffer.length);
            char tempChar = (char)buffer[0];
            if (tempChar == '>') break;
            ++i;
        } while (length > 0);
        try {
            boolean foundReportingTag = false;
            int eventType = parser.getEventType();
            while (parser.getEventType() != 1) {
                if (eventType != 0 && eventType != 1 && eventType == 2) {
                    String tagName = parser.getName();
                    if (tagName != null && tagName.equals("reporting-station")) {
                        foundReportingTag = true;
                        parser.next();
                        break;
                    }
                    String text = parser.nextText();
                    if (tagName.equals("dateabbr")) {
                        cityInfo.setCurrDate(text);
                    }
                }
                parser.next();
                eventType = parser.getEventType();
            }
            if (!foundReportingTag) {
                Debug.debug("error", "com.myweather.util.CurrentCityParser", 82, "not found channel tag");
                return cityInfo;
            }
            while (parser.getEventType() != 1 && !"reporting-station".equals(parser.getName())) {
                String tagName = parser.getName();
                String text = parser.nextText();
                if (tagName.equals("city")) {
                    cityInfo.setCity(text);
                } else if (tagName.equals("sky-conditions")) {
                    cityInfo.setSkyConditions(text);
                } else if (tagName.equals("temperature")) {
                    cityInfo.setTemperature(text);
                }
                parser.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cityInfo;
    }

    public static ChargeInfo parseChargeCode(InputStream in) throws Exception, XmlPullParserException {
        ChargeInfo chargeInfo = new ChargeInfo();
        KXmlParser parser = new KXmlParser();
        parser.setInput(in, "UTF-8");
        int length = -1;
        byte[] buffer = new byte[1];
        int i = 0;
        do {
            length = in.read(buffer, 0, buffer.length);
            char tempChar = (char)buffer[0];
            if (tempChar == '>') break;
            ++i;
        } while (length > 0);
        try {
            boolean foundReportingTag = false;
            int eventType = parser.getEventType();
            while (parser.getEventType() != 1) {
                if (eventType == 0) {
                    System.out.println("Start document" + parser.getName());
                } else if (eventType == 1) {
                    System.out.println("End document");
                } else if (eventType == 2) {
                    String tagName = parser.getName();
                    String text = parser.nextText();
                    System.out.println(tagName + " = " + text);
                }
                parser.next();
                eventType = parser.getEventType();
            }
            if (!foundReportingTag) {
                System.out.println("not found channel tag");
                return chargeInfo;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return chargeInfo;
    }

    public static AdInfo parseAdInfo(InputStream in) throws Exception, XmlPullParserException {
        AdInfo adInfo = new AdInfo();
        KXmlParser parser = new KXmlParser();
        parser.setInput(in, "UTF-8");
        int length = -1;
        byte[] buffer = new byte[1];
        int i = 0;
        do {
            length = in.read(buffer, 0, buffer.length);
            char tempChar = (char)buffer[0];
            if (tempChar == '>') break;
            ++i;
        } while (length > 0);
        try {
            int eventType = parser.getEventType();
            while (parser.getEventType() != 1) {
                if (eventType != 0 && eventType != 1 && eventType == 2) {
                    String tagName = parser.getName();
                    String text = parser.nextText();
                    if (tagName.equals("image_url")) {
                        adInfo.setImageUrl(text);
                    } else if (tagName.equals("hover_url")) {
                        adInfo.setHoverUrl(text);
                    } else if (tagName.equals("web_url")) {
                        adInfo.setWebUrl(text);
                    } else if (tagName.equals("timestamp")) {
                        adInfo.setTimestamp(text);
                    }
                }
                parser.next();
                eventType = parser.getEventType();
            }
        }
        catch (Exception e) {
            Debug.debug("error", "com.myweather.util.CurrentCityParser", 225, e.getMessage());
        }
        return adInfo;
    }

    public static String getMessage(InputStream in) throws Exception {
        String message = "";
        int length = -1;
        byte[] buffer = new byte[1];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = -1;
        while ((i = in.read()) != -1) {
            baos.write(i);
        }
        message = new String(baos.toByteArray(), "UTF-8");
        return message;
    }

    public static ForecastDay parseForeCastDay(InputStream in) throws Exception, XmlPullParserException {
        ForecastDay forecastDay = new ForecastDay();
        KXmlParser parser = new KXmlParser();
        parser.setInput(in, "UTF-8");
        int length = -1;
        byte[] buffer = new byte[1];
        int i = 0;
        do {
            length = in.read(buffer, 0, buffer.length);
            char tempChar = (char)buffer[0];
            if (tempChar == '>') break;
            ++i;
        } while (length > 0);
        boolean foundForecastTag = false;
        int eventType = parser.getEventType();
        while (parser.getEventType() != 1) {
            if (eventType != 0 && eventType != 1 && eventType == 2) {
                String tagName = parser.getName();
                if (tagName != null && tagName.equals("forecast-day")) {
                    foundForecastTag = true;
                    break;
                }
                String text = parser.nextText();
            }
            parser.next();
            eventType = parser.getEventType();
        }
        if (!foundForecastTag) {
            Debug.debug("error", "com.myweather.util.CurrentCityParser", 307, "not found channel tag");
            return forecastDay;
        }
        if (parser.getEventType() == 3 || parser.getEventType() == 1) {
            Debug.debug("error", "com.myweather.util.CurrentCityParser", 316, "there is no item tag");
            return forecastDay;
        }
        boolean rssItemCount = false;
        do {
            Hashtable<String, Object> forecast = new Hashtable<String, Object>();
            while (parser.nextTag() != 3) {
                parser.require(2, null, null);
                String name = parser.getName();
                String text = parser.nextText();
                if (forecast.containsKey(name)) {
                    Object objOrigiValue = forecast.get(name);
                    Vector<Object> valueList = null;
                    if (objOrigiValue instanceof Vector) {
                        valueList = (Vector<Object>)objOrigiValue;
                    } else {
                        valueList = new Vector<Object>();
                        valueList.addElement(objOrigiValue);
                    }
                    valueList.addElement(text);
                    forecast.put(name, valueList);
                } else {
                    forecast.put(name, text);
                }
                parser.require(3, null, name);
            }
            forecastDay.addForecastDay(forecast);
            parser.nextTag();
        } while ("forecast-day".equals(parser.getName()));
        parser = null;
        return forecastDay;
    }

    public static LifeStyle parseLifeStyle(InputStream in) throws Exception, XmlPullParserException {
        LifeStyle lifeStyle = new LifeStyle();
        KXmlParser parser = new KXmlParser();
        parser.setInput(in, "UTF-8");
        int length = -1;
        byte[] buffer = new byte[1];
        int i = 0;
        do {
            length = in.read(buffer, 0, buffer.length);
            char tempChar = (char)buffer[0];
            if (tempChar == '>') break;
            ++i;
        } while (length > 0);
        boolean foundLifeStyleTag = false;
        int eventType = parser.getEventType();
        while (parser.getEventType() != 1) {
            String tagName;
            if (eventType != 0 && eventType != 1 && eventType == 2 && (tagName = parser.getName()) != null && tagName.equals("clothes")) {
                foundLifeStyleTag = true;
                break;
            }
            parser.next();
            eventType = parser.getEventType();
        }
        if (!foundLifeStyleTag) {
            Debug.debug("error", "com.myweather.util.CurrentCityParser", 410, "not found channel tag");
            return lifeStyle;
        }
        if (parser.getEventType() == 3 || parser.getEventType() == 1) {
            Debug.debug("error", "com.myweather.util.CurrentCityParser", 419, "there is no item tag");
            return lifeStyle;
        }
        do {
            Hashtable<String, Object> lifeStyleTable = new Hashtable<String, Object>();
            while (parser.nextTag() != 3) {
                parser.require(2, null, null);
                String name = parser.getName();
                String attName = parser.getAttributeName(0);
                String attValue = parser.getAttributeValue(0);
                String text = parser.nextText();
                if (lifeStyleTable.containsKey(attName)) {
                    Object objOrigiValue = lifeStyleTable.get(attName);
                    Vector<Object> valueList = null;
                    if (objOrigiValue instanceof Vector) {
                        valueList = (Vector<Object>)objOrigiValue;
                    } else {
                        valueList = new Vector<Object>();
                        valueList.addElement(objOrigiValue);
                    }
                    valueList.addElement(attValue);
                    lifeStyleTable.put(attName, valueList);
                } else {
                    lifeStyleTable.put(attName, attValue);
                }
                parser.require(3, null, name);
            }
            lifeStyleTable.put("scope", BasicFunction.getScope(parser.getName()));
            lifeStyleTable.put("title", BasicFunction.getLifeStyleTitle(parser.getName()));
            if ("clothes".equals(parser.getName()) || "comfort".equals(parser.getName()) || "morningexercise".equals(parser.getName()) || "carwashing".equals(parser.getName()) || "coldcatching".equals(parser.getName()) || "airdrying".equals(parser.getName())) {
                lifeStyle.addForecastDay(lifeStyleTable);
            }
            parser.nextTag();
        } while (!"station".equals(parser.getName()));
        parser = null;
        return lifeStyle;
    }
}

