/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.io;

import de.enough.polish.util.Debug;
import de.enough.polish.util.HashMap;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class RedirectHttpConnection
implements HttpConnection {
    private static final int MAX_REDIRECTS = 5;
    private String originalUrl;
    private String requestMethod = "GET";
    private HashMap requestProperties;
    private HttpConnection httpConnection;
    private ByteArrayOutputStream byteArrayOutputStream;
    private InputStream inputStream;
    private HttpConnection currentHttpConnection;

    public RedirectHttpConnection(String url) throws IOException {
        this(url, null);
    }

    public RedirectHttpConnection(String url, HashMap requestProperties) throws IOException {
        this.originalUrl = url;
        this.requestProperties = new HashMap();
        if (requestProperties != null) {
            Object[] keys = requestProperties.keys();
            for (int i = 0; i < keys.length; ++i) {
                this.setRequestProperty((String)keys[i], (String)requestProperties.get(keys[i]));
            }
        }
        this.currentHttpConnection = (HttpConnection)Connector.open((String)url, (int)3, (boolean)true);
    }

    private synchronized void ensureConnectionCreated() throws IOException {
        InputStream tmpIn;
        HttpConnection tmpHttpConnection;
        block6: {
            if (this.httpConnection != null) {
                return;
            }
            tmpHttpConnection = this.currentHttpConnection;
            tmpIn = null;
            int redirects = 0;
            String url = this.originalUrl;
            do {
                byte[] postData;
                Object[] keys;
                if (tmpHttpConnection == null) {
                    tmpHttpConnection = (HttpConnection)Connector.open((String)url, (int)3, (boolean)true);
                }
                tmpHttpConnection.setRequestMethod(this.requestMethod);
                if (this.requestProperties != null && (keys = this.requestProperties.keys()) != null) {
                    for (int i = 0; i < keys.length; ++i) {
                        tmpHttpConnection.setRequestProperty((String)keys[i], (String)this.requestProperties.get(keys[i]));
                    }
                }
                if (this.byteArrayOutputStream != null && (postData = this.byteArrayOutputStream.toByteArray()) != null && postData.length > 0) {
                    OutputStream out = tmpHttpConnection.openOutputStream();
                    out.write(postData);
                    out.close();
                }
                tmpIn = tmpHttpConnection.openInputStream();
                int resultCode = tmpHttpConnection.getResponseCode();
                if (resultCode != 302 && resultCode != 301 && resultCode != 303 && resultCode != 307) break block6;
                url = tmpHttpConnection.getHeaderField("Location");
                tmpIn.close();
                tmpHttpConnection.close();
                tmpHttpConnection = null;
            } while (++redirects <= 5);
            throw new IOException("too many redirects");
        }
        this.httpConnection = tmpHttpConnection;
        this.currentHttpConnection = tmpHttpConnection;
        this.inputStream = tmpIn;
    }

    public long getDate() throws IOException {
        this.ensureConnectionCreated();
        return this.httpConnection.getDate();
    }

    public long getExpiration() throws IOException {
        this.ensureConnectionCreated();
        return this.httpConnection.getExpiration();
    }

    public String getFile() {
        try {
            this.ensureConnectionCreated();
            return this.httpConnection.getFile();
        }
        catch (IOException e) {
            System.out.println("Unable to open connection" + e);
            return null;
        }
    }

    public String getHeaderField(String name) throws IOException {
        this.ensureConnectionCreated();
        return this.httpConnection.getHeaderField(name);
    }

    public String getHeaderField(int n) throws IOException {
        this.ensureConnectionCreated();
        return this.httpConnection.getHeaderField(n);
    }

    public long getHeaderFieldDate(String name, long def) throws IOException {
        this.ensureConnectionCreated();
        return this.httpConnection.getHeaderFieldDate(name, def);
    }

    public int getHeaderFieldInt(String name, int def) throws IOException {
        this.ensureConnectionCreated();
        return this.httpConnection.getHeaderFieldInt(name, def);
    }

    public String getHeaderFieldKey(int n) throws IOException {
        this.ensureConnectionCreated();
        return this.httpConnection.getHeaderFieldKey(n);
    }

    public String getHost() {
        return this.currentHttpConnection.getHost();
    }

    public long getLastModified() throws IOException {
        this.ensureConnectionCreated();
        return this.httpConnection.getLastModified();
    }

    public int getPort() {
        return this.currentHttpConnection.getPort();
    }

    public String getProtocol() {
        return this.currentHttpConnection.getProtocol();
    }

    public String getQuery() {
        return this.currentHttpConnection.getQuery();
    }

    public String getRef() {
        return this.currentHttpConnection.getRef();
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public String getRequestProperty(String key) {
        return (String)this.requestProperties.get(key);
    }

    public int getResponseCode() throws IOException {
        this.ensureConnectionCreated();
        return this.httpConnection.getResponseCode();
    }

    public String getResponseMessage() throws IOException {
        this.ensureConnectionCreated();
        return this.httpConnection.getResponseMessage();
    }

    public String getURL() {
        return this.originalUrl;
    }

    public void setRequestMethod(String requestMethod) throws IOException {
        this.requestMethod = requestMethod;
    }

    public void setRequestProperty(String key, String value) throws IOException {
        if (this.requestProperties == null) {
            this.requestProperties = new HashMap();
        }
        if ("if-modified-since".equals(key.toLowerCase())) {
            Date d = new Date();
            this.requestProperties.put("IF-Modified-Since", d.toString());
        }
        this.requestProperties.put(key, value);
    }

    public String getEncoding() {
        try {
            this.ensureConnectionCreated();
            return this.httpConnection.getEncoding();
        }
        catch (IOException e) {
            Debug.debug("error", "de.enough.polish.io.RedirectHttpConnection", 449, (Object)"Unable to establish connection", e);
            return this.currentHttpConnection.getEncoding();
        }
    }

    public long getLength() {
        try {
            this.ensureConnectionCreated();
            return this.httpConnection.getLength();
        }
        catch (IOException e) {
            Debug.debug("error", "de.enough.polish.io.RedirectHttpConnection", 466, (Object)"Unable to establish connection", e);
            return this.currentHttpConnection.getLength();
        }
    }

    public String getType() {
        try {
            this.ensureConnectionCreated();
            return this.httpConnection.getType();
        }
        catch (IOException e) {
            Debug.debug("error", "de.enough.polish.io.RedirectHttpConnection", 483, (Object)"Unable to establish connection", e);
            return this.currentHttpConnection.getType();
        }
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public InputStream openInputStream() throws IOException {
        this.ensureConnectionCreated();
        return this.inputStream;
    }

    public void close() throws IOException {
        if (this.httpConnection != null) {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (Exception e) {
                    System.out.println("Error while closing input stream" + e);
                }
                this.inputStream = null;
            }
            if (this.byteArrayOutputStream != null) {
                try {
                    this.byteArrayOutputStream.close();
                }
                catch (Exception e) {
                    System.out.println("Error while closing output stream" + e);
                }
                this.byteArrayOutputStream = null;
            }
            this.httpConnection.close();
            this.httpConnection = null;
            this.currentHttpConnection = null;
        }
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public synchronized OutputStream openOutputStream() throws IOException {
        if (this.httpConnection != null) {
            return this.httpConnection.openOutputStream();
        }
        if (this.byteArrayOutputStream == null) {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
        }
        return this.byteArrayOutputStream;
    }
}

