/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.ImageItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;

public class Form
extends Screen {
    public Form(String title) {
        this(title, null, null);
    }

    public Form(String title, Style style) {
        this(title, null, style);
    }

    public Form(String title, Item[] items) {
        this(title, items, null);
    }

    public Form(String title, Item[] items, Style style) {
        super(title, style, true);
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                Item item = items[i];
                this.container.add(item);
            }
        }
    }

    public int append(Item item) {
        return this.append(item, null);
    }

    public int append(Item item, Style itemStyle) {
        item.screen = this;
        this.container.add(item);
        if (itemStyle != null) {
            item.setStyle(itemStyle);
        }
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            MasterCanvas.repaintCanvas(this);
        }
        return this.container.size() - 1;
    }

    public int append(String str, Style itemStyle) {
        return this.append(new StringItem(null, str, itemStyle), null);
    }

    public int append(String str) {
        return this.append(new StringItem(null, str), null);
    }

    public int append(Image img, Style itemStyle) {
        return this.append(new ImageItem(null, img, 0, null, itemStyle), null);
    }

    public int append(Image img) {
        return this.append(new ImageItem(null, img, 0, null), null);
    }

    public void insert(int itemNum, Item item) {
        if (itemNum == this.container.size()) {
            this.container.add(item);
        } else {
            this.container.add(itemNum, item);
        }
    }

    public void insert(int itemNum, Item item, Style itemStyle) {
        if (itemNum == this.container.size()) {
            this.container.add(item, itemStyle);
        } else {
            if (itemStyle != null) {
                item.setStyle(itemStyle);
            }
            this.container.add(itemNum, item);
        }
    }

    public void delete(int itemNum) {
        this.container.remove(itemNum);
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            MasterCanvas.repaintCanvas(this);
        }
    }

    public void deleteAll() {
        this.container.clear();
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            MasterCanvas.repaintCanvas(this);
        }
    }

    public void set(int itemNum, Item item) {
        this.container.set(itemNum, item);
    }

    public void set(int itemNum, Item item, Style itemStyle) {
        this.container.set(itemNum, item, itemStyle);
    }

    public Item get(int itemNum) {
        return this.container.get(itemNum);
    }

    public int size() {
        return this.container.size();
    }

    protected String createCssSelector() {
        return "form";
    }
}

