/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.CustomItem;
import de.enough.polish.ui.IconItem;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MessageItem
extends CustomItem {
    private final IconItem headlineItem;
    private final StringItem textItem;

    public MessageItem(String headline, String text) {
        this(headline, text, null);
    }

    public MessageItem(String headline, String text, Style style) {
        super(null, style);
        this.headlineItem = new IconItem(headline, null, StyleSheet.defaultStyle);
        this.textItem = new StringItem(null, text, StyleSheet.defaultStyle);
    }

    protected int getMinContentWidth() {
        return 100;
    }

    protected int getMinContentHeight() {
        return 30;
    }

    protected int getPrefContentWidth(int height) {
        int width = 200;
        this.headlineItem.background = null;
        this.headlineItem.border = null;
        int headlineWidth = this.headlineItem.getItemWidth(width, width);
        this.textItem.background = null;
        this.textItem.border = null;
        int textWidth = this.textItem.getItemWidth(width, width);
        return Math.max(headlineWidth, textWidth);
    }

    protected int getPrefContentHeight(int width) {
        this.headlineItem.background = null;
        this.headlineItem.border = null;
        int height = this.headlineItem.getItemHeight(width, width);
        this.textItem.background = null;
        this.textItem.border = null;
        height += this.textItem.getItemHeight(width, width);
        return height += this.paddingVertical;
    }

    public void setHeadline(String headline) {
        this.setHeadline(headline, null);
    }

    public void setHeadline(String headline, Style style) {
        this.headlineItem.setText(headline);
        if (style != null) {
            this.headlineItem.setStyle(style);
        }
    }

    public void setText(String text) {
        this.setText(text, null);
    }

    public void setText(String text, Style style) {
        this.textItem.setText(text);
        if (style != null) {
            this.textItem.setStyle(style);
        }
    }

    public void setImage(Image image) {
        this.headlineItem.setImage(image);
    }

    protected void paint(Graphics g, int w, int h) {
        this.headlineItem.paint(0, 0, 0, w, g);
        int y = this.headlineItem.itemHeight + this.paddingVertical;
        this.textItem.paint(0, y, 0, w, g);
    }
}

