/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.AccessibleCanvas;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.Style;
import de.enough.polish.util.Debug;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class ScreenChangeAnimation
extends Canvas
implements Runnable,
AccessibleCanvas {
    protected Display display;
    protected AccessibleCanvas nextCanvas;
    protected Image lastCanvasImage;
    protected int[] lastCanvasRgb;
    protected boolean useLastCanvasRgb;
    protected Image nextCanvasImage;
    protected int[] nextCanvasRgb;
    protected boolean useNextCanvasRgb;
    protected int screenWidth;
    protected int screenHeight;
    protected Displayable nextDisplayable;
    protected boolean isForwardAnimation;

    public ScreenChangeAnimation() {
        this.setFullScreenMode(true);
    }

    protected void show(Style style, Display dsplay, int width, int height, Image lstScreenImage, Image nxtScreenImage, AccessibleCanvas nxtCanvas, Displayable nxtDisplayable, boolean isForward) {
        this.screenWidth = width;
        this.screenHeight = height;
        this.display = dsplay;
        this.nextCanvas = nxtCanvas;
        this.nextDisplayable = nxtDisplayable;
        this.lastCanvasImage = lstScreenImage;
        if (this.useLastCanvasRgb) {
            this.lastCanvasRgb = new int[width * height];
            lstScreenImage.getRGB(this.lastCanvasRgb, 0, width, 0, 0, width, height);
        }
        this.nextCanvasImage = nxtScreenImage;
        if (this.useNextCanvasRgb) {
            this.nextCanvasRgb = new int[width * height];
            nxtScreenImage.getRGB(this.nextCanvasRgb, 0, width, 0, 0, width, height);
        }
        this.isForwardAnimation = isForward;
        this.setStyle(style);
        MasterCanvas.setCurrent(dsplay, (Displayable)this);
    }

    protected void setStyle(Style style) {
    }

    protected abstract boolean animate();

    protected abstract void paintAnimation(Graphics var1);

    public final void paint(Graphics g) {
        try {
            if (this.nextCanvasImage != null) {
                this.paintAnimation(g);
                this.display.callSerially((Runnable)this);
            }
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.ui.ScreenChangeAnimation", 215, (Object)"Unable to paint animation", e);
        }
    }

    public void showNotify() {
        this.setFullScreenMode(true);
    }

    public void hideNotify() {
    }

    public void sizeChanged(int width, int height) {
    }

    public void keyRepeated(int keyCode) {
        AccessibleCanvas next = this.nextCanvas;
        Image nextImage = this.nextCanvasImage;
        try {
            if (next != null) {
                next.keyRepeated(keyCode);
                this.updateNextScreen(next, nextImage, this.nextCanvasRgb);
            }
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.ui.ScreenChangeAnimation", 325, (Object)"Error while handling keyRepeated event", e);
        }
    }

    public void keyReleased(int keyCode) {
        AccessibleCanvas next = this.nextCanvas;
        Image nextImage = this.nextCanvasImage;
        try {
            if (next != null) {
                next.keyReleased(keyCode);
                this.updateNextScreen(next, nextImage, this.nextCanvasRgb);
            }
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.ui.ScreenChangeAnimation", 347, (Object)"Error while handling keyReleased event", e);
        }
    }

    public void keyPressed(int keyCode) {
        AccessibleCanvas next = this.nextCanvas;
        Image nextImage = this.nextCanvasImage;
        try {
            if (next != null) {
                next.keyPressed(keyCode);
                this.updateNextScreen(next, nextImage, this.nextCanvasRgb);
            }
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.ui.ScreenChangeAnimation", 369, (Object)"Error while handling keyPressed event", e);
        }
    }

    protected void updateNextScreen(AccessibleCanvas next, Image nextImage, int[] rgb) {
        Graphics g = nextImage.getGraphics();
        next.paint(g);
        if (rgb != null) {
            nextImage.getRGB(rgb, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight);
        }
    }

    public void run() {
        block5: {
            try {
                if (this.nextCanvas != null && this.animate()) {
                    MasterCanvas.repaintCanvas(MasterCanvas.instance);
                } else {
                    this.lastCanvasImage = null;
                    this.lastCanvasRgb = null;
                    this.nextCanvasImage = null;
                    this.nextCanvasRgb = null;
                    this.nextCanvas = null;
                    Display disp = this.display;
                    this.display = null;
                    Displayable next = this.nextDisplayable;
                    this.nextDisplayable = null;
                    System.gc();
                    if (disp != null && next != null) {
                        MasterCanvas.setCurrent(disp, next);
                    }
                }
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.ScreenChangeAnimation", 432, (Object)"Unable to animate", e);
                Display disp = this.display;
                Displayable next = this.nextDisplayable;
                if (disp == null || next == null) break block5;
                MasterCanvas.setCurrent(disp, next);
            }
        }
    }
}

