/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.ImageItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TabBar
extends Item {
    private final ArrayList tabs;
    private Style activeStyle;
    private Style activeFocusedStyle;
    private Style inactiveStyle;
    private Style activeStyleUsed;
    private int activeTabIndex;
    private int xOffset;
    private int scrollArrowHeight = 10;
    private int scrollArrowPadding = 2;
    private int scrollArrowColor = 0xFFFFFF;
    private Image leftArrow;
    private Image rightArrow;
    private int arrowYOffset;
    private int arrowXOffset;
    private boolean allowRoundtrip;
    private int nextTabIndex;

    public TabBar(String[] tabNames, Image[] tabImages) {
        this(tabNames, tabImages, null);
    }

    public TabBar(String[] tabNames, Image[] tabImages, Style style) {
        super(null, 0, 2, style);
        if (tabImages == null) {
            tabImages = new Image[tabNames.length];
        } else if (tabNames == null) {
            tabNames = new String[tabImages.length];
        }
        this.activeStyle = StyleSheet.activetabStyle;
        this.activeFocusedStyle = StyleSheet.activetabStyle;
        this.inactiveStyle = StyleSheet.inactivetabStyle;
        this.tabs = new ArrayList(tabNames.length);
        for (int i = 0; i < tabImages.length; ++i) {
            String name = tabNames[i];
            Image image = tabImages[i];
            ImageItem tab = new ImageItem(null, image, 0, name, this.inactiveStyle);
            tab.parent = this;
            this.tabs.add(tab);
        }
        ((ImageItem)this.tabs.get((int)0)).style = this.activeStyleUsed = this.activeStyle;
    }

    public void setActiveTab(int index) {
        ((ImageItem)this.tabs.get(this.activeTabIndex)).setStyle(this.inactiveStyle);
        this.activeTabIndex = index;
        ((ImageItem)this.tabs.get(index)).setStyle(this.activeStyleUsed);
        this.isInitialized = false;
    }

    protected Style focus(Style newStyle, int direction) {
        this.activeStyleUsed = this.activeFocusedStyle;
        ((ImageItem)this.tabs.get(this.activeTabIndex)).setStyle(this.activeFocusedStyle);
        return super.focus(newStyle, direction);
    }

    protected void defocus(Style originalStyle) {
        this.activeStyleUsed = this.activeStyle;
        ((ImageItem)this.tabs.get(this.activeTabIndex)).setStyle(this.activeStyle);
        super.defocus(originalStyle);
    }

    protected void initContent(int firstLineWidth, int lineWidth) {
        int scrollerWidth;
        int maxHeight = scrollerWidth = this.scrollArrowHeight + 2 * this.scrollArrowPadding;
        int completeWidth = 0;
        int rightBorder = lineWidth - scrollerWidth;
        if (this.allowRoundtrip || this.activeTabIndex == 0 || this.activeTabIndex == this.tabs.size() - 1) {
            if (this.activeTabIndex != 0 && !this.allowRoundtrip) {
                rightBorder = lineWidth;
            }
            lineWidth -= maxHeight;
            completeWidth = maxHeight;
        } else {
            lineWidth -= 2 * maxHeight;
            completeWidth = 2 * maxHeight;
        }
        int activeTabXPos = 0;
        int activeTabWidth = 0;
        for (int i = 0; i < this.tabs.size(); ++i) {
            ImageItem tab = (ImageItem)this.tabs.get(i);
            int tabHeight = tab.getItemHeight(firstLineWidth, lineWidth);
            if (tabHeight > maxHeight) {
                maxHeight = tabHeight;
            }
            if (i == this.activeTabIndex) {
                activeTabXPos = completeWidth;
                activeTabWidth = tab.itemWidth;
            }
            tab.relativeX = completeWidth;
            completeWidth += tab.itemWidth;
        }
        this.contentHeight = maxHeight;
        this.contentWidth = completeWidth;
        if (this.activeTabIndex == 0) {
            this.xOffset = 0;
        } else if (this.xOffset + activeTabXPos < scrollerWidth) {
            this.xOffset = scrollerWidth - activeTabXPos;
        } else if (this.xOffset + activeTabXPos + activeTabWidth > rightBorder) {
            this.xOffset = this.allowRoundtrip ? rightBorder - activeTabWidth - activeTabXPos : rightBorder - activeTabWidth - (activeTabXPos - scrollerWidth);
        }
    }

    protected void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        int halfWidth;
        g.setColor(this.scrollArrowColor);
        int cHeight = this.contentHeight;
        y += (cHeight - this.scrollArrowHeight) / 2;
        int originalX = x;
        if (this.allowRoundtrip || this.activeTabIndex > 0) {
            x += this.scrollArrowPadding;
            if (this.leftArrow != null) {
                g.drawImage(this.leftArrow, x + this.arrowXOffset, y + this.arrowYOffset, 20);
            } else {
                halfWidth = this.scrollArrowHeight >> 1;
                g.fillTriangle(x, y + halfWidth - 1, x + this.scrollArrowHeight, y, x + this.scrollArrowHeight, y + this.scrollArrowHeight);
            }
            x += this.scrollArrowHeight + this.scrollArrowPadding;
            if (this.allowRoundtrip) {
                originalX = x;
            }
        }
        if (this.allowRoundtrip || this.activeTabIndex < this.tabs.size() - 1) {
            rightBorder -= this.scrollArrowHeight + this.scrollArrowPadding;
            if (this.rightArrow != null) {
                g.drawImage(this.rightArrow, rightBorder + this.arrowXOffset, y + this.arrowYOffset, 20);
            } else {
                halfWidth = this.scrollArrowHeight / 2;
                g.fillTriangle(rightBorder, y, rightBorder, y + this.scrollArrowHeight, rightBorder + this.scrollArrowHeight, y + halfWidth - 1);
            }
            rightBorder -= this.scrollArrowPadding;
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        g.setClip(x, y -= (cHeight - this.scrollArrowHeight) / 2, rightBorder - x, clipHeight);
        x = originalX + this.xOffset;
        for (int i = 0; i < this.tabs.size(); ++i) {
            ImageItem tab = (ImageItem)this.tabs.get(i);
            int tabHeight = tab.itemHeight;
            tab.paint(x, y + (cHeight - tabHeight), leftBorder, rightBorder, g);
            x += tab.itemWidth;
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    protected String createCssSelector() {
        return "tabbar";
    }

    public void setStyle(Style style) {
        Boolean allowRoundtripBool;
        Integer arrowYOffsetInt;
        String rightArrowUrl;
        super.setStyle(style);
        String leftArrowUrl = style.getProperty(155);
        if (leftArrowUrl != null) {
            try {
                this.leftArrow = StyleSheet.getImage(leftArrowUrl, this, false);
                this.scrollArrowHeight = this.leftArrow.getHeight();
            }
            catch (IOException e) {
                Debug.debug("error", "de.enough.polish.ui.TabBar", 338, (Object)"Unable to load tabbar-left-arrow ", leftArrowUrl);
            }
        }
        if ((rightArrowUrl = style.getProperty(156)) != null) {
            try {
                this.rightArrow = StyleSheet.getImage(rightArrowUrl, this, false);
                this.scrollArrowHeight = this.rightArrow.getHeight();
            }
            catch (IOException e) {
                Debug.debug("error", "de.enough.polish.ui.TabBar", 350, (Object)"Unable to load tabbar-right-arrow ", rightArrowUrl);
            }
        }
        if ((arrowYOffsetInt = style.getIntProperty(157)) != null) {
            this.arrowYOffset = arrowYOffsetInt;
        }
        if ((allowRoundtripBool = style.getBooleanProperty(158)) != null) {
            this.allowRoundtrip = allowRoundtripBool;
        }
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        if (this.allowRoundtrip) {
            if (gameAction == 5) {
                this.nextTabIndex = this.activeTabIndex + 1;
                if (this.nextTabIndex >= this.tabs.size()) {
                    this.nextTabIndex = 0;
                }
                return true;
            }
            if (gameAction == 2) {
                this.nextTabIndex = this.activeTabIndex - 1;
                if (this.nextTabIndex < 0) {
                    this.nextTabIndex = this.tabs.size() - 1;
                }
                return true;
            }
        }
        if (gameAction == 5 && this.activeTabIndex < this.tabs.size() - 1) {
            this.nextTabIndex = this.activeTabIndex + 1;
            return true;
        }
        if (gameAction == 2 && this.activeTabIndex > 0) {
            this.nextTabIndex = this.activeTabIndex - 1;
            return true;
        }
        return super.handleKeyPressed(keyCode, gameAction);
    }

    public void setImage(int tabIndex, Image image) {
        ((ImageItem)this.tabs.get(tabIndex)).setImage(image);
    }

    public void setText(int tabIndex, String text) {
        ((ImageItem)this.tabs.get(tabIndex)).setAltText(text);
    }

    public int getNextTab() {
        return this.nextTabIndex;
    }

    public void addNewTab(String tabName, Image tabImage) {
        this.addNewTab(tabName, tabImage, this.inactiveStyle);
    }

    public void addNewTab(String tabName, Image tabImage, Style tabStyle) {
        ImageItem tab = new ImageItem(null, tabImage, 0, tabName, tabStyle);
        this.tabs.add(tab);
    }

    public void addNewTab(int index, String tabName, Image tabImage) {
        this.addNewTab(tabName, tabImage, this.inactiveStyle);
    }

    public void addNewTab(int index, String tabName, Image tabImage, Style tabStyle) {
        ImageItem tab = new ImageItem(null, tabImage, 0, tabName, tabStyle);
        this.tabs.add(index, tab);
    }

    public void removeTab(int index) {
        this.tabs.remove(index);
    }

    public Item getTabItem(int tabIndex) {
        return (Item)this.tabs.get(tabIndex);
    }

    public void setTabItem(int tabIndex, Item item) {
        this.tabs.set(tabIndex, item);
    }

    public boolean isRoundtrip() {
        return this.allowRoundtrip;
    }

    public void setRoundtrip(boolean allow) {
        this.allowRoundtrip = allow;
    }
}

