/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class OpeningBackground
extends Background {
    private boolean isAnimationRunning;
    private int currentHeight;
    private int color;
    private int startHeight;
    private int speed;
    private int maxHeight;

    public OpeningBackground(int color, int startHeight, int speed) {
        this.color = color;
        this.startHeight = startHeight;
        this.speed = speed;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        this.maxHeight = height;
        if (this.isAnimationRunning) {
            int difference = height - this.currentHeight;
            height = this.currentHeight;
            y += difference >> 1;
        }
        g.setColor(this.color);
        g.fillRect(x, y, width, height);
    }

    public boolean animate() {
        if (this.isAnimationRunning) {
            int adjust = this.speed;
            if (adjust == -1 && (adjust = (this.maxHeight - this.currentHeight) / 3) < 2) {
                adjust = 2;
            }
            this.currentHeight += adjust;
            if (this.currentHeight >= this.maxHeight) {
                this.isAnimationRunning = false;
            }
            return true;
        }
        return false;
    }

    public void showNotify() {
        super.showNotify();
        this.currentHeight = this.startHeight;
        this.isAnimationRunning = true;
    }

    public OpeningBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.color = dataInputStream.readInt();
        this.currentHeight = dataInputStream.readInt();
        this.isAnimationRunning = dataInputStream.readBoolean();
        this.maxHeight = dataInputStream.readInt();
        this.speed = dataInputStream.readInt();
        this.startHeight = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeInt(this.currentHeight);
        dataOutputStream.writeBoolean(this.isAnimationRunning);
        dataOutputStream.writeInt(this.maxHeight);
        dataOutputStream.writeInt(this.speed);
        dataOutputStream.writeInt(this.startHeight);
    }
}

