/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.chartviews;

import de.enough.polish.ui.ChartItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemView;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class PieChartView
extends ItemView {
    protected void initContent(Item parent, int firstLineWidth, int lineWidth) {
        this.initContentByParent(parent, firstLineWidth, lineWidth);
        this.contentHeight = this.contentWidth;
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        ChartItem chart = (ChartItem)parent;
        int[][] sequences = chart.getDataSequences();
        if (sequences == null) {
            return;
        }
        int[] colors = chart.getColors();
        int colorIndex = 0;
        for (int i = 0; i < sequences.length; ++i) {
            int[] dataRow = sequences[i];
            if (dataRow == null || dataRow.length == 0) continue;
            int radius = this.contentWidth - this.contentWidth / sequences.length * i;
            int top = y + (this.contentWidth - radius) / 2;
            int left = x + (this.contentWidth - radius) / 2;
            int total = 0;
            for (int j = 0; j < dataRow.length; ++j) {
                int value = dataRow[j];
                if (value < 0) {
                    value *= -1;
                }
                total += value;
            }
            int offset = 0;
            int degrees = 0;
            for (int j = 0; j < dataRow.length; ++j) {
                int color = colors[colorIndex];
                g.setColor(color);
                int value = dataRow[j];
                if (value < 0) {
                    value *= -1;
                }
                colorIndex = (colorIndex + 1) % colors.length;
                degrees = value * 100 / total * 360 / 100;
                if (j == dataRow.length - 1) {
                    g.fillArc(left, top, radius, radius, offset, 360 - offset);
                } else {
                    g.fillArc(left, top, radius, radius, offset, degrees);
                }
                offset += degrees;
            }
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
    }
}

