/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.itemviews;

import de.enough.polish.ui.AnimationThread;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemView;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.DrawUtil;
import de.enough.polish.util.ImageUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class SizeDecreaseItemView
extends ItemView {
    private int[] rgbData;
    private int[] scaledRgbData;
    private int originalHeight;
    private int targetHeight;
    private int currentHeight;
    private int sizeDecreaseAmount = 20;
    private boolean sizeDecreaseTop = true;
    private boolean isInitialized;

    protected void initContent(Item parent, int firstLineWidth, int lineWidth) {
        if (this.parentItem == parent && this.parentItem.getStyle() == parent.getStyle() && this.isInitialized) {
            return;
        }
        this.initContentByParent(parent, firstLineWidth, lineWidth);
        this.currentHeight = this.contentHeight;
        this.originalHeight = this.contentHeight;
        this.targetHeight = 0;
        int[] itemRgbData = UiAccess.getRgbDataOfContent(parent);
        this.rgbData = itemRgbData;
        AnimationThread.addAnimationItem(parent);
        this.isInitialized = true;
    }

    public boolean animate() {
        int[] data;
        int height = this.currentHeight - this.getAmount();
        if (height <= this.targetHeight) {
            height = this.targetHeight;
            AnimationThread.removeAnimationItem(this.parentItem);
        }
        if ((data = this.rgbData) != null) {
            this.scaledRgbData = ImageUtil.scale(255, data, this.contentWidth, height, this.contentWidth, this.originalHeight);
        }
        this.currentHeight = height;
        this.contentHeight = height;
        this.parentItem.requestInit();
        return true;
    }

    protected int getAmount() {
        int result = this.currentHeight / (100 / this.sizeDecreaseAmount);
        if (result < 1) {
            result = 1;
        }
        return result;
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    public void showNotify() {
        super.showNotify();
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        int[] data = this.scaledRgbData;
        if (this.currentHeight != 0) {
            if (this.currentHeight != this.targetHeight && data != null) {
                if (this.sizeDecreaseTop) {
                    DrawUtil.drawRgb(data, x, y, this.contentWidth, this.currentHeight, true, g);
                } else {
                    DrawUtil.drawRgb(data, x, y - (this.currentHeight - this.originalHeight), this.contentWidth, this.currentHeight, true, g);
                }
            } else {
                super.paintContentByParent(parent, x, y, leftBorder, rightBorder, g);
            }
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        this.currentHeight = dataInputStream.readInt();
        this.isInitialized = dataInputStream.readBoolean();
        this.originalHeight = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.rgbData = new int[n2];
            n = 0;
            while (n < n2) {
                this.rgbData[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.scaledRgbData = new int[n2];
            n = 0;
            while (n < n2) {
                this.scaledRgbData[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.sizeDecreaseAmount = dataInputStream.readInt();
        this.sizeDecreaseTop = dataInputStream.readBoolean();
        this.targetHeight = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.currentHeight);
        dataOutputStream.writeBoolean(this.isInitialized);
        dataOutputStream.writeInt(this.originalHeight);
        if (this.rgbData == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.rgbData.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.rgbData[n]);
                ++n;
            }
        }
        if (this.scaledRgbData == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.scaledRgbData.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.scaledRgbData[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.sizeDecreaseAmount);
        dataOutputStream.writeBoolean(this.sizeDecreaseTop);
        dataOutputStream.writeInt(this.targetHeight);
    }
}

