/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.AccessibleCanvas;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import de.enough.polish.util.DrawUtil;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GradientScreenChangeAnimation
extends ScreenChangeAnimation {
    private int[] currentScreenRgb;
    private int steps = 5;
    private int currentStep;

    public GradientScreenChangeAnimation() {
        this.useLastCanvasRgb = true;
        this.useNextCanvasRgb = true;
    }

    protected void show(Style style, Display dsplay, int width, int height, Image lstScreenImage, Image nxtScreenImage, AccessibleCanvas nxtCanvas, Displayable nxtDisplayable, boolean isForward) {
        super.show(style, dsplay, width, height, lstScreenImage, nxtScreenImage, nxtCanvas, nxtDisplayable, isForward);
        this.currentScreenRgb = new int[width * height];
        System.arraycopy(this.lastCanvasRgb, 0, this.currentScreenRgb, 0, width * height);
        this.currentStep = 0;
    }

    protected boolean animate() {
        if (this.currentStep < this.steps) {
            int permille = 1000 * this.currentStep / this.steps;
            for (int i = 0; i < this.currentScreenRgb.length; ++i) {
                int lastColor = this.lastCanvasRgb[i];
                int targetColor = this.nextCanvasRgb[i];
                if (lastColor == targetColor) continue;
                this.currentScreenRgb[i] = DrawUtil.getGradientColor(lastColor, targetColor, permille);
            }
            ++this.currentStep;
            return true;
        }
        this.lastCanvasRgb = null;
        this.currentScreenRgb = null;
        this.nextCanvasRgb = null;
        this.currentStep = 0;
        return false;
    }

    public void paintAnimation(Graphics g) {
        g.drawRGB(this.currentScreenRgb, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, false);
    }
}

