/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.AccessibleCanvas;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RainScreenChangeAnimation
extends ScreenChangeAnimation {
    private boolean stillRun = true;
    private int row;
    private int id;
    private int[] left;
    private int[] right;
    private int[] up;
    private int[] down;
    private int[] rgbData;
    private int[] rgbbuffer;
    private int[] lstrgbbuffer;
    private int[] scaleableHeight;
    private int[] scaleableWidth;

    protected void show(Style style, Display dsplay, int width, int height, Image lstScreenImage, Image nxtScreenImage, AccessibleCanvas nxtCanvas, Displayable nxtDisplayable, boolean isForward) {
        int i;
        System.gc();
        this.id = 12;
        this.row = 0;
        this.stillRun = true;
        int size = width * height;
        this.left = new int[height];
        this.right = new int[height];
        this.scaleableWidth = new int[height];
        for (i = 0; i < this.scaleableWidth.length; ++i) {
            this.scaleableWidth[i] = width;
            this.left[i] = 0;
            this.right[i] = width;
        }
        this.up = new int[width];
        this.down = new int[width];
        this.scaleableHeight = new int[width];
        for (i = 0; i < this.scaleableHeight.length; ++i) {
            this.scaleableHeight[i] = height;
            this.up[i] = 0;
            this.down[i] = height;
        }
        this.rgbbuffer = new int[size];
        this.lstrgbbuffer = new int[size];
        this.rgbData = new int[size];
        nxtScreenImage.getRGB(this.rgbbuffer, 0, width, 0, 0, width, height);
        lstScreenImage.getRGB(this.lstrgbbuffer, 0, width, 0, 0, width, height);
        lstScreenImage.getRGB(this.rgbData, 0, width, 0, 0, width, height);
        super.show(style, dsplay, width, height, lstScreenImage, nxtScreenImage, nxtCanvas, nxtDisplayable, isForward);
    }

    protected boolean animate() {
        this.cubeEffect();
        int length = this.rgbData.length - 1;
        int sW = 0;
        int left = 0;
        int right = this.screenWidth;
        int scalePercentWidth = this.screenWidth;
        for (int y = 0; y < this.screenHeight; ++y) {
            left = this.left[y];
            right = this.right[y];
            sW = this.scaleableWidth[y];
            scalePercentWidth = sW * 100 / this.screenWidth;
            int column = y * this.screenWidth;
            for (int x = 1; x < this.screenWidth; ++x) {
                int newI;
                int r;
                int sH = this.scaleableHeight[x];
                if (left > x || right < x || this.down[x] < y || this.up[x] > y) {
                    this.rgbData[column + x] = this.rgbbuffer[column + x];
                    continue;
                }
                int c = y - (this.screenHeight - sH);
                if (c < 1) {
                    ++c;
                }
                int scalePercentH = (this.screenHeight - (this.screenHeight - sH)) * 100 / this.screenHeight;
                this.row = left + (this.screenWidth - right) / this.screenWidth;
                if (this.row <= x) {
                    r = x - this.row;
                    scalePercentWidth = sW * 100 / this.screenWidth;
                } else {
                    r = x;
                    scalePercentWidth = this.row * 100 / this.screenWidth;
                }
                scalePercentWidth = (this.screenWidth - (this.screenWidth - sW)) * 100 / this.screenWidth;
                if (scalePercentWidth < 1) {
                    ++scalePercentWidth;
                }
                if (scalePercentH < 1) {
                    ++scalePercentH;
                }
                if ((newI = r * 100 / scalePercentWidth + this.screenWidth * (c * 100 / scalePercentH)) >= length) {
                    newI = length;
                }
                if (newI < 0) {
                    newI = 0;
                }
                this.rgbData[x + column] = this.lstrgbbuffer[newI];
            }
        }
        if (this.scaleableHeight[this.scaleableHeight.length - 1] <= 0) {
            this.stillRun = false;
        }
        return this.stillRun;
    }

    private void cubeEffect() {
        for (int i = 0; i < this.id; ++i) {
            if (this.scaleableHeight[i] <= 0) continue;
            int n = i;
            this.scaleableHeight[n] = this.scaleableHeight[n] - 20;
            int n2 = i;
            this.up[n2] = this.up[n2] + 20;
        }
        this.id += 12;
        if (this.id > this.screenWidth) {
            this.id = this.scaleableHeight.length;
        }
    }

    public void handleKeyPressed(int keyCode, Image next) {
        next.getRGB(this.rgbbuffer, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight);
    }

    public void paintAnimation(Graphics g) {
        g.drawRGB(this.rgbData, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, false);
    }
}

