/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.TextEffect;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class DropShadowTextEffect
extends TextEffect {
    private String lastText;
    private int lastTextColor;
    int[] localRgbBuffer;
    private int innerColor = -1601138544;
    private int outerColor = 0x20909090;
    private int size = 6;
    private int xOffset = 1;
    private int yOffset = 2;

    public void drawString(String text, int textColor, int x, int y, int orientation, Graphics g) {
        int iTop;
        Font font = g.getFont();
        int fHeight = font.getHeight();
        int fWidth = font.stringWidth(text);
        int newWidth = fWidth + this.size * 2;
        int newHeight = fHeight + this.size * 2;
        int iLeft = this.size - this.xOffset < 0 ? 0 : this.size - this.xOffset;
        int n = iTop = this.size - this.yOffset < 0 ? 0 : this.size - this.yOffset;
        if (this.lastText != text || this.lastTextColor != textColor) {
            this.lastText = text;
            this.lastTextColor = textColor;
            this.localRgbBuffer = DropShadowTextEffect.getRgbData(text, textColor, font, iLeft, iTop, newWidth, newHeight);
            DrawUtil.dropShadow(this.localRgbBuffer, newWidth, newHeight, this.xOffset, this.yOffset, this.size, this.innerColor, this.outerColor);
        }
        int startX = this.getLeftX(x, orientation, fWidth);
        int startY = this.getTopY(y, orientation, fHeight, font.getBaselinePosition());
        DrawUtil.drawRgb(this.localRgbBuffer, startX - iLeft, startY - iTop, newWidth, newHeight, true, g);
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        this.lastText = null;
    }

    public void releaseResources() {
        super.releaseResources();
        this.lastText = null;
        this.localRgbBuffer = null;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.innerColor = dataInputStream.readInt();
        this.lastText = (String)Serializer.deserialize(dataInputStream);
        this.lastTextColor = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.localRgbBuffer = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.localRgbBuffer[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
        this.outerColor = dataInputStream.readInt();
        this.size = dataInputStream.readInt();
        this.xOffset = dataInputStream.readInt();
        this.yOffset = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.innerColor);
        Serializer.serialize(this.lastText, dataOutputStream);
        dataOutputStream.writeInt(this.lastTextColor);
        if (this.localRgbBuffer == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.localRgbBuffer.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.localRgbBuffer[n2]);
                ++n2;
            }
        }
        dataOutputStream.writeInt(this.outerColor);
        dataOutputStream.writeInt(this.size);
        dataOutputStream.writeInt(this.xOffset);
        dataOutputStream.writeInt(this.yOffset);
    }
}

