/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import de.enough.polish.ui.TextEffect;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class FlashTextEffect
extends TextEffect {
    private int interval = 700;
    private boolean isTextVisible;
    private long lastAnimationSwitch;

    public boolean animate() {
        boolean animated = super.animate();
        long current = System.currentTimeMillis();
        if (current - this.lastAnimationSwitch > (long)this.interval) {
            this.lastAnimationSwitch = current;
            this.isTextVisible = !this.isTextVisible;
            animated = true;
        }
        return animated;
    }

    public void drawString(String text, int textColor, int x, int y, int orientation, Graphics g) {
        if (this.isTextVisible) {
            g.drawString(text, x, y, orientation);
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.interval = dataInputStream.readInt();
        this.isTextVisible = dataInputStream.readBoolean();
        this.lastAnimationSwitch = dataInputStream.readLong();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.interval);
        dataOutputStream.writeBoolean(this.isTextVisible);
        dataOutputStream.writeLong(this.lastAnimationSwitch);
    }
}

