/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.log.LogEntry;
import de.enough.polish.ui.Form;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.ArrayList;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;

public final class Debug
implements CommandListener {
    public static boolean suppressMessages;
    public static final Command RETURN_COMMAND;
    private static Displayable returnDisplayable;
    private static Display midletDisplay;
    private static TextBox textBox;
    private static final ArrayList MESSAGES;

    public static final void debug(String level, String className, int lineNumber, Object message, Object exception) {
        if (exception instanceof Throwable) {
            Debug.debug(level, className, lineNumber, message, (Throwable)exception);
        } else {
            Debug.debug(level, className, lineNumber, message.toString() + exception);
        }
    }

    public static final void debug(String level, String className, int lineNumber, Object message, char value) {
        Debug.debug(level, className, lineNumber, message.toString() + value);
    }

    public static final void debug(String level, String className, int lineNumber, Object message, int value) {
        Debug.debug(level, className, lineNumber, message.toString() + value);
    }

    public static final void debug(String level, String className, int lineNumber, Object message, long value) {
        Debug.debug(level, className, lineNumber, message.toString() + value);
    }

    public static final void debug(String level, String className, int lineNumber, Object message, short value) {
        Debug.debug(level, className, lineNumber, message.toString() + value);
    }

    public static final void debug(String level, String className, int lineNumber, Object message, byte value) {
        Debug.debug(level, className, lineNumber, message.toString() + value);
    }

    public static final void debug(String level, String className, int lineNumber, Object message, float value) {
        Debug.debug(level, className, lineNumber, message.toString() + value);
    }

    public static final void debug(String level, String className, int lineNumber, Object message, double value) {
        Debug.debug(level, className, lineNumber, message.toString() + value);
    }

    public static final void debug(String level, String className, int lineNumber, Object message, boolean value) {
        Debug.debug(level, className, lineNumber, message.toString() + value);
    }

    public static final void debug(String level, String className, int lineNumber, Object message) {
        Debug.debug(level, className, lineNumber, message, null);
    }

    public static final void debug(String level, String className, int lineNumber, Throwable exception) {
        Debug.debug(level, className, lineNumber, (Object)"Error", exception);
    }

    public static final void debug(String level, String className, int lineNumber, Object message, Throwable exception) {
        if (suppressMessages) {
            return;
        }
        String exceptionMessage = null;
        if (exception != null) {
            exceptionMessage = exception.toString();
        }
        LogEntry logEntry = new LogEntry(className, lineNumber, System.currentTimeMillis(), level, message.toString(), exceptionMessage);
        System.out.println(logEntry.toString());
        if (exception != null) {
            exception.printStackTrace();
        }
        MESSAGES.add(logEntry);
        if (MESSAGES.size() > 98) {
            MESSAGES.remove(0);
        }
        if (textBox != null) {
            Debug.addMessages();
        }
        if (exception != null && textBox == null) {
            Debug.showLog(StyleSheet.display);
        }
    }

    public static final Form getLogForm(boolean reverseSort, CommandListener listener) {
        LogEntry[] entries = (LogEntry[])MESSAGES.toArray(new LogEntry[MESSAGES.size()]);
        Item[] items = new StringItem[entries.length];
        int index = entries.length - 1;
        for (int i = 0; i < items.length; ++i) {
            LogEntry entry;
            if (reverseSort) {
                entry = entries[index];
                --index;
            } else {
                entry = entries[i];
            }
            items[i] = new StringItem(null, entry.toString());
        }
        Form form = new Form("Log", items);
        form.setCommandListener(listener);
        form.addCommand(RETURN_COMMAND);
        return form;
    }

    public static void showLog(Display display) {
        if (display == null) {
            System.err.println("Unable to show log with null-Display.");
            return;
        }
        Displayable currentDisplayable = MasterCanvas.getCurrent(display);
        if (returnDisplayable != currentDisplayable) {
            returnDisplayable = currentDisplayable;
            midletDisplay = display;
            textBox = new TextBox("Log", null, 4096, 0);
            int maxSize = textBox.getMaxSize();
            textBox.setMaxSize(maxSize);
            Debug.addMessages();
            textBox.addCommand(RETURN_COMMAND);
            textBox.setCommandListener((CommandListener)new Debug());
        }
        MasterCanvas.setCurrent(display, (Displayable)textBox);
    }

    private static final void addMessages() {
        StringBuffer buffer = new StringBuffer();
        int maxSize = textBox.getMaxSize();
        if (maxSize <= 0) {
            maxSize = 10000;
        }
        LogEntry[] entries = (LogEntry[])MESSAGES.toArray(new LogEntry[MESSAGES.size()]);
        for (int i = entries.length - 1; buffer.length() < maxSize && i >= 0; --i) {
            buffer.append(entries[i].toString()).append('\n');
        }
        if (buffer.length() >= maxSize) {
            buffer.delete(maxSize - 1, buffer.length());
        }
        textBox.setString(buffer.toString());
    }

    public void commandAction(Command cmd, Displayable screen) {
        textBox = null;
        Display disp = midletDisplay;
        midletDisplay = null;
        Displayable returnDisp = returnDisplayable;
        returnDisplayable = null;
        MasterCanvas.setCurrent(disp, returnDisp);
    }

    public static void exit() {
    }

    static {
        RETURN_COMMAND = new Command("Return", 1, 1);
        MESSAGES = new ArrayList(100);
    }
}

