/*
 * Decompiled with CFR 0.152.
 */
package com.myweather.ui;

import com.myweather.constants.CommandConstants;
import com.myweather.constants.GeneralConstants;
import com.myweather.midlet.MyWeatherMidlet;
import com.myweather.ui.ChargeUI;
import com.myweather.ui.LifeStyleUI;
import com.myweather.ui.MainUI;
import com.myweather.util.BasicFunction;
import com.myweather.valueobject.ForecastDay;
import com.myweather.valueobject.LifeStyle;
import de.enough.polish.ui.Alert;
import de.enough.polish.ui.ImageItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.ScreenStateListener;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TabbedForm;
import de.enough.polish.ui.TableItem;
import de.enough.polish.util.Debug;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CityDetailUI
extends TabbedForm
implements ScreenStateListener,
CommandListener,
Runnable,
ItemCommandListener {
    public Object SYNC_OBJ = new Object();
    public Thread imageryThread;
    private int imageryIndex = 0;
    private Image imagery = null;
    public boolean stopped = false;
    private LifeStyle lifeStyle;
    private int lastTabIndex;
    private ForecastDay forecastDay;
    TableItem lifeStyleTable1;
    TableItem lifeStyleTable3;
    public MainUI mainUI;
    int lifeStyleIndex = 0;
    int pageFirstNum = 1;
    int pageCount = 2;
    int pageNum = 1;
    int totalDay = 5;
    int col = 0;
    int row = 0;
    boolean clickedNext = false;
    boolean clickDown = false;
    boolean clickUp = false;
    boolean clickDownForecast = false;
    boolean clickUpForecast = false;
    public ChargeUI chargeUI;

    public CityDetailUI(String[] headings, MainUI mainUI, Style style) throws IOException {
        super("", headings, null, style);
        this.mainUI = mainUI;
        this.chargeUI = new ChargeUI((Displayable)this, StyleSheet.addcityscreenStyle);
        this.addCommand(CommandConstants.BACK);
        this.addCommand(CommandConstants.NEXTPAGE);
        this.setScreenStateListener(this);
        this.setCommandListener(this);
        ImageItem imgSatelliteItem = new ImageItem(null, GeneralConstants.RADAR_BASE_MAP, 512, null);
        this.append(2, imgSatelliteItem);
    }

    public CityDetailUI(String[] headings, MainUI mainUI) throws IOException {
        super("", headings, null);
        this.mainUI = mainUI;
    }

    public void showSatellite() {
    }

    public void showForecastDayList(ForecastDay forecastDay, int pageFirstNum) throws IOException {
        this.forecastDay = forecastDay;
        int size = forecastDay.forecastDayList.size();
        TableItem forecastTable = new TableItem(size, 1, StyleSheet.daytableStyle);
        TableItem forecastTableHigh = new TableItem(size, 1, StyleSheet.daytableStyle);
        Image imgsky = null;
        Image imgsky2 = null;
        for (int i = pageFirstNum; i < pageFirstNum + this.pageCount; ++i) {
            TableItem imgSkyTable = new TableItem(2, 1);
            imgSkyTable.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
            Hashtable forecastDayTable = (Hashtable)forecastDay.forecastDayList.elementAt(i);
            TableItem dayTable = new TableItem(1, 6, StyleSheet.daytableStyle);
            TableItem dayTable4 = new TableItem(1, 6, StyleSheet.daytableStyle);
            dayTable.set(0, 0, BasicFunction.transformWeekday((String)forecastDayTable.get("day")), StyleSheet.daytablecellStyle);
            dayTable4.set(0, 0, BasicFunction.transformWeekday((String)forecastDayTable.get("day")), StyleSheet.daytablecellStyle);
            dayTable.set(0, 1, BasicFunction.formatDate(i), StyleSheet.daytablecellStyle);
            dayTable4.set(0, 1, BasicFunction.formatDate(i), StyleSheet.daytablecellStyle);
            if (!("".equals(forecastDayTable.get("icon-select2")) || "".equals(forecastDayTable.get("low")) || "-49".equals(forecastDayTable.get("low")))) {
                String skyConditions = "\u6674";
                String skyConditions2 = "\u6674";
                for (int j = 0; j < GeneralConstants.SKY_CONDITIONS.length; ++j) {
                    if (GeneralConstants.SKY_CONDITIONS[j][0].equals(forecastDayTable.get("sky-conditions"))) {
                        skyConditions = GeneralConstants.SKY_CONDITIONS[j][2];
                    }
                    if (GeneralConstants.SKY_CONDITIONS[j][0].equals(forecastDayTable.get("sky-conditions2"))) {
                        skyConditions2 = GeneralConstants.SKY_CONDITIONS[j][2];
                    }
                    if (GeneralConstants.SKY_CONDITIONS[j][0].equals(forecastDayTable.get("sky-conditions"))) {
                        imgsky = Image.createImage((String)GeneralConstants.SKY_CONDITIONS[j][1]);
                    }
                    if (!GeneralConstants.SKY_CONDITIONS[j][0].equals(forecastDayTable.get("sky-conditions2"))) continue;
                    imgsky2 = Image.createImage((String)GeneralConstants.SKY_CONDITIONS[j][1]);
                }
                if (imgsky == null) {
                    imgsky = GeneralConstants.NAWEATHER_IMAGE_L;
                }
                if (imgsky2 == null) {
                    imgsky2 = GeneralConstants.NAWEATHER_IMAGE_L;
                }
                ImageItem imgClearItem = new ImageItem("", imgsky, 0, null);
                ImageItem imgClearItem2 = new ImageItem("", imgsky2, 0, null);
                imgSkyTable.set(0, 0, imgClearItem, StyleSheet.blanktablecellStyle);
                imgSkyTable.set(1, 0, imgClearItem2, StyleSheet.blanktablecellStyle);
                dayTable.set(0, 2, imgSkyTable, StyleSheet.daytablecellStyle);
                dayTable4.set(0, 2, imgSkyTable, StyleSheet.daytablecellStyle);
                dayTable.set(0, 3, skyConditions, StyleSheet.daytablecellStyle);
                dayTable4.set(0, 3, skyConditions, StyleSheet.daytablecellStyle);
                dayTable.set(0, 4, skyConditions2, StyleSheet.daytablecell2Style);
                dayTable4.set(0, 4, skyConditions2, StyleSheet.daytablecell2Style);
                dayTable.set(0, 5, BasicFunction.temperatureConverter(forecastDayTable.get("low")) + "/" + BasicFunction.temperatureConverter(forecastDayTable.get("high")), StyleSheet.daytablecellStyle);
                dayTable4.set(0, 5, BasicFunction.temperatureConverter(forecastDayTable.get("low")) + "/" + BasicFunction.temperatureConverter(forecastDayTable.get("high")), StyleSheet.daytablecellStyle);
            } else {
                ImageItem imgItem = new ImageItem(null, GeneralConstants.NA, 0, null);
                dayTable.set(0, 2, imgItem, StyleSheet.daytablecellimageStyle);
                dayTable4.set(0, 2, imgItem, StyleSheet.daytablecellimageStyle);
                dayTable.set(0, 3, "", StyleSheet.daytablecellStyle);
                dayTable4.set(0, 3, "", StyleSheet.daytablecellStyle);
                dayTable.set(0, 4, "", StyleSheet.daytablecell2Style);
                dayTable4.set(0, 4, "", StyleSheet.daytablecell2Style);
                dayTable.set(0, 5, "-/-", StyleSheet.daytablecellStyle);
                dayTable4.set(0, 5, "-/-", StyleSheet.daytablecellStyle);
            }
            dayTable.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
            dayTable4.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
            forecastTable.set(i, 0, dayTable, StyleSheet.forecastcellStyle);
            forecastTableHigh.set(i, 0, dayTable4, StyleSheet.forecastcellhighlightStyle);
        }
        forecastTable.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
        forecastTableHigh.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
        this.append(0, forecastTable);
        this.append(4, forecastTableHigh);
    }

    public void setPreForecastDayList(ForecastDay forecastDay, int firstNum) throws IOException {
        int size = forecastDay.forecastDayList.size();
        TableItem forecastTable = new TableItem(size, 1, StyleSheet.daytableStyle);
        TableItem forecastTableHigh = new TableItem(size, 1, StyleSheet.daytableStyle);
        int tempFirstNum = 0;
        if (firstNum > 0) {
            tempFirstNum = firstNum - 1;
        }
        Image imgsky = null;
        Image imgsky2 = null;
        for (int i = tempFirstNum; i < tempFirstNum + this.pageCount; ++i) {
            TableItem imgSkyTable = new TableItem(2, 1);
            imgSkyTable.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
            Hashtable forecastDayTable = (Hashtable)forecastDay.forecastDayList.elementAt(i);
            TableItem dayTable = new TableItem(1, 6, StyleSheet.daytableStyle);
            TableItem dayTable4 = new TableItem(1, 6, StyleSheet.daytableStyle);
            dayTable.set(0, 0, BasicFunction.transformWeekday((String)forecastDayTable.get("day")), StyleSheet.daytablecellStyle);
            dayTable4.set(0, 0, BasicFunction.transformWeekday((String)forecastDayTable.get("day")), StyleSheet.daytablecellStyle);
            dayTable.set(0, 1, BasicFunction.formatDate(i), StyleSheet.daytablecellStyle);
            dayTable4.set(0, 1, BasicFunction.formatDate(i), StyleSheet.daytablecellStyle);
            if (!("".equals(forecastDayTable.get("icon-select2")) || "".equals(forecastDayTable.get("low")) || "-49".equals(forecastDayTable.get("low")))) {
                String skyConditions = "\u6674";
                String skyConditions2 = "\u6674";
                for (int j = 0; j < GeneralConstants.SKY_CONDITIONS.length; ++j) {
                    if (GeneralConstants.SKY_CONDITIONS[j][0].equals(forecastDayTable.get("sky-conditions"))) {
                        skyConditions = GeneralConstants.SKY_CONDITIONS[j][2];
                    }
                    if (GeneralConstants.SKY_CONDITIONS[j][0].equals(forecastDayTable.get("sky-conditions2"))) {
                        skyConditions2 = GeneralConstants.SKY_CONDITIONS[j][2];
                    }
                    if (GeneralConstants.SKY_CONDITIONS[j][0].equals(forecastDayTable.get("sky-conditions"))) {
                        imgsky = Image.createImage((String)GeneralConstants.SKY_CONDITIONS[j][1]);
                    }
                    if (!GeneralConstants.SKY_CONDITIONS[j][0].equals(forecastDayTable.get("sky-conditions2"))) continue;
                    imgsky2 = Image.createImage((String)GeneralConstants.SKY_CONDITIONS[j][1]);
                }
                if (imgsky == null) {
                    imgsky = GeneralConstants.NAWEATHER_IMAGE_L;
                }
                if (imgsky2 == null) {
                    imgsky2 = GeneralConstants.NAWEATHER_IMAGE_L;
                }
                ImageItem imgClearItem = new ImageItem("", imgsky, 0, null);
                ImageItem imgClearItem2 = new ImageItem("", imgsky2, 0, null);
                imgSkyTable.set(0, 0, imgClearItem, StyleSheet.blanktablecellStyle);
                imgSkyTable.set(1, 0, imgClearItem2, StyleSheet.blanktablecellStyle);
                dayTable.set(0, 2, imgSkyTable, StyleSheet.daytablecellStyle);
                dayTable4.set(0, 2, imgSkyTable, StyleSheet.daytablecellStyle);
                dayTable.set(0, 3, skyConditions, StyleSheet.daytablecellStyle);
                dayTable4.set(0, 3, skyConditions, StyleSheet.daytablecellStyle);
                dayTable.set(0, 4, skyConditions2, StyleSheet.daytablecell2Style);
                dayTable4.set(0, 4, skyConditions2, StyleSheet.daytablecell2Style);
                dayTable.set(0, 5, BasicFunction.temperatureConverter(forecastDayTable.get("low")) + "/" + BasicFunction.temperatureConverter(forecastDayTable.get("high")), StyleSheet.daytablecellStyle);
                dayTable4.set(0, 5, BasicFunction.temperatureConverter(forecastDayTable.get("low")) + "/" + BasicFunction.temperatureConverter(forecastDayTable.get("high")), StyleSheet.daytablecellStyle);
            } else {
                ImageItem imgItem = new ImageItem(null, GeneralConstants.NA, 0, null);
                dayTable.set(0, 2, imgItem, StyleSheet.daytablecellimageStyle);
                dayTable4.set(0, 2, imgItem, StyleSheet.daytablecellimageStyle);
                dayTable.set(0, 3, "", StyleSheet.daytablecellStyle);
                dayTable4.set(0, 3, "", StyleSheet.daytablecellStyle);
                dayTable.set(0, 4, "", StyleSheet.daytablecell2Style);
                dayTable4.set(0, 4, "", StyleSheet.daytablecell2Style);
                dayTable.set(0, 5, "-/-", StyleSheet.daytablecellStyle);
                dayTable4.set(0, 5, "-/-", StyleSheet.daytablecellStyle);
            }
            dayTable.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
            dayTable4.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
            forecastTable.set(i, 0, dayTable, StyleSheet.forecastcellStyle);
            forecastTableHigh.set(i, 0, dayTable4, StyleSheet.forecastcellhighlightStyle);
        }
        forecastTable.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
        forecastTableHigh.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
        this.set(0, 0, forecastTable);
        this.set(4, 0, forecastTableHigh);
    }

    public void setNextForecastDayList(ForecastDay forecastDay, int firstNum) throws IOException {
        int size = forecastDay.forecastDayList.size();
        TableItem forecastTable = new TableItem(size, 1, StyleSheet.daytableStyle);
        TableItem forecastTableHigh = new TableItem(size, 1, StyleSheet.daytableStyle);
        Image imgsky = null;
        Image imgsky2 = null;
        for (int i = firstNum - 1; i < firstNum + this.pageCount - 1; ++i) {
            TableItem imgSkyTable = new TableItem(2, 1);
            imgSkyTable.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
            Hashtable forecastDayTable = (Hashtable)forecastDay.forecastDayList.elementAt(i);
            TableItem dayTable = new TableItem(1, 6, StyleSheet.daytableStyle);
            TableItem dayTable4 = new TableItem(1, 6, StyleSheet.daytableStyle);
            dayTable.set(0, 0, BasicFunction.transformWeekday((String)forecastDayTable.get("day")), StyleSheet.daytablecellStyle);
            dayTable4.set(0, 0, BasicFunction.transformWeekday((String)forecastDayTable.get("day")), StyleSheet.daytablecellStyle);
            dayTable.set(0, 1, BasicFunction.formatDate(i), StyleSheet.daytablecellStyle);
            dayTable4.set(0, 1, BasicFunction.formatDate(i), StyleSheet.daytablecellStyle);
            if (!("".equals(forecastDayTable.get("icon-select2")) || "".equals(forecastDayTable.get("low")) || "-49".equals(forecastDayTable.get("low")))) {
                String skyConditions = "\u6674";
                String skyConditions2 = "\u6674";
                for (int j = 0; j < GeneralConstants.SKY_CONDITIONS.length; ++j) {
                    if (GeneralConstants.SKY_CONDITIONS[j][0].equals(forecastDayTable.get("sky-conditions"))) {
                        skyConditions = GeneralConstants.SKY_CONDITIONS[j][2];
                    }
                    if (GeneralConstants.SKY_CONDITIONS[j][0].equals(forecastDayTable.get("sky-conditions2"))) {
                        skyConditions2 = GeneralConstants.SKY_CONDITIONS[j][2];
                    }
                    if (GeneralConstants.SKY_CONDITIONS[j][0].equals(forecastDayTable.get("sky-conditions"))) {
                        imgsky = Image.createImage((String)GeneralConstants.SKY_CONDITIONS[j][1]);
                    }
                    if (!GeneralConstants.SKY_CONDITIONS[j][0].equals(forecastDayTable.get("sky-conditions2"))) continue;
                    imgsky2 = Image.createImage((String)GeneralConstants.SKY_CONDITIONS[j][1]);
                }
                if (imgsky == null) {
                    imgsky = GeneralConstants.NAWEATHER_IMAGE_L;
                }
                if (imgsky2 == null) {
                    imgsky2 = GeneralConstants.NAWEATHER_IMAGE_L;
                }
                ImageItem imgClearItem = new ImageItem("", imgsky, 0, null);
                ImageItem imgClearItem2 = new ImageItem("", imgsky2, 0, null);
                imgSkyTable.set(0, 0, imgClearItem, StyleSheet.blanktablecellStyle);
                imgSkyTable.set(1, 0, imgClearItem2, StyleSheet.blanktablecellStyle);
                dayTable.set(0, 2, imgSkyTable, StyleSheet.daytablecellStyle);
                dayTable4.set(0, 2, imgSkyTable, StyleSheet.daytablecellStyle);
                dayTable.set(0, 3, skyConditions, StyleSheet.daytablecellStyle);
                dayTable4.set(0, 3, skyConditions, StyleSheet.daytablecellStyle);
                dayTable.set(0, 4, skyConditions2, StyleSheet.daytablecell2Style);
                dayTable4.set(0, 4, skyConditions2, StyleSheet.daytablecell2Style);
                dayTable.set(0, 5, BasicFunction.temperatureConverter(forecastDayTable.get("low")) + "/" + BasicFunction.temperatureConverter(forecastDayTable.get("high")), StyleSheet.daytablecellStyle);
                dayTable4.set(0, 5, BasicFunction.temperatureConverter(forecastDayTable.get("low")) + "/" + BasicFunction.temperatureConverter(forecastDayTable.get("high")), StyleSheet.daytablecellStyle);
            } else {
                ImageItem imgItem = new ImageItem(null, GeneralConstants.NA, 0, null);
                dayTable.set(0, 2, imgItem, StyleSheet.daytablecellimageStyle);
                dayTable4.set(0, 2, imgItem, StyleSheet.daytablecellimageStyle);
                dayTable.set(0, 3, "", StyleSheet.daytablecellStyle);
                dayTable4.set(0, 3, "", StyleSheet.daytablecellStyle);
                dayTable.set(0, 4, "", StyleSheet.daytablecell2Style);
                dayTable4.set(0, 4, "", StyleSheet.daytablecell2Style);
                dayTable.set(0, 5, "-/-", StyleSheet.daytablecellStyle);
                dayTable4.set(0, 5, "-/-", StyleSheet.daytablecellStyle);
            }
            dayTable.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
            dayTable4.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
            forecastTable.set(i, 0, dayTable, StyleSheet.forecastcellStyle);
            forecastTableHigh.set(i, 0, dayTable4, StyleSheet.forecastcellhighlightStyle);
        }
        forecastTable.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
        forecastTableHigh.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
        this.set(0, 0, forecastTable);
        this.set(4, 0, forecastTableHigh);
    }

    public void showLifeStyleList(LifeStyle lifeStyle) {
        this.lifeStyle = lifeStyle;
        int size = lifeStyle.lifeStyleList.size();
        this.lifeStyleTable1 = new TableItem(3, 2, StyleSheet.lifestyletableStyle);
        this.lifeStyleTable3 = new TableItem(3, 2, StyleSheet.lifestyletableStyle);
        for (int i = 0; i < 6; ++i) {
            Hashtable hasTable = (Hashtable)lifeStyle.lifeStyleList.elementAt(i);
            TableItem lifeTable = new TableItem(1, 3, StyleSheet.lifestylecelltableStyle);
            TableItem titleTable = new TableItem(2, 1, StyleSheet.daytableStyle);
            titleTable.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
            titleTable.set(0, 0, hasTable.get("title"), StyleSheet.lifestyletitleStyle);
            titleTable.set(1, 0, hasTable.get("index"), StyleSheet.lifestylenumcellStyle);
            lifeTable.set(0, 0, titleTable, StyleSheet.lifestylecellStyle);
            lifeTable.set(0, 1, "\u7b49\u7ea7:" + hasTable.get("scope"), StyleSheet.lifestyleindexStyle);
            String suggestion = (String)hasTable.get("suggestion");
            lifeTable.set(0, 2, BasicFunction.cutString(suggestion, 2), StyleSheet.lifestylecellStyle);
            lifeTable.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
            int m = 0;
            int n = 0;
            m = i / 3;
            n = i % 3;
            this.lifeStyleTable1.set(n, m, lifeTable);
            this.lifeStyleTable3.set(n, m, lifeTable);
        }
        this.lifeStyleTable1.setSelectionMode(2);
        this.lifeStyleTable1.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
        this.lifeStyleTable3.setSelectionMode(2);
        this.lifeStyleTable3.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
        this.append(1, this.lifeStyleTable1);
        this.append(3, this.lifeStyleTable3);
    }

    public void commandAction(Command command, Displayable disp) {
        block13: {
            if (command == CommandConstants.BACK) {
                this.stopped = true;
                MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this.mainUI);
            } else if (command == CommandConstants.NEXTPAGE) {
                try {
                    ++this.pageNum;
                    if (this.pageNum >= 3 && GeneralConstants.IS_FREE) {
                        --this.pageNum;
                        MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this.chargeUI);
                        break block13;
                    }
                    ++this.pageFirstNum;
                    this.setNextForecastDayList(this.forecastDay, this.pageFirstNum);
                    MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this);
                    this.clickedNext = true;
                    if (this.pageNum == this.totalDay - 1) {
                        this.removeCommand(CommandConstants.NEXTPAGE);
                    }
                    this.addCommand(CommandConstants.PREPAGE);
                    MasterCanvas.repaintCanvas(this);
                }
                catch (IOException e) {
                    Debug.debug("error", "com.myweather.ui.CityDetailUI", 578, e);
                }
            } else if (command == CommandConstants.PREPAGE) {
                try {
                    --this.pageFirstNum;
                    --this.pageNum;
                    this.setPreForecastDayList(this.forecastDay, this.pageFirstNum);
                    this.clickedNext = false;
                    MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this);
                    this.addCommand(CommandConstants.NEXTPAGE);
                    if (this.pageNum == 1) {
                        this.removeCommand(CommandConstants.PREPAGE);
                    }
                    MasterCanvas.repaintCanvas(this);
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            } else {
                Alert alert = new Alert("Notification", "The command \"" + command.getLabel() + "\" is currently not supported.", null, AlertType.INFO, StyleSheet.notificationalertStyle);
                MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)alert);
            }
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.getActiveTab() == 0 || this.getActiveTab() == 4) {
            int firstWidth = 75;
            if (this.totalDay == 3) {
                firstWidth = 95;
            }
            for (int i = 0; i < this.totalDay; ++i) {
                if (i == this.pageNum - 1 || i == this.pageNum) {
                    g.setColor(33, 56, 18);
                } else {
                    g.setColor(91, 129, 54);
                }
                g.fillArc(firstWidth + i * 20, 275, 10, 10, 0, 360);
                g.drawArc(firstWidth + i * 20, 275, 10, 10, 0, 360);
            }
        }
        if (this.getActiveTab() == 2 && this.imagery != null) {
            g.drawImage(this.imagery, this.getWidth(), 80, 24);
        }
    }

    public void keyPressed(int keyCode) {
        int tabIndex;
        int gameAction = this.getGameAction(keyCode);
        this.lastTabIndex = tabIndex = this.getActiveTab();
        try {
            if (this.isMenuOpened() || gameAction != 8) {
                if (gameAction == 2 && !this.clickDown && !this.clickDownForecast) {
                    this.screenStateChanged(this);
                    if (GeneralConstants.IS_FREE) {
                        MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this.chargeUI);
                        throw new Exception("charge");
                    }
                    if (tabIndex == 0) {
                        this.setActiveTab(2);
                        this.resume();
                    } else {
                        this.stopped = true;
                        this.setActiveTab(tabIndex - 1);
                    }
                    if (tabIndex == 1) {
                        if (this.pageNum == this.totalDay - 1) {
                            this.addCommand(CommandConstants.PREPAGE);
                        } else if (this.pageNum == 1) {
                            this.addCommand(CommandConstants.NEXTPAGE);
                        } else {
                            this.addCommand(CommandConstants.PREPAGE);
                            this.addCommand(CommandConstants.NEXTPAGE);
                        }
                    } else {
                        this.removeCommand(CommandConstants.NEXTPAGE);
                        this.removeCommand(CommandConstants.PREPAGE);
                    }
                    if (!GeneralConstants.IS_FREE) {
                        this.lifeStyleTable1.isFocused = false;
                    }
                } else if (gameAction == 5 && !this.clickDown && !this.clickDownForecast) {
                    this.screenStateChanged(this);
                    if (GeneralConstants.IS_FREE) {
                        MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this.chargeUI);
                        throw new Exception("charge");
                    }
                    if (tabIndex == 2) {
                        this.stopped = true;
                        this.setActiveTab(0);
                    } else if (tabIndex == 1) {
                        this.setActiveTab(tabIndex + 1);
                        this.resume();
                    } else {
                        this.setActiveTab(tabIndex + 1);
                    }
                    if (tabIndex == 2) {
                        if (this.pageNum == this.totalDay - 1) {
                            this.addCommand(CommandConstants.PREPAGE);
                        } else if (this.pageNum == 1) {
                            this.addCommand(CommandConstants.NEXTPAGE);
                        } else {
                            this.addCommand(CommandConstants.PREPAGE);
                            this.addCommand(CommandConstants.NEXTPAGE);
                        }
                    } else {
                        this.removeCommand(CommandConstants.NEXTPAGE);
                        this.removeCommand(CommandConstants.PREPAGE);
                    }
                    if (!GeneralConstants.IS_FREE) {
                        this.lifeStyleTable1.isFocused = false;
                    }
                } else if (gameAction == 5 && this.clickDown) {
                    if (this.col < 2) {
                        ++this.col;
                    } else {
                        this.col = 0;
                        this.row = this.row == 0 ? 1 : 0;
                    }
                    this.lifeStyleTable3.setSelectedCell(this.col, this.row);
                } else if (gameAction == 2 && this.clickDown) {
                    if (this.col > 0) {
                        --this.col;
                    } else {
                        this.col = 2;
                        this.row = this.row == 0 ? 1 : 0;
                    }
                    this.lifeStyleTable3.setSelectedCell(this.col, this.row);
                } else if (gameAction == 5 && this.clickDownForecast) {
                    if (this.pageNum < this.totalDay - 1) {
                        this.handleCommand(CommandConstants.NEXTPAGE);
                    }
                } else if (gameAction == 2 && this.clickDownForecast) {
                    if (this.pageNum > 1) {
                        this.handleCommand(CommandConstants.PREPAGE);
                    }
                } else if (gameAction == 6 && (tabIndex == 1 || tabIndex == 3)) {
                    if (!this.clickDown) {
                        this.setActiveTab(3);
                        this.lifeStyleTable3.isFocused = true;
                        this.col = 1;
                        this.lifeStyleTable3.setSelectedCell(this.col, this.row);
                        this.lifeStyleTable3.addCommand(CommandConstants.OPEN_LIFESTYLE);
                        this.lifeStyleTable3.setItemCommandListener(this);
                        this.clickDown = true;
                        this.clickUp = false;
                    } else {
                        this.row = 1;
                        this.lifeStyleTable3.setSelectedCell(this.col, this.row);
                    }
                } else if (gameAction == 1 && (tabIndex == 1 || tabIndex == 3)) {
                    if (this.row == 0) {
                        this.setActiveTab(1);
                        this.lifeStyleTable3.isFocused = false;
                        this.lifeStyleTable1.isFocused = false;
                        this.clickUp = true;
                        this.clickDown = false;
                    } else {
                        --this.row;
                        this.lifeStyleTable3.setSelectedCell(this.col, this.row);
                    }
                } else if (gameAction == 6 && tabIndex == 0) {
                    if (!this.clickDownForecast) {
                        this.setActiveTab(4);
                        this.clickDownForecast = true;
                        this.clickUpForecast = false;
                    }
                } else if (gameAction == 1 && tabIndex == 4) {
                    this.setActiveTab(0);
                    this.clickUpForecast = true;
                    this.clickDownForecast = false;
                } else {
                    super.keyPressed(keyCode);
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public void screenStateChanged(Screen screen) {
        int tabIndex;
        if (screen == this && (tabIndex = this.getActiveTab()) != this.lastTabIndex) {
            this.lastTabIndex = tabIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stopped) {
            System.out.println("imagery start" + this.stopped);
            ++this.imageryIndex;
            if (this.imageryIndex > 3) {
                this.imageryIndex = 1;
            }
            if (this.imageryIndex == 1 && GeneralConstants.RADAR_IMAGE1 != null) {
                this.imagery = GeneralConstants.RADAR_IMAGE1;
            }
            if (this.imageryIndex == 2 && GeneralConstants.RADAR_IMAGE2 != null) {
                this.imagery = GeneralConstants.RADAR_IMAGE2;
            }
            if (this.imageryIndex == 3 && GeneralConstants.RADAR_IMAGE3 != null) {
                this.imagery = GeneralConstants.RADAR_IMAGE3;
            }
            MasterCanvas.repaintCanvas(this);
            Object object = this.SYNC_OBJ;
            synchronized (object) {
                try {
                    this.SYNC_OBJ.wait(1500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.stopped) continue;
            break;
        }
    }

    public void resume() {
        this.stopped = false;
        if (this.imageryThread != null && this.imageryThread.isAlive()) {
            this.forceNotify();
        } else {
            this.imageryThread = new Thread(this);
            this.imageryThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceNotify() {
        Object object = this.SYNC_OBJ;
        synchronized (object) {
            try {
                this.SYNC_OBJ.notifyAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceWait() {
        Object object = this.SYNC_OBJ;
        synchronized (object) {
            try {
                this.SYNC_OBJ.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void commandAction(Command c, Item item) {
        if (c == CommandConstants.OPEN_LIFESTYLE) {
            int rowIndex = this.lifeStyleTable3.getSelectedRow();
            int colIndex = this.lifeStyleTable3.getSelectedColumn();
            System.out.println("rowIndex:colIndex=" + rowIndex + ":" + colIndex);
            Hashtable selectedHasTable = new Hashtable();
            if (rowIndex == 0) {
                selectedHasTable = (Hashtable)this.lifeStyle.lifeStyleList.elementAt(colIndex);
            }
            if (rowIndex == 1) {
                selectedHasTable = (Hashtable)this.lifeStyle.lifeStyleList.elementAt(colIndex + 3);
            }
            LifeStyleUI lifeStyleUI = new LifeStyleUI(this, selectedHasTable, StyleSheet.setlifestyleuiStyle);
            MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)lifeStyleUI);
        }
    }
}

