/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.browser.html;

import de.enough.polish.browser.html.FormListener;
import de.enough.polish.browser.html.HtmlSelect;
import de.enough.polish.ui.ChoiceGroup;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.TextField;
import de.enough.polish.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class HtmlForm {
    public static final String GET = "GET";
    public static final String POST = "POST";
    private final String formName;
    private final String actionUrl;
    private final String method;
    private final ArrayList formItems = new ArrayList();
    private Hashtable hiddenElememts;

    public HtmlForm(String name, String actionUrl, String method) {
        this.formName = name;
        this.actionUrl = actionUrl;
        this.method = method.toUpperCase();
    }

    public String getAction() {
        return this.actionUrl;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isGet() {
        return GET.equals(this.method);
    }

    public boolean isPost() {
        return POST.equals(this.method);
    }

    public String getName() {
        return this.formName;
    }

    public void addItem(Item item) {
        this.formItems.add(item);
    }

    public Item[] getItems() {
        return (Item[])this.formItems.toArray(new Item[this.formItems.size()]);
    }

    public void addHiddenElement(String name, String value) {
        if (this.hiddenElememts == null) {
            this.hiddenElememts = new Hashtable();
        }
        if (value == null) {
            value = "";
        }
        this.hiddenElememts.put(name, value);
    }

    public Hashtable getFormElements() {
        return this.getFormElements(null, null);
    }

    public Hashtable getFormElements(FormListener listener, Item submitItem) {
        Item item;
        int size = this.hiddenElememts != null ? this.hiddenElememts.size() + this.formItems.size() : this.formItems.size();
        Hashtable<String, String> elements = new Hashtable<String, String>(size);
        if (this.hiddenElememts != null) {
            Enumeration enumeration = this.hiddenElememts.keys();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                String value = (String)this.hiddenElememts.get(name);
                if (listener != null) {
                    value = listener.verifySubmitFormValue(this.actionUrl, name, value);
                }
                if (value == null) {
                    value = "";
                }
                elements.put(name, value);
            }
        }
        Object[] items = this.formItems.getInternalArray();
        for (int i = 0; i < items.length && (item = (Item)items[i]) != null; ++i) {
            String name;
            if ("submit".equals(item.getAttribute("type")) && item != submitItem || (name = (String)item.getAttribute("name")) == null) continue;
            String value = (String)item.getAttribute("value");
            if (item instanceof TextField) {
                TextField textField = (TextField)item;
                value = textField.getString();
            } else if (item instanceof ChoiceGroup) {
                ChoiceGroup choiceGroup = (ChoiceGroup)item;
                HtmlSelect htmlSelect = (HtmlSelect)choiceGroup.getAttribute("select");
                value = htmlSelect.getValue(choiceGroup.getSelectedIndex());
            }
            if (listener != null) {
                value = listener.verifySubmitFormValue(this.actionUrl, name, value);
            }
            if (value == null) {
                value = "";
            }
            elements.put(name, value);
        }
        return elements;
    }
}

