/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.io.Externalizable;
import de.enough.polish.ui.StyleSheet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Display;

public class Color
implements Externalizable {
    public static final int TRANSPARENT = -1;
    public static final int COLOR_BACKGROUND = 0;
    public static final int COLOR_FOREGROUND = 1;
    public static final int COLOR_HIGHLIGHTED_BACKGROUND = 2;
    public static final int COLOR_HIGHLIGHTED_FOREGROUND = 3;
    public static final int COLOR_BORDER = 4;
    public static final int COLOR_HIGHLIGHTED_BORDER = 5;
    private int argb;
    private boolean isDynamic;
    private transient Integer integer;

    public Color(int argb) {
        this(argb, false);
    }

    public Color(int argb, boolean isDynamic) {
        this.argb = argb;
        this.isDynamic = isDynamic;
    }

    public Integer getInteger() {
        if (this.integer == null) {
            this.integer = new Integer(this.getColor());
        }
        return this.integer;
    }

    public int getColor() {
        if (!this.isDynamic) {
            return this.argb;
        }
        if (this.argb == -1) {
            return -1;
        }
        Display display = StyleSheet.display;
        if (display == null) {
            throw new IllegalStateException("unable to retrieve dynamic color before the startApp() method has been called.");
        }
        return display.getColor(this.argb);
    }

    public boolean isTransparent() {
        return this.isDynamic && this.argb == -1;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public String toString() {
        try {
            return Integer.toHexString(this.getColor());
        }
        catch (IllegalStateException e) {
            return super.toString();
        }
    }

    public Color() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.argb = dataInputStream.readInt();
        this.isDynamic = dataInputStream.readBoolean();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.argb);
        dataOutputStream.writeBoolean(this.isDynamic);
    }
}

