/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;

public class Container
extends Item {
    public static final int SCROLL_DEFAULT = 0;
    public static final int SCROLL_SMOOTH = 1;
    protected ArrayList itemsList = new ArrayList();
    protected boolean autoFocusEnabled;
    protected int autoFocusIndex;
    protected Style itemStyle;
    protected Item focusedItem;
    public int focusedIndex = -1;
    protected boolean enableScrolling;
    public boolean allowCycling = true;
    protected int yOffset;
    protected int targetYOffset;
    private int focusedTopMargin;
    protected ContainerView containerView;
    private boolean isCallingInitOnContainerView;
    private boolean isPaintingOnContainerView;
    private boolean isScrollRequired;
    protected int availableHeight = -1;
    private Item[] containerItems;
    private boolean showCommandsHasBeenCalled;
    private Item scrollItem;
    protected Style plainStyle;

    public Container(boolean focusFirstElement) {
        this(null, focusFirstElement, null, -1);
    }

    public Container(boolean focusFirstElement, Style style) {
        this(null, focusFirstElement, style, -1);
    }

    public Container(String label, boolean focusFirstElement, Style style, int height) {
        super(label, 0, 3, style);
        Style focStyle;
        this.autoFocusEnabled = focusFirstElement;
        this.focusedStyle = focStyle = StyleSheet.focusedStyle;
        this.focusedTopMargin = focStyle.marginTop + focStyle.paddingTop;
        if (focStyle.border != null) {
            this.focusedTopMargin += focStyle.border.borderWidth;
        }
        if (focStyle.background != null) {
            this.focusedTopMargin += focStyle.background.borderWidth;
        }
        this.layout |= 0x100;
        this.setScrollHeight(height);
    }

    public void setScrollHeight(int height) {
        Item item;
        this.availableHeight = height;
        this.enableScrolling = height != -1;
        Item item2 = item = this.scrollItem != null ? this.scrollItem : this.focusedItem;
        if (this.isInitialized && this.enableScrolling && item != null) {
            this.scroll(0, item);
            this.isScrollRequired = false;
        }
    }

    public int getScrollHeight() {
        if (this.availableHeight == -1 && this.parent instanceof Container) {
            return ((Container)this.parent).getScrollHeight();
        }
        return this.availableHeight;
    }

    public int getRelativeScrollHeight() {
        if (this.availableHeight == -1 && this.parent instanceof Container) {
            return ((Container)this.parent).getScrollHeight() - this.relativeY;
        }
        return this.availableHeight;
    }

    int getContentScrollHeight() {
        return this.getScrollHeight() - (this.contentY + this.borderWidth + this.paddingBottom + this.marginBottom);
    }

    public void add(String text) {
        this.add(new StringItem(null, text));
    }

    public void add(String text, Style textAddStyle) {
        this.add(new StringItem(null, text), textAddStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Item item) {
        ArrayList arrayList = this.itemsList;
        synchronized (arrayList) {
            item.relativeY = 0;
            item.internalX = -9999;
            item.parent = this;
            this.itemsList.add(item);
            this.isInitialized = false;
            if (this.parent != null) {
                this.parent.isInitialized = false;
            }
            if (this.isShown) {
                item.showNotify();
            }
        }
        this.repaint();
    }

    public void add(Item item, Style itemAddStyle) {
        this.add(item);
        if (itemAddStyle != null) {
            item.setStyle(itemAddStyle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, Item item) {
        ArrayList arrayList = this.itemsList;
        synchronized (arrayList) {
            item.relativeY = 0;
            item.internalX = -9999;
            item.parent = this;
            this.itemsList.add(index, item);
            if (index <= this.focusedIndex) {
                ++this.focusedIndex;
                if (this.containerView != null) {
                    this.containerView.focusedIndex = this.focusedIndex;
                }
            }
            this.requestInit();
            for (int i = index + 1; i < this.itemsList.size(); ++i) {
                Item followingItem = (Item)this.itemsList.get(i);
                followingItem.relativeY = 0;
            }
            if (this.isShown) {
                item.showNotify();
            }
        }
        this.repaint();
    }

    public Item set(int index, Item item) {
        return this.set(index, item, null);
    }

    public Item set(int index, Item item, Style itemStyle) {
        if (itemStyle != null) {
            item.setStyle(itemStyle);
        }
        item.parent = this;
        Item last = (Item)this.itemsList.set(index, item);
        if (index == this.focusedIndex) {
            last.defocus(this.itemStyle);
            if (item.appearanceMode != 0) {
                if (this.isFocused) {
                    this.focus(index, item, 0);
                } else {
                    this.focusedItem = item;
                }
            } else {
                this.focus(-1);
            }
        }
        if (this.focusedIndex == -1 || index <= this.focusedIndex) {
            int offset = this.getScrollYOffset() + last.itemHeight;
            if (offset > 0) {
                offset = 0;
            }
            this.setScrollYOffset(offset);
        }
        this.requestInit();
        for (int i = index + 1; i < this.itemsList.size(); ++i) {
            Item followingItem = (Item)this.itemsList.get(i);
            followingItem.relativeY = 0;
        }
        this.requestInit();
        this.repaint();
        return last;
    }

    public Item get(int index) {
        return (Item)this.itemsList.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item remove(int index) {
        Item removedItem = null;
        ArrayList arrayList = this.itemsList;
        synchronized (arrayList) {
            Item item;
            removedItem = (Item)this.itemsList.remove(index);
            if (removedItem == this.scrollItem) {
                this.scrollItem = null;
            }
            Item[] myItems = (Item[])this.itemsList.toArray(new Item[this.itemsList.size()]);
            int removedItemHeight = removedItem.itemHeight + this.paddingVertical;
            if (this.containerView == null) {
                for (int i = index; i < myItems.length; ++i) {
                    item = myItems[i];
                    item.relativeY -= removedItemHeight;
                }
            }
            if (index == this.focusedIndex) {
                Screen scr;
                this.focusedItem = null;
                if (this.containerView != null) {
                    this.containerView.focusedIndex = -1;
                    this.containerView.focusedItem = null;
                }
                if ((scr = this.getScreen()) != null) {
                    scr.removeItemCommands(removedItem);
                }
                if (index >= myItems.length) {
                    index = myItems.length - 1;
                }
                if (index != -1) {
                    item = myItems[index];
                    if (item.appearanceMode != 0) {
                        this.focus(index, item, 6);
                    } else {
                        this.focusClosestItem(index, myItems);
                    }
                } else {
                    this.autoFocusEnabled = true;
                    this.autoFocusIndex = 0;
                }
            } else if (index < this.focusedIndex) {
                if (this.containerView != null) {
                    --this.containerView.focusedIndex;
                } else {
                    int offset = this.getScrollYOffset() + removedItemHeight;
                    this.setScrollYOffset(offset > 0 ? 0 : offset, false);
                }
                --this.focusedIndex;
            }
            this.isInitialized = false;
            if (this.parent != null) {
                this.parent.isInitialized = false;
            }
            if (this.isShown) {
                removedItem.hideNotify();
            }
        }
        this.repaint();
        return removedItem;
    }

    public boolean focusClosestItemAbove(int index) {
        Item item;
        int i;
        Item[] myItems = this.getItems();
        Item newFocusedItem = null;
        int newFocusedIndex = -1;
        for (i = index - 1; i >= 0; --i) {
            item = myItems[i];
            if (item.appearanceMode == 0) continue;
            newFocusedIndex = i;
            newFocusedItem = item;
            break;
        }
        if (newFocusedItem == null) {
            for (i = index + 1; i < myItems.length; ++i) {
                item = myItems[i];
                if (item.appearanceMode == 0) continue;
                newFocusedIndex = i;
                newFocusedItem = item;
                break;
            }
        }
        if (newFocusedItem != null) {
            int direction = 6;
            if (newFocusedIndex < index) {
                direction = 1;
            }
            this.focus(newFocusedIndex, newFocusedItem, direction);
        } else {
            this.autoFocusEnabled = true;
            this.focusedItem = null;
            this.focusedIndex = -1;
            if (this.containerView != null) {
                this.containerView.focusedIndex = -1;
                this.containerView.focusedItem = null;
            }
        }
        return newFocusedItem != null;
    }

    public boolean focusClosestItem(int index) {
        return this.focusClosestItem(index, this.getItems());
    }

    protected boolean focusClosestItem(int index, Item[] myItems) {
        int i = 1;
        Item newFocusedItem = null;
        boolean continueFocus = true;
        while (continueFocus) {
            Item item;
            continueFocus = false;
            int testIndex = index + i;
            if (testIndex < myItems.length) {
                item = myItems[testIndex];
                if (item.appearanceMode != 0) {
                    newFocusedItem = item;
                    i = testIndex;
                    break;
                }
                continueFocus = true;
            }
            if ((testIndex = index - i) >= 0) {
                item = myItems[testIndex];
                if (item.appearanceMode != 0) {
                    i = testIndex;
                    newFocusedItem = item;
                    break;
                }
                continueFocus = true;
            }
            ++i;
        }
        if (newFocusedItem != null) {
            int direction = 6;
            if (i < index) {
                direction = 1;
            }
            this.focus(i, newFocusedItem, direction);
        } else {
            this.autoFocusEnabled = true;
            this.focusedItem = null;
            this.focusedIndex = -1;
            if (this.containerView != null) {
                this.containerView.focusedIndex = -1;
                this.containerView.focusedItem = null;
            }
        }
        return newFocusedItem != null;
    }

    public boolean remove(Item item) {
        int index = this.itemsList.indexOf(item);
        if (index != -1) {
            this.remove(index);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList arrayList = this.itemsList;
        synchronized (arrayList) {
            Container parentContainer;
            int scrollOffset;
            if (this.containerView != null) {
                this.containerView.focusedIndex = -1;
                this.containerView.focusedItem = null;
            }
            this.scrollItem = null;
            if (this.isShown) {
                Item item;
                Object[] myItems = this.itemsList.getInternalArray();
                for (int i = 0; i < myItems.length && (item = (Item)myItems[i]) != null; ++i) {
                    item.hideNotify();
                }
            }
            this.itemsList.clear();
            this.containerItems = new Item[0];
            if (this.focusedIndex != -1) {
                this.autoFocusEnabled = this.isFocused;
                this.autoFocusIndex = 0;
                this.focusedIndex = -1;
                if (this.focusedItem != null) {
                    Screen scr;
                    if (this.itemStyle != null) {
                        this.focusedItem.defocus(this.itemStyle);
                    }
                    if (this.focusedItem.commands != null && (scr = this.getScreen()) != null) {
                        scr.removeItemCommands(this.focusedItem);
                    }
                }
                this.focusedItem = null;
            }
            this.yOffset = 0;
            this.targetYOffset = 0;
            if (this.internalX != -9999) {
                this.internalX = -9999;
                this.internalY = 0;
            }
            if (this.isFocused && this.parent instanceof Container && (scrollOffset = -(parentContainer = (Container)this.parent).getScrollYOffset()) > this.relativeY) {
                int diff = scrollOffset - this.relativeY;
                parentContainer.setScrollYOffset(diff - scrollOffset, false);
            }
            this.contentHeight = 0;
            this.itemHeight = this.marginTop + this.paddingTop + this.paddingBottom + this.marginBottom;
            if (this.isInitialized) {
                this.isInitialized = false;
                this.repaint();
            }
        }
    }

    public int size() {
        return this.itemsList.size();
    }

    public Item[] getItems() {
        if (!this.isInitialized || this.containerItems == null) {
            this.containerItems = (Item[])this.itemsList.toArray(new Item[this.itemsList.size()]);
        }
        return this.containerItems;
    }

    public boolean focus(int index) {
        if (index == -1) {
            this.focusedIndex = -1;
            Item item = this.focusedItem;
            if (item != null && this.itemStyle != null && item.isFocused) {
                item.defocus(this.itemStyle);
            }
            this.focusedItem = null;
            if (this.containerView != null) {
                this.containerView.focusedIndex = -1;
                this.containerView.focusedItem = null;
            }
            return true;
        }
        if (!this.isFocused) {
            this.autoFocusEnabled = true;
        }
        Item item = (Item)this.itemsList.get(index);
        if (item.appearanceMode != 0) {
            int direction = 0;
            if (this.isFocused && this.focusedIndex != -1) {
                if (this.focusedIndex < index) {
                    direction = 6;
                } else if (this.focusedIndex > index) {
                    direction = 1;
                }
            }
            this.focus(index, item, direction);
            return true;
        }
        return false;
    }

    public void focus(int index, Item item, int direction) {
        if (!this.isInitialized && this.autoFocusEnabled) {
            this.autoFocusIndex = index;
        }
        if (index == this.focusedIndex && item.isFocused && item == this.focusedItem) {
            return;
        }
        boolean isReinitializationRequired = false;
        if (this.focusedItem != null) {
            Item fItem = this.focusedItem;
            int wBefore = fItem.itemWidth;
            int hBefore = fItem.itemHeight;
            int layoutBefore = fItem.layout;
            if (this.itemStyle != null) {
                fItem.defocus(this.itemStyle);
            } else {
                Debug.debug("error", "de.enough.polish.ui.Container", 811, "Container: Unable to defocus item - no previous style found.");
                fItem.defocus(StyleSheet.defaultStyle);
            }
            if (this.isInitialized) {
                int wAfter = fItem.getItemWidth(this.contentWidth, this.contentWidth);
                int hAfter = fItem.itemHeight;
                int layoutAfter = fItem.layout;
                if (wAfter != wBefore || hAfter != hBefore || layoutAfter != layoutBefore) {
                    isReinitializationRequired = true;
                    fItem.isInitialized = false;
                }
            }
        }
        int wBefore = item.itemWidth;
        int hBefore = item.itemHeight;
        int layoutBefore = item.layout;
        Style newStyle = this.getFocusedStyle(index, item);
        boolean isDownwards = direction == 6 || direction == 5 || direction == 0 && index > this.focusedIndex;
        int previousIndex = this.focusedIndex;
        this.focusedIndex = index;
        this.focusedItem = item;
        this.itemStyle = this.containerView != null ? this.containerView.focusItem(index, item, direction, newStyle) : item.focus(newStyle, direction);
        if (this.itemStyle == null) {
            Debug.debug("error", "de.enough.polish.ui.Container", 844, (Object)"Container: Unable to retrieve style of item ", item.getClass().getName());
        }
        if (this.isInitialized) {
            int wAfter = item.getItemWidth(this.contentWidth, this.contentWidth);
            int hAfter = item.itemHeight;
            int layoutAfter = item.layout;
            if (wAfter != wBefore || hAfter != hBefore || layoutAfter != layoutBefore) {
                isReinitializationRequired = true;
                item.isInitialized = false;
            }
            this.updateInternalPosition(item);
            if (this.getScrollHeight() != -1) {
                Item nextItem = isDownwards && index < this.itemsList.size() - 1 ? (Item)this.itemsList.get(index + 1) : (!isDownwards && index > 0 ? (Item)this.itemsList.get(index - 1) : item);
                if (this.enableScrolling && (index == 0 || isDownwards && index < previousIndex || previousIndex == -1)) {
                    this.targetYOffset = 0;
                } else {
                    int availHeight;
                    int itemYTop;
                    int itemYBottom = isDownwards ? nextItem.relativeY + nextItem.itemHeight : item.relativeY + item.itemHeight;
                    int height = itemYBottom - (itemYTop = isDownwards ? item.relativeY : nextItem.relativeY);
                    if (height > (availHeight = this.getRelativeScrollHeight())) {
                        height = availHeight - 5;
                        if (!isDownwards) {
                            itemYTop += itemYBottom - itemYTop - height;
                        }
                    }
                    this.scroll(direction, this.relativeX, itemYTop, item.internalWidth, height);
                }
            }
        } else if (this.getScrollHeight() != -1) {
            this.isScrollRequired = true;
        }
        if (this.isInitialized) {
            this.isInitialized = !isReinitializationRequired;
        }
    }

    protected void updateInternalPosition(Item item) {
        if (item == null) {
            return;
        }
        if (item.internalX != -9999) {
            this.internalX = item.relativeX + item.contentX + item.internalX;
            this.internalY = this.enableScrolling ? this.getScrollYOffset() + item.relativeY + item.contentY + item.internalY : item.relativeY + item.contentY + item.internalY;
            this.internalWidth = item.internalWidth;
            this.internalHeight = item.internalHeight;
        } else {
            this.internalX = item.relativeX;
            this.internalY = this.enableScrolling ? this.getScrollYOffset() + item.relativeY : item.relativeY;
            this.internalWidth = item.itemWidth;
            this.internalHeight = item.itemHeight;
        }
    }

    protected Style getFocusedStyle(int index, Item item) {
        Style newStyle;
        if (item.style != null && !item.isStyleInitialised) {
            item.setStyle(item.style);
        }
        if ((newStyle = item.focusedStyle) == null) {
            newStyle = item.getFocusedStyle();
        }
        return newStyle;
    }

    public boolean scroll(int direction, Item item) {
        if (item.internalX != -9999 && (item.itemHeight > this.getScrollHeight() || item.internalY + item.internalHeight > item.contentHeight)) {
            int relativeInternalX = item.relativeX + item.contentX + item.internalX;
            int relativeInternalY = item.relativeY + item.contentY + item.internalY;
            return this.scroll(direction, relativeInternalX, relativeInternalY, item.internalWidth, item.internalHeight);
        }
        if (!this.isInitialized && item.relativeY == 0) {
            this.scrollItem = item;
            return true;
        }
        return this.scroll(direction, item.relativeX, item.relativeY, item.itemWidth, item.itemHeight);
    }

    protected boolean scroll(int direction, int x, int y, int width, int height) {
        if (!this.enableScrolling) {
            if (this.parent instanceof Container) {
                return ((Container)this.parent).scroll(direction, x += this.contentX + this.relativeX, y += this.contentY + this.relativeY, width, height);
            }
            return false;
        }
        if (height == 0) {
            return false;
        }
        boolean isDownwards = direction == 6 || direction == 5 || direction == 0;
        boolean isUpwards = direction == 1;
        int currentYOffset = this.targetYOffset;
        int verticalSpace = this.availableHeight - (this.contentY + this.marginBottom + this.paddingBottom + this.borderWidth);
        int yTopAdjust = 0;
        Screen scr = this.screen;
        if (scr != null && this == scr.container && this.relativeY > scr.contentY) {
            yTopAdjust = this.relativeY - scr.contentY;
        }
        if (y + height + currentYOffset + yTopAdjust > verticalSpace) {
            currentYOffset = verticalSpace - (y + height + yTopAdjust);
            if (isDownwards && y + currentYOffset < 0 && height < verticalSpace) {
                currentYOffset -= y + currentYOffset;
            }
        } else if (y + currentYOffset < 0) {
            currentYOffset -= y + currentYOffset;
            if (isUpwards && y + height + currentYOffset > verticalSpace && height < verticalSpace) {
                currentYOffset += verticalSpace - (y + height + currentYOffset);
            }
        } else {
            return false;
        }
        this.setScrollYOffset(currentYOffset, true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initContent(int firstLineWidth, int lineWidth) {
        ArrayList arrayList = this.itemsList;
        synchronized (arrayList) {
            boolean scrolled;
            int width;
            int myContentWidth = 0;
            int myContentHeight = 0;
            Item[] myItems = (Item[])this.itemsList.toArray(new Item[this.itemsList.size()]);
            this.containerItems = myItems;
            if (this.autoFocusEnabled && this.autoFocusIndex >= myItems.length) {
                this.autoFocusIndex = 0;
            }
            Item ancestor = this.parent;
            while (this.allowCycling && ancestor != null) {
                if (ancestor instanceof Container && ((Container)ancestor).getNumberOfInteractiveItems() > 1) {
                    this.allowCycling = false;
                    break;
                }
                ancestor = ancestor.parent;
            }
            if (this.containerView != null && !this.isCallingInitOnContainerView) {
                boolean scrolled2;
                this.isCallingInitOnContainerView = true;
                boolean requireScrolling = this.isScrollRequired && this.isFocused;
                this.containerView.initContent(this, firstLineWidth, lineWidth);
                this.appearanceMode = this.defaultCommand != null || this.commands != null && this.commands.size() > 0 ? 3 : this.containerView.appearanceMode;
                if (this.isFocused && this.autoFocusEnabled && this.autoFocusIndex >= 0 && this.appearanceMode != 0) {
                    for (int i = this.autoFocusIndex; i < myItems.length; ++i) {
                        Item item = myItems[i];
                        if (item.appearanceMode == 0) continue;
                        this.autoFocusEnabled = false;
                        requireScrolling = this.autoFocusIndex != 0;
                        int heightBeforeFocus = item.itemHeight;
                        this.focus(i, item, 0);
                        int availableWidth = item.itemWidth;
                        if (availableWidth < this.minimumWidth) {
                            availableWidth = this.minimumWidth;
                        }
                        if (item.getItemHeight(availableWidth, availableWidth) > heightBeforeFocus) {
                            this.containerView.initContent(this, firstLineWidth, lineWidth);
                        }
                        this.isScrollRequired = this.isScrollRequired && requireScrolling;
                        break;
                    }
                }
                this.contentWidth = this.containerView.contentWidth;
                this.contentHeight = this.containerView.contentHeight;
                if (requireScrolling && this.focusedItem != null) {
                    Item item = this.focusedItem;
                    this.scroll(0, item.relativeX, item.relativeY, item.itemWidth, item.itemHeight);
                } else if (this.scrollItem != null && (scrolled2 = this.scroll(0, this.scrollItem))) {
                    this.scrollItem = null;
                }
                this.isCallingInitOnContainerView = false;
                return;
            }
            boolean isLayoutShrink = (this.layout & 0x400) == 1024;
            boolean hasFocusableItem = false;
            int myContentStartX = Integer.MAX_VALUE;
            int myContentEndX = Integer.MIN_VALUE;
            for (int i = 0; i < myItems.length; ++i) {
                Item item = myItems[i];
                width = item.getItemWidth(lineWidth, lineWidth);
                int height = item.itemHeight;
                if (item.appearanceMode != 0) {
                    hasFocusableItem = true;
                }
                if (this.isFocused && this.autoFocusEnabled && i >= this.autoFocusIndex && item.appearanceMode != 0) {
                    this.autoFocusEnabled = false;
                    this.focus(i, item, 0);
                    this.isScrollRequired = (this.isScrollRequired || hasFocusableItem) && this.autoFocusIndex != 0;
                    height = item.getItemHeight(lineWidth, lineWidth);
                    width = !isLayoutShrink ? item.itemWidth : 0;
                    if (this.enableScrolling && this.autoFocusIndex != 0) {
                        this.scroll(0, 0, myContentHeight, width, height);
                    }
                } else if (i == this.focusedIndex) {
                    if (isLayoutShrink) {
                        width = 0;
                    }
                    if (this.isScrollRequired) {
                        this.scroll(0, 0, myContentHeight, width, height);
                        this.isScrollRequired = false;
                    }
                }
                if (width > myContentWidth) {
                    myContentWidth = width;
                }
                item.relativeY = myContentHeight;
                item.relativeX = (item.layout & 3) == 3 ? (lineWidth - width) / 2 : ((item.layout & 2) == 2 ? lineWidth - width : 0);
                if (item.relativeX < myContentStartX) {
                    myContentStartX = item.relativeX;
                }
                if (item.relativeX + width > myContentEndX) {
                    myContentEndX = item.relativeX + width;
                }
                myContentHeight += height != 0 ? height + this.paddingVertical : 0;
            }
            if (myContentEndX - myContentStartX > myContentWidth) {
                myContentWidth = myContentEndX - myContentStartX;
            }
            if (this.minimumWidth > myContentWidth) {
                myContentWidth = this.minimumWidth - ((this.borderWidth << 1) + this.marginLeft + this.paddingLeft + this.marginRight + this.paddingRight);
            }
            if (!hasFocusableItem) {
                this.appearanceMode = this.defaultCommand != null || this.commands != null && this.commands.size() > 0 ? 3 : 0;
            } else {
                this.appearanceMode = 3;
                if (this.focusedItem != null) {
                    Item item = this.focusedItem;
                    this.updateInternalPosition(item);
                    if (isLayoutShrink) {
                        item.isInitialized = false;
                        boolean doExpand = item.isLayoutExpand;
                        if (doExpand) {
                            item.isLayoutExpand = false;
                            width = item.getItemWidth(lineWidth, lineWidth);
                            item.isInitialized = false;
                            item.isLayoutExpand = true;
                        } else {
                            width = item.itemWidth;
                        }
                        if (width > myContentWidth) {
                            myContentWidth = width;
                        }
                        if (this.minimumWidth != 0 && myContentWidth < this.minimumWidth) {
                            myContentWidth = this.minimumWidth;
                        }
                    }
                }
            }
            if (this.scrollItem != null && (scrolled = this.scroll(0, this.scrollItem))) {
                this.scrollItem = null;
            }
            this.contentHeight = myContentHeight;
            this.contentWidth = myContentWidth;
        }
    }

    protected void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        boolean setClipping = this.enableScrolling && (this.yOffset != 0 || this.itemHeight > this.availableHeight);
        int clipX = 0;
        int clipY = 0;
        int clipWidth = 0;
        int clipHeight = 0;
        if (setClipping) {
            clipX = g.getClipX();
            clipY = g.getClipY();
            clipWidth = g.getClipWidth();
            clipHeight = g.getClipHeight();
            g.clipRect(clipX, y, clipWidth, this.availableHeight);
        }
        y += this.yOffset;
        if (this.containerView != null && !this.isPaintingOnContainerView) {
            this.isPaintingOnContainerView = true;
            this.containerView.paintContent(this, x, y, leftBorder, rightBorder, g);
            if (setClipping) {
                g.setClip(clipX, clipY, clipWidth, clipHeight);
            }
            this.isPaintingOnContainerView = false;
        } else {
            Item[] myItems = this.containerItems;
            int focusedX = x;
            int focusedY = 0;
            int focusedRightBorder = rightBorder;
            int startY = g.getClipY();
            int endY = startY + g.getClipHeight();
            Item focItem = this.focusedItem;
            int focIndex = this.focusedIndex;
            for (int i = 0; i < myItems.length; ++i) {
                Item item = myItems[i];
                if (i == focIndex) {
                    focusedY = y;
                    item.getItemHeight(rightBorder - x, rightBorder - leftBorder);
                } else if (y + item.itemHeight >= startY && y < endY) {
                    item.paint(x, y, leftBorder, rightBorder, g);
                }
                if (item.itemHeight == 0) continue;
                y += item.itemHeight + this.paddingVertical;
            }
            boolean paintFocusedItemOutside = false;
            if (focItem != null) {
                boolean bl = paintFocusedItemOutside = focItem.internalX != -9999;
                if (!paintFocusedItemOutside) {
                    focItem.paint(focusedX, focusedY, focusedX, focusedRightBorder, g);
                }
            }
            if (setClipping) {
                g.setClip(clipX, clipY, clipWidth, clipHeight);
            }
            if (paintFocusedItemOutside) {
                focItem.paint(focusedX, focusedY, focusedX, focusedRightBorder, g);
            }
        }
    }

    protected void paintBackgroundAndBorder(int x, int y, int width, int height, Graphics g) {
        if (this.containerView == null) {
            super.paintBackgroundAndBorder(x, y, width, height, g);
        } else {
            if (this.background != null) {
                int bWidth = this.borderWidth;
                if (this.border != null) {
                    x += bWidth;
                    y += bWidth;
                    width -= bWidth << 1;
                    height -= bWidth << 1;
                }
                this.containerView.paintBackground(this.background, x, y, width, height, g);
                if (this.border != null) {
                    x -= bWidth;
                    y -= bWidth;
                    width += bWidth << 1;
                    height += bWidth << 1;
                }
            }
            if (this.border != null) {
                this.containerView.paintBorder(this.border, x, y, width, height, g);
            }
        }
    }

    protected String createCssSelector() {
        return "container";
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        if (this.itemsList.size() == 0) {
            return super.handleKeyPressed(keyCode, gameAction);
        }
        Item item = this.focusedItem;
        if (item != null) {
            int startY;
            if (!item.isInitialized) {
                item.init(this.contentWidth, this.contentWidth);
            } else if (this.enableScrolling && item.internalX != -9999 && ((startY = this.getScrollYOffset() + item.relativeY + item.contentY + item.internalY) < 0 && gameAction == 1 && keyCode != 50 || startY + item.internalHeight > this.availableHeight && gameAction == 6 && keyCode != 56) && this.scroll(gameAction, item)) {
                return true;
            }
            int scrollOffset = this.getScrollYOffset();
            if (item.handleKeyPressed(keyCode, gameAction)) {
                if (this.enableScrolling) {
                    if (this.getScrollYOffset() == scrollOffset) {
                        this.scroll(gameAction, item);
                    }
                } else {
                    this.updateInternalPosition(item);
                }
                return true;
            }
        }
        return this.handleNavigate(keyCode, gameAction) || super.handleKeyPressed(keyCode, gameAction);
    }

    protected boolean handleNavigate(int keyCode, int gameAction) {
        boolean processed = false;
        int offset = this.getRelativeScrollYOffset();
        int availableScrollHeight = this.getScrollHeight();
        Item focItem = this.focusedItem;
        int y = 0;
        int h = 0;
        if (focItem != null && availableScrollHeight != -1) {
            if (focItem.internalX == -9999 || focItem.relativeY + focItem.contentY + focItem.internalY + focItem.internalHeight < availableScrollHeight) {
                y = focItem.relativeY;
                h = focItem.itemHeight;
            } else {
                y = focItem.relativeY + focItem.contentY + focItem.internalY;
                h = focItem.internalHeight;
            }
        }
        if (gameAction == 6 && keyCode != 56) {
            if (focItem == null || availableScrollHeight == -1 || offset + y + h <= availableScrollHeight) {
                processed = this.containerView != null ? this.containerView.handleKeyPressed(keyCode, gameAction) : this.shiftFocus(true, 0);
            }
            if (!processed && (availableScrollHeight != -1 && offset + y + h > availableScrollHeight || this.enableScrolling && offset + this.itemHeight > availableScrollHeight)) {
                int containerHeight = this.contentHeight;
                int scrollHeight = this.getContentScrollHeight();
                int scrollOffset = this.getScrollYOffset();
                int difference = containerHeight + scrollOffset - scrollHeight;
                if (difference > scrollHeight / 2) {
                    difference = scrollHeight / 2;
                }
                offset = this.getScrollYOffset() - difference;
                this.setScrollYOffset(offset, true);
                processed = true;
            }
        } else if (gameAction == 1 && keyCode != 50) {
            if (focItem == null || availableScrollHeight == -1 || offset + focItem.relativeY >= 0) {
                processed = this.containerView != null ? this.containerView.handleKeyPressed(keyCode, gameAction) : this.shiftFocus(false, 0);
            }
            if (!processed && (this.enableScrolling && offset < 0 || availableScrollHeight != -1 && focItem != null && offset + focItem.relativeY < 0)) {
                int difference = this.getScreen() != null ? this.getScreen().contentHeight / 2 : 30;
                offset = this.getScrollYOffset() + difference;
                if (offset > 0) {
                    offset = 0;
                }
                this.setScrollYOffset(offset, true);
                processed = true;
            }
        } else if (this.containerView != null) {
            processed = this.containerView.handleKeyPressed(keyCode, gameAction);
        }
        return processed;
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        Item item;
        if (this.itemsList.size() == 0) {
            return super.handleKeyPressed(keyCode, gameAction);
        }
        if (this.focusedItem != null && (item = this.focusedItem).handleKeyReleased(keyCode, gameAction)) {
            if (this.enableScrolling && item.internalX != -9999) {
                this.scroll(gameAction, item);
            }
            return true;
        }
        return super.handleKeyReleased(keyCode, gameAction);
    }

    protected boolean handleKeyRepeated(int keyCode, int gameAction) {
        Item item;
        if (this.itemsList.size() == 0) {
            return false;
        }
        if (this.focusedItem != null && (item = this.focusedItem).handleKeyRepeated(keyCode, gameAction)) {
            if (this.enableScrolling && item.internalX != -9999) {
                this.scroll(gameAction, item);
            }
            return true;
        }
        return this.handleNavigate(keyCode, gameAction);
    }

    private boolean shiftFocus(boolean forwardFocus, int steps) {
        Item[] items = this.getItems();
        if (items == null || items.length == 0) {
            return false;
        }
        Item focItem = this.focusedItem;
        int i = this.focusedIndex + steps;
        if (i > items.length) {
            i = items.length - 2;
        }
        if (i < 0) {
            i = 1;
        }
        Item item = null;
        boolean allowCycle = this.allowCycling;
        if (allowCycle) {
            if (forwardFocus) {
                allowCycle = this.getScrollYOffset() + this.itemHeight <= this.getScrollHeight() + 1;
            } else {
                boolean bl = allowCycle = this.getScrollYOffset() == 0;
            }
        }
        do {
            if (forwardFocus) {
                if (++i >= items.length) {
                    if (!allowCycle) break;
                    allowCycle = false;
                    i = 0;
                }
            } else if (--i < 0) {
                if (!allowCycle) break;
                allowCycle = false;
                i = items.length - 1;
            }
            item = items[i];
        } while (item.appearanceMode == 0);
        if (item == null || item.appearanceMode == 0 || item == focItem) {
            return false;
        }
        int direction = 1;
        if (forwardFocus) {
            direction = 6;
        }
        this.focus(i, item, direction);
        return true;
    }

    public int getFocusedIndex() {
        return this.focusedIndex;
    }

    public Item getFocusedItem() {
        return this.focusedItem;
    }

    public void setStyle(Style style) {
        this.setStyle(style, false);
    }

    public void setStyle(Style style, boolean ignoreBackground) {
        Integer columns;
        super.setStyle(style);
        if (ignoreBackground) {
            this.background = null;
            this.border = null;
            this.borderWidth = 0;
            this.marginTop = 0;
            this.marginBottom = 0;
            this.marginLeft = 0;
            this.marginRight = 0;
        }
        if (this.focusedStyle != null) {
            this.focusedTopMargin = this.focusedStyle.marginTop + this.focusedStyle.paddingTop;
            if (this.focusedStyle.border != null) {
                this.focusedTopMargin += this.focusedStyle.border.borderWidth;
            }
            if (this.focusedStyle.background != null) {
                this.focusedTopMargin += this.focusedStyle.background.borderWidth;
            }
        }
        if (this.view != null && this.view instanceof ContainerView) {
            ContainerView viewType;
            this.containerView = viewType = (ContainerView)this.view;
            this.view = null;
            viewType.parentContainer = this;
            viewType.focusFirstElement = this.autoFocusEnabled;
            viewType.allowCycling = this.allowCycling;
        } else if (!this.preserveViewType) {
            this.containerView = null;
        }
        if (this.containerView == null && (columns = style.getIntProperty(4)) != null && columns > 1) {
            this.containerView = new ContainerView();
            this.containerView.parentContainer = this;
            this.containerView.focusFirstElement = this.autoFocusEnabled;
            this.containerView.allowCycling = this.allowCycling;
        }
        if (this.containerView != null) {
            this.containerView.setStyle(style);
        }
    }

    public void changeChildStyles(String oldChildStyleName, String newChildStyleName) {
        Style newChildStyle = StyleSheet.getStyle(newChildStyleName);
        if (newChildStyle == null) {
            throw new IllegalArgumentException("for " + newChildStyleName);
        }
        Style oldChildStyle = StyleSheet.getStyle(oldChildStyleName);
        this.changeChildStyles(oldChildStyle, newChildStyle);
    }

    public void changeChildStyles(Style oldChildStyle, Style newChildStyle) {
        Item child;
        if (newChildStyle == null) {
            throw new IllegalArgumentException();
        }
        Object[] children = this.itemsList.getInternalArray();
        for (int i = 0; i < children.length && (child = (Item)children[i]) != null; ++i) {
            if (child.style != oldChildStyle) continue;
            child.setStyle(newChildStyle);
        }
    }

    public String parseIndexUrl(String url, Item item) {
        int pos = url.indexOf("%INDEX%");
        if (pos != -1) {
            int index = this.itemsList.indexOf(item);
            url = url.substring(0, pos) + index + url.substring(pos + 7);
        }
        return url;
    }

    public int getPosition(Item item) {
        return this.itemsList.indexOf(item);
    }

    protected Style focus(Style focusStyle, int direction) {
        Style labStyle;
        int i;
        Item[] myItems;
        this.plainStyle = null;
        if (this.itemsList.size() == 0) {
            return super.focus(focusStyle, direction);
        }
        focusStyle = this.getFocusedStyle();
        Style result = this.style;
        if (focusStyle != StyleSheet.focusedStyle && focusStyle != null && (this.parent == null || this.parent.getFocusedStyle() != focusStyle) || this.includeLabel && focusStyle != null) {
            this.plainStyle = result = super.focus(focusStyle, direction);
        }
        if (this.containerView != null) {
            this.containerView.focus(focusStyle, direction);
        }
        this.isFocused = true;
        int newFocusIndex = this.focusedIndex;
        if (this.containerView == null || this.containerView.allowsAutoTraversal) {
            myItems = this.getItems();
            if (this.autoFocusEnabled && this.autoFocusIndex < myItems.length && myItems[this.autoFocusIndex].appearanceMode != 0) {
                newFocusIndex = this.autoFocusIndex;
                this.autoFocusEnabled = false;
            } else if (direction == 1 || direction == 2) {
                i = myItems.length;
                while (--i >= 0) {
                    Item item = myItems[i];
                    if (item.appearanceMode == 0) continue;
                    newFocusIndex = i;
                    break;
                }
            } else {
                for (i = 0; i < myItems.length; ++i) {
                    Item item = myItems[i];
                    if (item.appearanceMode == 0) continue;
                    newFocusIndex = i;
                    break;
                }
            }
            this.focusedIndex = newFocusIndex;
            if (newFocusIndex == -1) {
                return super.focus(focusStyle, direction);
            }
        } else if (this.focusedIndex == -1) {
            myItems = this.getItems();
            for (i = 0; i < myItems.length; ++i) {
                Item item = myItems[i];
                if (item.appearanceMode == 0) continue;
                newFocusIndex = i;
                break;
            }
            this.focusedIndex = newFocusIndex;
            if (newFocusIndex == -1) {
                return super.focus(focusStyle, direction);
            }
        }
        Item item = (Item)this.itemsList.get(this.focusedIndex);
        this.showCommandsHasBeenCalled = false;
        this.focus(this.focusedIndex, item, direction);
        if (!this.showCommandsHasBeenCalled && this.commands != null) {
            this.showCommands();
        }
        if (this.label != null && (labStyle = (Style)focusStyle.getObjectProperty(3)) != null) {
            this.labelStyle = this.label.style;
            this.label.setStyle(labStyle);
        }
        return result;
    }

    public void defocus(Style originalStyle) {
        if (this.itemsList.size() == 0 || this.focusedIndex == -1) {
            super.defocus(originalStyle);
        } else {
            Screen scr;
            if (this.plainStyle != null) {
                super.defocus(this.plainStyle);
                if (originalStyle == null) {
                    originalStyle = this.plainStyle;
                }
                this.plainStyle = null;
            }
            this.isFocused = false;
            Item item = this.focusedItem;
            item.defocus(this.itemStyle);
            if (this.containerView != null) {
                this.containerView.defocus(originalStyle);
                this.isInitialized = false;
            }
            this.isFocused = false;
            if (item.commands == null && this.commands != null && (scr = this.getScreen()) != null) {
                scr.removeItemCommands(this);
            }
            Style tmpLabelStyle = null;
            if (originalStyle != null) {
                tmpLabelStyle = (Style)originalStyle.getObjectProperty(3);
            }
            if (tmpLabelStyle == null) {
                tmpLabelStyle = StyleSheet.labelStyle;
            }
            if (this.label != null && tmpLabelStyle != null && this.label.style != tmpLabelStyle) {
                this.label.setStyle(tmpLabelStyle);
            }
        }
    }

    public void showCommands() {
        this.showCommandsHasBeenCalled = true;
        super.showCommands();
    }

    protected boolean handleCommand(Command cmd) {
        boolean handled = super.handleCommand(cmd);
        if (!handled && this.focusedItem != null) {
            return this.focusedItem.handleCommand(cmd);
        }
        return handled;
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
        int target = this.targetYOffset;
        int current = this.yOffset;
        if (target != current) {
            if (this.availableHeight != -1 && Math.abs(target - current) > this.availableHeight) {
                current = current < target ? target - this.availableHeight : target + this.availableHeight;
            }
            int speed = (target - current) / 3;
            if (speed > 0 && (current += (speed += target > current ? 1 : -1)) > target || speed < 0 && current < target) {
                current = target;
            }
            this.yOffset = current;
            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            int height = this.itemHeight;
            int width = this.itemWidth;
            Screen scr = this.getScreen();
            width += scr.getScrollBarWidth();
            if (this.availableHeight > height) {
                x = scr.contentX;
                y = scr.contentY;
                height = scr.contentHeight;
                width = scr.contentWidth + scr.getScrollBarWidth();
            }
            repaintRegion.addRegion(x, y, width, height);
        }
        if (this.focusedItem != null) {
            this.focusedItem.animate(currentTime, repaintRegion);
        }
        if (this.containerView != null) {
            this.containerView.animate(currentTime, repaintRegion);
        }
    }

    protected void showNotify() {
        super.showNotify();
        if (this.style != null && !this.isStyleInitialised) {
            this.setStyle(this.style);
        } else if (this.style == null) {
            this.initStyle();
        }
        if (this.containerView != null) {
            this.containerView.showNotify();
        }
        Item[] myItems = this.getItems();
        for (int i = 0; i < myItems.length; ++i) {
            Item item = myItems[i];
            if (item.style != null && !item.isStyleInitialised) {
                item.setStyle(item.style);
            } else if (item.style == null) {
                this.initStyle();
            }
            item.showNotify();
        }
    }

    protected void hideNotify() {
        if (this.containerView != null) {
            this.containerView.hideNotify();
        }
        Item[] myItems = this.getItems();
        for (int i = 0; i < myItems.length; ++i) {
            Item item = myItems[i];
            item.hideNotify();
        }
    }

    public Item getItemAt(int relX, int relY) {
        int itemRelY;
        int itemRelX;
        relY -= this.yOffset;
        Item item = this.focusedItem;
        if (item != null && item.isInItemArea(itemRelX = (relX -= this.contentX) - item.relativeX, itemRelY = (relY -= this.contentY) - item.relativeY)) {
            return item.getItemAt(itemRelX, itemRelY);
        }
        Item[] myItems = this.getItems();
        for (int i = 0; i < myItems.length; ++i) {
            item = myItems[i];
            int itemRelX2 = relX - item.relativeX;
            int itemRelY2 = relY - item.relativeY;
            if (i == this.focusedIndex || !item.isInItemArea(itemRelX2, itemRelY2)) continue;
            return item.getItemAt(itemRelX2, itemRelY2);
        }
        relY += this.yOffset;
        return super.getItemAt(relX += this.contentX, relY += this.contentY);
    }

    public void requestDefocus(Item item) {
        boolean success;
        if (item == this.focusedItem && !(success = this.shiftFocus(true, 1))) {
            this.defocus(this.itemStyle);
        }
    }

    public void requestFullInit() {
        for (int i = 0; i < this.itemsList.size(); ++i) {
            Item item = (Item)this.itemsList.get(i);
            item.isInitialized = false;
            if (!(item instanceof Container)) continue;
            ((Container)item).requestFullInit();
        }
        this.requestInit();
    }

    public int getScrollYOffset() {
        if (!this.enableScrolling && this.parent instanceof Container) {
            return ((Container)this.parent).getScrollYOffset();
        }
        int offset = this.targetYOffset;
        return offset;
    }

    public int getCurrentScrollYOffset() {
        if (!this.enableScrolling && this.parent instanceof Container) {
            return ((Container)this.parent).getCurrentScrollYOffset();
        }
        return this.yOffset;
    }

    public int getRelativeScrollYOffset() {
        if (!this.enableScrolling && this.parent instanceof Container) {
            return ((Container)this.parent).getRelativeScrollYOffset() + this.relativeY;
        }
        int offset = this.targetYOffset;
        return offset;
    }

    public void setScrollYOffset(int offset) {
        this.setScrollYOffset(offset, false);
    }

    public void setScrollYOffset(int offset, boolean smooth) {
        if (!this.enableScrolling && this.parent instanceof Container) {
            ((Container)this.parent).setScrollYOffset(offset, smooth);
            return;
        }
        if (!smooth) {
            this.yOffset = offset;
        }
        this.targetYOffset = offset;
    }

    public int indexOf(Item item) {
        Object object;
        Object[] myItems = this.itemsList.getInternalArray();
        for (int i = 0; i < myItems.length && (object = myItems[i]) != null; ++i) {
            if (object != item) continue;
            return i;
        }
        return -1;
    }

    public void setItemsList(ArrayList itemsList) {
        Item item;
        this.clear();
        if (this.isFocused) {
            this.autoFocusEnabled = true;
            this.autoFocusIndex = this.focusedIndex;
        }
        this.focusedIndex = -1;
        this.focusedItem = null;
        if (this.enableScrolling) {
            this.setScrollYOffset(0, false);
        }
        this.itemsList = itemsList;
        this.containerItems = null;
        Object[] myItems = this.itemsList.getInternalArray();
        for (int i = 0; i < myItems.length && (item = (Item)myItems[i]) != null; ++i) {
            item.parent = this;
            if (!this.isShown) continue;
            item.showNotify();
        }
        this.requestInit();
    }

    public int getNumberOfInteractiveItems() {
        Item item;
        int number = 0;
        Object[] items = this.itemsList.getInternalArray();
        for (int i = 0; i < items.length && (item = (Item)items[i]) != null; ++i) {
            if (item.appearanceMode == 0) continue;
            ++number;
        }
        return number;
    }

    public void releaseResources() {
        super.releaseResources();
        Item[] items = this.getItems();
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            item.releaseResources();
        }
        if (this.containerView != null) {
            this.containerView.releaseResources();
        }
    }
}

