/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Container;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemView;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.util.Debug;
import de.enough.polish.util.TextUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class ContainerView
extends ItemView {
    protected static final int NO_COLUMNS = 0;
    protected static final int EQUAL_WIDTH_COLUMNS = 1;
    protected static final int NORMAL_WIDTH_COLUMNS = 2;
    protected static final int STATIC_WIDTH_COLUMNS = 3;
    protected int yOffset;
    protected int focusedIndex = -1;
    protected transient Container parentContainer;
    protected boolean restartAnimation;
    protected boolean focusFirstElement;
    protected int appearanceMode;
    protected transient Item focusedItem;
    protected int columnsSetting = 0;
    protected int numberOfColumns;
    protected int[] columnsWidths;
    protected int[] rowsHeights;
    protected int numberOfRows;
    protected boolean allowCycling = true;
    protected boolean allowsAutoTraversal = true;
    protected boolean isHorizontal = true;
    protected boolean isVertical = true;
    protected boolean allowsDirectSelectionByPointerEvent = true;

    protected ContainerView() {
    }

    protected void initContent(Item parentContainerItem, int firstLineWidth, int lineWidth) {
        int i;
        int i2;
        boolean isNormalWidthColumns;
        Container parent = (Container)parentContainerItem;
        this.focusedIndex = parent.getFocusedIndex();
        this.focusedItem = parent.getFocusedItem();
        this.allowCycling = parent.allowCycling;
        Item ancestor = parent.parent;
        while (this.allowCycling && ancestor != null) {
            if (ancestor instanceof Container && ((Container)ancestor).getNumberOfInteractiveItems() > 1) {
                this.allowCycling = false;
                break;
            }
            ancestor = ancestor.parent;
        }
        this.parentContainer = parent;
        Item[] myItems = parent.getItems();
        if (this.columnsSetting == 0 || myItems.length <= 1 || this.numberOfColumns <= 1) {
            int width;
            this.isHorizontal = false;
            this.isVertical = true;
            boolean isLayoutShrink = (this.parentContainer.layout & 0x400) == 1024;
            int myContentWidth = 0;
            int myContentHeight = 0;
            boolean hasFocusableItem = false;
            for (int i3 = 0; i3 < myItems.length; ++i3) {
                Item item = myItems[i3];
                width = item.getItemWidth(firstLineWidth, lineWidth);
                int height = item.getItemHeight(firstLineWidth, lineWidth);
                if (item.appearanceMode != 0) {
                    hasFocusableItem = true;
                }
                if (isLayoutShrink && i3 == this.focusedIndex) {
                    width = 0;
                }
                if (width > myContentWidth) {
                    myContentWidth = width;
                }
                item.relativeY = myContentHeight;
                item.relativeX = 0;
                myContentHeight += height + (height != 0 ? this.paddingVertical : 0);
            }
            if (hasFocusableItem) {
                this.appearanceMode = 3;
                if (isLayoutShrink && this.focusedItem != null) {
                    Item item = this.focusedItem;
                    item.isInitialized = false;
                    boolean doExpand = item.isLayoutExpand;
                    if (doExpand) {
                        item.isLayoutExpand = false;
                        width = item.getItemWidth(lineWidth, lineWidth);
                        item.isInitialized = false;
                        item.isLayoutExpand = true;
                    } else {
                        width = item.itemWidth;
                    }
                    if (width > myContentWidth) {
                        myContentWidth = width;
                    }
                    if (parent.minimumWidth != 0 && myContentWidth < parent.minimumWidth) {
                        myContentWidth = parent.minimumWidth;
                    }
                }
            } else {
                this.appearanceMode = 0;
            }
            this.contentHeight = myContentHeight;
            this.contentWidth = myContentWidth;
            return;
        }
        this.isHorizontal = true;
        boolean bl = isNormalWidthColumns = this.columnsSetting == 2;
        if (this.columnsSetting != 3) {
            int availableColumnWidth = isNormalWidthColumns ? lineWidth - (this.numberOfColumns - 1) * this.paddingHorizontal : (lineWidth - (this.numberOfColumns - 1) * this.paddingHorizontal) / this.numberOfColumns;
            this.columnsWidths = new int[this.numberOfColumns];
            for (int i4 = 0; i4 < this.numberOfColumns; ++i4) {
                this.columnsWidths[i4] = availableColumnWidth;
            }
        }
        this.numberOfRows = myItems.length / this.numberOfColumns;
        if (myItems.length % this.numberOfColumns != 0) {
            ++this.numberOfRows;
        }
        this.rowsHeights = new int[this.numberOfRows];
        int maxRowHeight = 0;
        int columnIndex = 0;
        int rowIndex = 0;
        int[] maxColumnWidths = null;
        if (isNormalWidthColumns) {
            maxColumnWidths = new int[this.numberOfColumns];
        }
        int maxWidth = 0;
        int myContentHeight = 0;
        boolean hasFocusableItem = false;
        int columnX = 0;
        for (i2 = 0; i2 < myItems.length; ++i2) {
            Item item = myItems[i2];
            int availableWidth = this.columnsWidths[columnIndex];
            int width = item.getItemWidth(availableWidth, availableWidth);
            int height = item.getItemHeight(availableWidth, availableWidth);
            if (item.appearanceMode != 0) {
                hasFocusableItem = true;
            }
            if (height > maxRowHeight) {
                maxRowHeight = height;
            }
            if (isNormalWidthColumns && width > maxColumnWidths[columnIndex]) {
                maxColumnWidths[columnIndex] = width;
            }
            if (width > maxWidth) {
                maxWidth = width;
            }
            item.relativeX = columnX;
            item.relativeY = myContentHeight;
            columnX += availableWidth;
            if (++columnIndex != this.numberOfColumns) continue;
            columnIndex = 0;
            columnX = 0;
            this.rowsHeights[rowIndex] = maxRowHeight;
            myContentHeight += maxRowHeight + (maxRowHeight != 0 ? this.paddingVertical : 0);
            maxRowHeight = 0;
            ++rowIndex;
        }
        this.appearanceMode = hasFocusableItem ? 3 : 0;
        if (columnIndex != 0) {
            myContentHeight += maxRowHeight;
        }
        columnX = 0;
        if (isNormalWidthColumns) {
            int availableRowWidth = lineWidth - (this.numberOfColumns - 1) * this.paddingHorizontal;
            int availableColumnWidth = availableRowWidth / this.numberOfColumns;
            int usedUpWidth = 0;
            int leftColumns = this.numberOfColumns;
            int completeWidth = 0;
            for (int i5 = 0; i5 < maxColumnWidths.length; ++i5) {
                int maxColumnWidth = maxColumnWidths[i5];
                if (maxColumnWidth <= availableColumnWidth) {
                    usedUpWidth += maxColumnWidth;
                    --leftColumns;
                }
                completeWidth += maxColumnWidth;
            }
            if (completeWidth <= availableRowWidth) {
                this.columnsWidths = maxColumnWidths;
            } else {
                int leftAvailableColumnWidth = (availableRowWidth - usedUpWidth) / leftColumns;
                int[] newMaxColumnWidths = new int[this.numberOfColumns];
                myContentHeight = 0;
                columnIndex = 0;
                rowIndex = 0;
                maxRowHeight = 0;
                maxWidth = 0;
                for (int i6 = 0; i6 < myItems.length; ++i6) {
                    Item item = myItems[i6];
                    int width = item.itemWidth;
                    int height = item.itemHeight;
                    int maxColumnWidth = maxColumnWidths[columnIndex];
                    if (maxColumnWidth <= availableColumnWidth) {
                        newMaxColumnWidths[columnIndex] = maxColumnWidths[columnIndex];
                    } else {
                        if (width > leftAvailableColumnWidth) {
                            width = item.getItemWidth(leftAvailableColumnWidth, leftAvailableColumnWidth);
                            height = item.getItemHeight(leftAvailableColumnWidth, leftAvailableColumnWidth);
                        }
                        if (width > newMaxColumnWidths[columnIndex]) {
                            newMaxColumnWidths[columnIndex] = width;
                        }
                    }
                    ++columnIndex;
                    if (height > maxRowHeight) {
                        maxRowHeight = height;
                    }
                    item.relativeY = myContentHeight;
                    if (columnIndex != this.numberOfColumns) continue;
                    columnIndex = 0;
                    this.rowsHeights[rowIndex] = maxRowHeight;
                    myContentHeight += maxRowHeight + (maxRowHeight != 0 ? this.paddingVertical : 0);
                    maxRowHeight = 0;
                    ++rowIndex;
                }
                this.columnsWidths = newMaxColumnWidths;
            }
        } else if (this.columnsSetting == 1 && !this.isLayoutExpand()) {
            for (i2 = 0; i2 < this.columnsWidths.length; ++i2) {
                this.columnsWidths[i2] = maxWidth;
            }
        }
        int myContentWidth = 0;
        columnIndex = 0;
        for (i = 0; i < myItems.length; ++i) {
            Item item = myItems[i];
            item.relativeX = myContentWidth;
            myContentWidth += this.columnsWidths[columnIndex] + this.paddingHorizontal;
            if (++columnIndex != this.numberOfColumns) continue;
            columnIndex = 0;
            myContentWidth = 0;
        }
        myContentWidth = 0;
        for (i = 0; i < this.columnsWidths.length; ++i) {
            myContentWidth += this.columnsWidths[i] + this.paddingHorizontal;
        }
        this.isVertical = this.numberOfRows > 1;
        this.contentWidth = myContentWidth;
        this.contentHeight = myContentHeight;
    }

    protected boolean isLayoutExpand() {
        return (this.layout & 0x800) == 2048;
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        Item[] myItems = this.parentContainer.getItems();
        this.paintContent(this.parentContainer, myItems, x, y, leftBorder, rightBorder, g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight(), g);
    }

    protected void paintContent(Container container, Item[] myItems, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        int focusedLeftBorder = leftBorder;
        int focusedRightBorder = rightBorder;
        if (this.columnsSetting == 0 || myItems.length == 1 || this.numberOfColumns <= 1) {
            for (int i = 0; i < myItems.length; ++i) {
                if (i == this.focusedIndex) continue;
                Item item = myItems[i];
                int itemX = x + item.relativeX;
                int itemY = y + item.relativeY;
                this.paintItem(item, i, itemX, itemY, leftBorder, rightBorder, clipX, clipY, clipWidth, clipHeight, g);
            }
        } else {
            int columnIndex = 0;
            for (int i = 0; i < myItems.length; ++i) {
                Item item = myItems[i];
                int itemX = x + item.relativeX;
                int itemY = y + item.relativeY;
                int columnWidth = this.columnsWidths[columnIndex];
                leftBorder = itemX;
                rightBorder = leftBorder + columnWidth;
                if (i == this.focusedIndex) {
                    focusedLeftBorder = leftBorder;
                    focusedRightBorder = rightBorder;
                } else {
                    this.paintItem(item, i, itemX, itemY, leftBorder, rightBorder, clipX, clipY, clipWidth, clipHeight, g);
                }
                if (++columnIndex != this.numberOfColumns) continue;
                columnIndex = 0;
            }
        }
        if (this.focusedItem != null) {
            this.paintItem(this.focusedItem, this.focusedIndex, x + this.focusedItem.relativeX, y + this.focusedItem.relativeY, focusedLeftBorder, focusedRightBorder, clipX, clipY, clipWidth, clipHeight, g);
        }
    }

    protected void paintItem(Item item, int index, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        if ((y < clipY + clipHeight && y + item.itemHeight > clipY || item.internalX != -9999 && y + item.internalY < clipY + clipHeight && y + item.internalY + item.internalHeight > clipY) && x < clipX + clipWidth && x + item.itemWidth > clipX) {
            item.paint(x, y, leftBorder, rightBorder, g);
        }
    }

    protected Item getNextItem(int keyCode, int gameAction) {
        Item[] myItems = this.parentContainer.getItems();
        if (this.isHorizontal && gameAction == 5 && keyCode != 54 || this.isVertical && gameAction == 6 && keyCode != 56) {
            if (gameAction == 6 && this.columnsSetting != 0) {
                return this.shiftFocus(true, this.numberOfColumns - 1, myItems);
            }
            return this.shiftFocus(true, 0, myItems);
        }
        if (this.isHorizontal && gameAction == 2 && keyCode != 52 || this.isVertical && gameAction == 1 && keyCode != 50) {
            if (gameAction == 1 && this.columnsSetting != 0) {
                return this.shiftFocus(false, -(this.numberOfColumns - 1), myItems);
            }
            return this.shiftFocus(false, 0, myItems);
        }
        return null;
    }

    protected Item shiftFocus(boolean forwardFocus, int steps, Item[] items) {
        boolean allowCycle = this.allowCycling;
        if (!allowCycle && forwardFocus && steps != 0 && this.isInBottomRow(this.focusedIndex)) {
            return null;
        }
        int i = this.focusedIndex + steps;
        if (steps != 0) {
            if (!forwardFocus) {
                if (i < 0) {
                    if (!allowCycle) {
                        return null;
                    }
                    i = items.length + i;
                }
            } else if ((i %= items.length) >= items.length) {
                if (!allowCycle) {
                    return null;
                }
                i -= items.length;
            }
        }
        Item nextItem = null;
        do {
            if (forwardFocus) {
                if (++i >= items.length) {
                    if (!allowCycle) break;
                    allowCycle = false;
                    i = 0;
                }
            } else if (--i < 0) {
                if (!allowCycle) break;
                allowCycle = false;
                i = items.length - 1;
            }
            nextItem = items[i];
        } while (nextItem.appearanceMode == 0);
        if (nextItem == null || nextItem.appearanceMode == 0 || nextItem == this.focusedItem) {
            return null;
        }
        Screen screen = this.getScreen();
        Item focItem = this.focusedItem;
        if (screen != null && focItem != null && i > this.focusedIndex && nextItem.relativeY - focItem.relativeY + (focItem.relativeY + this.parentContainer.getRelativeScrollYOffset()) > screen.contentHeight) {
            return null;
        }
        this.focusItem(i, nextItem);
        return nextItem;
    }

    protected boolean isInBottomRow(int index) {
        if (this.columnsSetting == 0 || this.parentContainer.size() <= 1) {
            return index == this.parentContainer.size() - 1;
        }
        int row = index / this.numberOfColumns;
        return row == this.numberOfRows - 1;
    }

    protected void focusItem(int index, Item item) {
        int direction = 0;
        direction = this.focusedIndex < index ? 6 : (this.focusedIndex == index ? 0 : 1);
        this.focusItem(index, item, direction);
    }

    protected void focusItem(int index, Item item, int direction) {
        this.parentContainer.focus(index, item, direction);
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
        Integer columns = style.getIntProperty(4);
        if (columns != null) {
            this.numberOfColumns = columns;
            this.columnsSetting = 2;
            String width = style.getProperty(5);
            if (width != null) {
                if ("equal".equals(width)) {
                    this.columnsSetting = 1;
                } else if (!"normal".equals(width)) {
                    String[] widths = TextUtil.split(width, ',');
                    if (widths.length != this.numberOfColumns) {
                        this.columnsSetting = 2;
                        Debug.debug("warn", "de.enough.polish.ui.ContainerView", 1196, "Container: Invalid [columns-width] setting: [" + width + "], the number of widths needs to be the same as with [columns] specified.");
                    } else {
                        this.columnsSetting = 3;
                        this.columnsWidths = new int[this.numberOfColumns];
                        for (int i = 0; i < widths.length; ++i) {
                            this.columnsWidths[i] = Integer.parseInt(widths[i]);
                        }
                        this.columnsSetting = 3;
                    }
                }
            }
        }
    }

    protected Item getNextFocusableItem(Item[] items, boolean forward, int steps, boolean allowCircle) {
        block11: {
            Item item;
            int i = this.focusedIndex;
            do {
                boolean isInLoop;
                if (forward) {
                    boolean bl = isInLoop = (i += steps) < items.length;
                    if (!isInLoop) {
                        if (steps > 1) {
                            i = items.length - 1;
                            isInLoop = true;
                        } else if (allowCircle) {
                            steps = 1;
                            allowCircle = false;
                            i = 0;
                            isInLoop = true;
                        }
                    }
                } else {
                    boolean bl = isInLoop = (i -= steps) >= 0;
                    if (!isInLoop) {
                        if (steps > 1) {
                            i = 0;
                            isInLoop = true;
                        } else if (allowCircle) {
                            steps = 1;
                            allowCircle = false;
                            i = items.length - 1;
                            isInLoop = true;
                        }
                    }
                }
                if (!isInLoop) break block11;
                item = items[i];
            } while (item.appearanceMode == 0);
            this.focusedIndex = i;
            return item;
        }
        return null;
    }

    public void showNotify() {
        this.restartAnimation = true;
        super.showNotify();
    }

    protected Screen getScreen() {
        return this.parentContainer.getScreen();
    }

    public boolean handleKeyPressed(int keyCode, int gameAction) {
        Item item = this.getNextItem(keyCode, gameAction);
        return item != null;
    }

    protected void scroll(int direction, int x, int y, int width, int height) {
        Item item;
        Container container = this.parentContainer;
        while (!container.enableScrolling && (item = container.parent) instanceof Container) {
            x += container.relativeX;
            y += container.relativeY;
            container = (Container)item;
        }
        if (container.enableScrolling) {
            container.scroll(direction, x, y, width, height);
        }
    }

    protected int getParentRelativeY() {
        return this.parentContainer.relativeY;
    }

    protected int getItemRelativeY(Item item) {
        return item.relativeY;
    }

    protected boolean isValid(Item parent, Style style) {
        return parent instanceof Container;
    }

    public Style focusItem(int index, Item item, int direction, Style focusedStyle) {
        this.focusedIndex = index;
        this.focusedItem = item;
        return item.focus(focusedStyle, direction);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        this.allowCycling = dataInputStream.readBoolean();
        this.allowsAutoTraversal = dataInputStream.readBoolean();
        this.allowsDirectSelectionByPointerEvent = dataInputStream.readBoolean();
        this.appearanceMode = dataInputStream.readInt();
        this.columnsSetting = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.columnsWidths = new int[n2];
            n = 0;
            while (n < n2) {
                this.columnsWidths[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.focusFirstElement = dataInputStream.readBoolean();
        this.focusedIndex = dataInputStream.readInt();
        this.isHorizontal = dataInputStream.readBoolean();
        this.isVertical = dataInputStream.readBoolean();
        this.numberOfColumns = dataInputStream.readInt();
        this.numberOfRows = dataInputStream.readInt();
        this.restartAnimation = dataInputStream.readBoolean();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.rowsHeights = new int[n2];
            n = 0;
            while (n < n2) {
                this.rowsHeights[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.yOffset = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.allowCycling);
        dataOutputStream.writeBoolean(this.allowsAutoTraversal);
        dataOutputStream.writeBoolean(this.allowsDirectSelectionByPointerEvent);
        dataOutputStream.writeInt(this.appearanceMode);
        dataOutputStream.writeInt(this.columnsSetting);
        if (this.columnsWidths == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.columnsWidths.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.columnsWidths[n]);
                ++n;
            }
        }
        dataOutputStream.writeBoolean(this.focusFirstElement);
        dataOutputStream.writeInt(this.focusedIndex);
        dataOutputStream.writeBoolean(this.isHorizontal);
        dataOutputStream.writeBoolean(this.isVertical);
        dataOutputStream.writeInt(this.numberOfColumns);
        dataOutputStream.writeInt(this.numberOfRows);
        dataOutputStream.writeBoolean(this.restartAnimation);
        if (this.rowsHeights == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.rowsHeights.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.rowsHeights[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.yOffset);
    }
}

