/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.io.Externalizable;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Border;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public abstract class ItemView
implements Externalizable {
    protected int contentWidth;
    protected int contentHeight;
    protected int paddingVertical;
    protected int paddingHorizontal;
    protected int layout;
    protected boolean isLayoutCenter;
    protected boolean isLayoutRight;
    protected transient Item parentItem;
    protected boolean isFocused;

    protected abstract void initContent(Item var1, int var2, int var3);

    protected abstract void paintContent(Item var1, int var2, int var3, int var4, int var5, Graphics var6);

    protected void initContentByParent(Item parent, int firstLineWidth, int lineWidth) {
        parent.initContent(firstLineWidth, lineWidth);
        this.contentWidth = parent.contentWidth;
        this.contentHeight = parent.contentHeight;
    }

    protected void paintContentByParent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        parent.paintContent(x, y, leftBorder, rightBorder, g);
    }

    public void focus(Style focusstyle, int direction) {
        this.isFocused = true;
        if (focusstyle != null) {
            this.setStyle(focusstyle);
        }
    }

    protected void defocus(Style originalStyle) {
        this.isFocused = false;
        if (originalStyle != null) {
            this.setStyle(originalStyle);
        }
    }

    protected void setStyle(Style style) {
        this.paddingHorizontal = style.paddingHorizontal;
        this.paddingVertical = style.paddingVertical;
        this.layout = style.layout;
        if ((this.layout & 3) == 3) {
            this.isLayoutCenter = true;
            this.isLayoutRight = false;
        } else {
            this.isLayoutCenter = false;
            this.isLayoutRight = (this.layout & 2) == 2;
        }
    }

    public void requestInit() {
        if (this.parentItem != null) {
            this.parentItem.requestInit();
        }
    }

    public Background removeParentBackground() {
        if (this.parentItem == null) {
            Debug.debug("warn", "de.enough.polish.ui.ItemView", 198, "Unable to remove parent background when parent field is not set.");
            return null;
        }
        Background bg = this.parentItem.background;
        this.parentItem.background = null;
        return bg;
    }

    public Border removeParentBorder() {
        if (this.parentItem == null) {
            Debug.debug("warn", "de.enough.polish.ui.ItemView", 214, "Unable to remove parent border when parentContainer field is not set.");
            return null;
        }
        Border border = this.parentItem.border;
        this.parentItem.border = null;
        return border;
    }

    protected Border removeItemBorder(Item item) {
        Border border = item.border;
        item.border = null;
        return border;
    }

    protected Background removeItemBackground(Item item) {
        Background background = item.background;
        item.background = null;
        return background;
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        if (this.animate()) {
            this.addFullRepaintRegion(this.parentItem, repaintRegion);
        }
    }

    protected void addFullRepaintRegion(Item item, ClippingRegion repaintRegion) {
        repaintRegion.addRegion(item.getAbsoluteX(), item.getAbsoluteY(), item.itemWidth, item.itemHeight);
    }

    public boolean animate() {
        return false;
    }

    public void showNotify() {
    }

    public void hideNotify() {
    }

    protected Screen getScreen() {
        return this.parentItem.getScreen();
    }

    public boolean handleKeyPressed(int keyCode, int gameAction) {
        return false;
    }

    public boolean handleKeyReleased(int keyCode, int gameAction) {
        return false;
    }

    protected boolean isValid(Item parent, Style style) {
        return true;
    }

    protected void removeViewFromParent() {
        this.parentItem.view = null;
    }

    protected boolean notifyItemPressedStart() {
        return this.parentItem.notifyItemPressedStart();
    }

    protected void notifyItemPressedEnd() {
        this.parentItem.notifyItemPressedEnd();
    }

    public void paintBackground(Background background, int x, int y, int width, int height, Graphics g) {
        background.paint(x, y, width, height, g);
    }

    public void paintBorder(Border border, int x, int y, int width, int height, Graphics g) {
        border.paint(x, y, width, height, g);
    }

    public void releaseResources() {
        if (this.parentItem != null) {
            this.parentItem.isInitialized = false;
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.contentHeight = dataInputStream.readInt();
        this.contentWidth = dataInputStream.readInt();
        this.isFocused = dataInputStream.readBoolean();
        this.isLayoutCenter = dataInputStream.readBoolean();
        this.isLayoutRight = dataInputStream.readBoolean();
        this.layout = dataInputStream.readInt();
        this.paddingHorizontal = dataInputStream.readInt();
        this.paddingVertical = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.contentHeight);
        dataOutputStream.writeInt(this.contentWidth);
        dataOutputStream.writeBoolean(this.isFocused);
        dataOutputStream.writeBoolean(this.isLayoutCenter);
        dataOutputStream.writeBoolean(this.isLayoutRight);
        dataOutputStream.writeInt(this.layout);
        dataOutputStream.writeInt(this.paddingHorizontal);
        dataOutputStream.writeInt(this.paddingVertical);
    }
}

