/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class CircleBackground
extends Background {
    private int color;
    private int diameter;
    private int anchor;
    private int xOffset;
    private int yOffset;
    private boolean isPercent;

    public CircleBackground(int color, int diameter, int anchor, int xOffset, int yOffset) {
        this.color = color;
        this.isPercent = diameter < -1;
        this.diameter = this.isPercent ? -diameter : diameter;
        this.anchor = anchor;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        x += this.xOffset;
        y += this.yOffset;
        if (this.diameter != -1) {
            int diam = this.diameter;
            if (this.isPercent) {
                diam = diam * Math.min(width, height) / 100;
            }
            if ((this.anchor & 1) == 1) {
                x += (width - diam) / 2;
            } else if ((this.anchor & 8) == 8) {
                x += width - diam;
            }
            if ((this.anchor & 2) == 2) {
                y += (height - diam) / 2;
            } else if ((this.anchor & 0x20) == 32) {
                y += height - diam;
            }
            width = diam;
            height = diam;
        }
        g.setColor(this.color);
        g.fillArc(x, y, width, height, 0, 360);
    }

    public CircleBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.anchor = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
        this.diameter = dataInputStream.readInt();
        this.isPercent = dataInputStream.readBoolean();
        this.xOffset = dataInputStream.readInt();
        this.yOffset = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.anchor);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeInt(this.diameter);
        dataOutputStream.writeBoolean(this.isPercent);
        dataOutputStream.writeInt(this.xOffset);
        dataOutputStream.writeInt(this.yOffset);
    }
}

