/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class GradientHorizontalBackground
extends Background {
    private int leftColor;
    private int rightColor;
    private int stroke;
    private int start;
    private int end;
    private boolean isPercent;
    private int[] gradient;
    private int lastWidth;
    private int startLine;
    private int endLine;

    public GradientHorizontalBackground(int leftColor, int rightColor, int stroke) {
        this(leftColor, rightColor, stroke, 0, 0, false);
    }

    public GradientHorizontalBackground(int leftColor, int rightColor, int stroke, int start, int end, boolean isPercent) {
        this.leftColor = leftColor;
        this.rightColor = rightColor;
        this.stroke = stroke;
        this.start = start;
        this.end = end;
        this.isPercent = isPercent;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        g.setStrokeStyle(this.stroke);
        int startOffset = this.startLine;
        int endOffset = this.endLine;
        if (this.gradient == null || this.lastWidth != width) {
            int steps = width;
            if (this.start != this.end) {
                steps = this.end - this.start;
                if (this.isPercent) {
                    this.startLine = this.start * width / 100;
                    this.endLine = this.end * width / 100;
                    steps = this.endLine - this.startLine;
                } else {
                    this.startLine = this.start;
                    this.endLine = this.end;
                }
                startOffset = this.startLine;
                endOffset = this.endLine;
            } else {
                this.endLine = width;
                endOffset = width;
            }
            this.gradient = DrawUtil.getGradient(this.leftColor, this.rightColor, steps);
            this.lastWidth = width;
        }
        g.setColor(this.leftColor);
        for (int i = 0; i < width; ++i) {
            if (i >= startOffset && i < endOffset) {
                int color = this.gradient[i - startOffset];
                g.setColor(color);
            }
            g.drawLine(x, y, x, y + height);
            ++x;
        }
        g.setStrokeStyle(0);
    }

    public GradientHorizontalBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.end = dataInputStream.readInt();
        this.endLine = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.gradient = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.gradient[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
        this.isPercent = dataInputStream.readBoolean();
        this.lastWidth = dataInputStream.readInt();
        this.leftColor = dataInputStream.readInt();
        this.rightColor = dataInputStream.readInt();
        this.start = dataInputStream.readInt();
        this.startLine = dataInputStream.readInt();
        this.stroke = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.end);
        dataOutputStream.writeInt(this.endLine);
        if (this.gradient == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.gradient.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.gradient[n2]);
                ++n2;
            }
        }
        dataOutputStream.writeBoolean(this.isPercent);
        dataOutputStream.writeInt(this.lastWidth);
        dataOutputStream.writeInt(this.leftColor);
        dataOutputStream.writeInt(this.rightColor);
        dataOutputStream.writeInt(this.start);
        dataOutputStream.writeInt(this.startLine);
        dataOutputStream.writeInt(this.stroke);
    }
}

