/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class PulsatingBackground
extends Background {
    private int currentColor;
    private int[] colors;
    private int currentStep;
    private boolean repeat;
    private boolean backAndForth;
    private boolean directionUp;
    private boolean animationStopped;

    public PulsatingBackground(int startColor, int endColor, int steps, boolean repeat, boolean backAndForth) {
        this(DrawUtil.getGradient(startColor, endColor, steps), repeat, backAndForth);
    }

    public PulsatingBackground(int[] colors, boolean repeat, boolean backAndForth) {
        this.directionUp = true;
        this.currentColor = colors[0];
        this.colors = colors;
        this.repeat = repeat;
        this.backAndForth = backAndForth;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        g.setColor(this.currentColor);
        g.fillRect(x, y, width + 1, height + 1);
    }

    public boolean animate() {
        if (this.animationStopped) {
            return false;
        }
        if (this.backAndForth) {
            if (this.directionUp) {
                ++this.currentStep;
                if (this.currentStep == this.colors.length) {
                    --this.currentStep;
                    this.directionUp = false;
                }
            } else {
                --this.currentStep;
                if (this.currentStep == -1) {
                    this.currentStep = 0;
                    if (this.repeat) {
                        this.directionUp = true;
                    } else {
                        this.animationStopped = true;
                    }
                }
            }
        } else {
            ++this.currentStep;
            if (this.currentStep == this.colors.length) {
                if (this.repeat) {
                    this.currentStep = 0;
                } else {
                    --this.currentStep;
                    this.animationStopped = true;
                }
            }
        }
        this.currentColor = this.colors[this.currentStep];
        return true;
    }

    public PulsatingBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.animationStopped = dataInputStream.readBoolean();
        this.backAndForth = dataInputStream.readBoolean();
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.colors = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.colors[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
        this.currentColor = dataInputStream.readInt();
        this.currentStep = dataInputStream.readInt();
        this.directionUp = dataInputStream.readBoolean();
        this.repeat = dataInputStream.readBoolean();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.animationStopped);
        dataOutputStream.writeBoolean(this.backAndForth);
        if (this.colors == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.colors.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.colors[n2]);
                ++n2;
            }
        }
        dataOutputStream.writeInt(this.currentColor);
        dataOutputStream.writeInt(this.currentStep);
        dataOutputStream.writeBoolean(this.directionUp);
        dataOutputStream.writeBoolean(this.repeat);
    }
}

