/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.borders;

import de.enough.polish.ui.Border;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class TopBottomLeftRightBorder
extends Border {
    private int color;
    private int topWidth;
    private int bottomWidth;
    private int leftWidth;
    private int rightWidth;

    public TopBottomLeftRightBorder(int color, int topWidth, int bottomWidth, int leftWidth, int rightWidth) {
        this.color = color;
        this.topWidth = topWidth;
        this.bottomWidth = bottomWidth;
        this.leftWidth = leftWidth;
        this.rightWidth = rightWidth;
        this.borderWidth = Math.max(topWidth, Math.max(bottomWidth, Math.max(leftWidth, rightWidth)));
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int border;
        g.setColor(this.color);
        int rightX = x + width;
        int bottomY = y + height;
        for (border = this.topWidth - 1; border >= 0; --border) {
            g.drawLine(x, y + border, rightX, y + border);
        }
        for (border = this.bottomWidth - 1; border >= 0; --border) {
            g.drawLine(x, bottomY - border, rightX, bottomY - border);
        }
        for (border = this.leftWidth - 1; border >= 0; --border) {
            g.drawLine(x + border, y, x + border, bottomY);
        }
        for (border = this.rightWidth - 1; border >= 0; --border) {
            g.drawLine(rightX - border, y, rightX - border, bottomY);
        }
    }

    public TopBottomLeftRightBorder() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.bottomWidth = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
        this.leftWidth = dataInputStream.readInt();
        this.rightWidth = dataInputStream.readInt();
        this.topWidth = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.bottomWidth);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeInt(this.leftWidth);
        dataOutputStream.writeInt(this.rightWidth);
        dataOutputStream.writeInt(this.topWidth);
    }
}

