/*
 * Decompiled with CFR 0.152.
 */
package com.sina.net;

import com.sina.core.CommonUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.SocketConnection;

public class SocketHttpConnection
implements HttpConnection {
    private SocketConnection socket;
    private boolean isUseProxy;
    private Hashtable requestHeadTable = new Hashtable();
    private Hashtable responseHeadTable = new Hashtable();
    private boolean isPost;
    private String url;
    private String host;
    private int port;
    private String requestUrl;
    private boolean isSSL;
    private boolean isDoResponseReturn;
    private ByteArrayOutputStream postStream;
    private DataOutputStream sendStream;
    private DataInputStream responseStream;
    private int responseCode;
    private String responseMessage;
    private UrlParts parts;
    private byte[] sendData;

    public SocketHttpConnection(String url, boolean isUseProxy, String proxyHost, int proxyPort) {
        this.url = url;
        this.isUseProxy = isUseProxy;
        this.postStream = new ByteArrayOutputStream();
        this.parts = new UrlParts(url);
        if (isUseProxy) {
            this.host = proxyHost;
            this.port = proxyPort;
            try {
                this.setRequestProperty("X-Online-Host", CommonUtils.getUrlHost(url));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.requestUrl = CommonUtils.getUrlWithoutHost(url);
            if (!this.requestUrl.startsWith("/")) {
                this.requestUrl = "/" + this.requestUrl;
            }
        } else {
            this.isSSL = url.substring(0, 8).toLowerCase().equals("https://");
            this.port = this.isSSL ? 443 : 80;
            this.host = CommonUtils.getUrlHost(url);
            this.requestUrl = CommonUtils.getUrlWithoutHost(url);
            if (!this.requestUrl.startsWith("/")) {
                this.requestUrl = "/" + this.requestUrl;
            }
        }
    }

    private void checkResponse() throws IOException {
        if (!this.isDoResponseReturn) {
            this.doStartWork();
        }
    }

    private void doStartWork() throws IOException {
        this.socket = (SocketConnection)Connector.open((String)("socket://" + this.host + ":" + this.port), (int)3);
        this.socket.setSocketOption((byte)0, 0);
        this.socket.setSocketOption((byte)2, 3000);
        this.socket.setSocketOption((byte)1, 3000);
        this.sendStream = this.socket.openDataOutputStream();
        this.responseStream = this.socket.openDataInputStream();
        String head = this.buildRequestHead();
        ((OutputStream)this.sendStream).write(head.getBytes());
        byte[] postBuffer = this.postStream.toByteArray();
        this.sendStream.write(postBuffer, 0, postBuffer.length);
        this.sendStream.flush();
        if (this.sendData != null) {
            this.sendStream.write(this.sendData, 0, this.sendData.length);
            this.sendStream.flush();
        }
        ByteArrayOutputStream responseHeadStream = new ByteArrayOutputStream();
        String responseHead = "";
        byte[] firstHeadBuffer = new byte[100];
        int firstLen = this.responseStream.read(firstHeadBuffer, 0, 100);
        if (firstLen > 0) {
            responseHeadStream.write(firstHeadBuffer, 0, firstLen);
        }
        while (true) {
            byte abyte1;
            byte abyte = this.responseStream.readByte();
            responseHeadStream.write(abyte);
            responseHeadStream.flush();
            if (abyte == 13) {
                abyte1 = this.responseStream.readByte();
                responseHeadStream.write(abyte);
                responseHeadStream.flush();
                if (abyte1 != 10) continue;
                byte abyte2 = this.responseStream.readByte();
                responseHeadStream.write(abyte);
                responseHeadStream.flush();
                if (abyte2 != 13) continue;
                byte abyte3 = this.responseStream.readByte();
                responseHeadStream.write(abyte);
                responseHeadStream.flush();
                if (abyte3 != 10) continue;
                break;
            }
            if (abyte != 10) continue;
            abyte1 = this.responseStream.readByte();
            responseHeadStream.write(abyte);
            responseHeadStream.flush();
            if (abyte1 == 10) break;
        }
        responseHead = new String(responseHeadStream.toByteArray());
        String[] responseLines = CommonUtils.split(responseHead, "\r\n");
        String[] firstParams = CommonUtils.split(responseLines[0], " ");
        this.responseCode = CommonUtils.parseInt(firstParams[1]);
        this.responseMessage = firstParams[2];
        int n = 1;
        while (n < responseLines.length) {
            String[] lineParams;
            if (responseLines[n].length() > 2 && (lineParams = CommonUtils.split(responseLines[n], ": ")) != null && lineParams.length > 1) {
                String headName = lineParams[0].toLowerCase();
                String headValue = lineParams[1];
                this.responseHeadTable.put(headName, headValue);
            }
            ++n;
        }
        this.isDoResponseReturn = true;
    }

    private String buildRequestHead() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.isPost ? "POST" : "GET");
        sb.append(" ");
        sb.append(this.requestUrl);
        sb.append(" HTTP/1.0\r\n");
        this.requestHeadTable.put("Host", this.host);
        this.requestHeadTable.put("Connection", "Close");
        Enumeration keyEnum = this.requestHeadTable.keys();
        while (keyEnum.hasMoreElements()) {
            String key = (String)keyEnum.nextElement();
            String value = (String)this.requestHeadTable.get(key);
            sb.append(key);
            sb.append(": ");
            sb.append(value);
            sb.append("\r\n");
        }
        sb.append("\r\n");
        String result = sb.toString();
        sb = null;
        return result;
    }

    public void setIsUseCmwapProxy(boolean value) {
        this.isUseProxy = value;
    }

    public String getHeaderField(String name) throws IOException {
        this.checkResponse();
        String result = (String)this.responseHeadTable.get(name.toLowerCase());
        return result;
    }

    public int getResponseCode() throws IOException {
        this.checkResponse();
        return this.responseCode;
    }

    public long getLength() {
        int result = -1;
        try {
            result = this.getHeaderFieldInt("content-length", -1);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void setRequestMethod(String method) throws IOException {
        this.isPost = method.toLowerCase().equals("POST".toLowerCase());
    }

    public void setRequestProperty(String key, String value) throws IOException {
        this.requestHeadTable.put(key, value);
    }

    public InputStream openInputStream() throws IOException {
        this.checkResponse();
        return this.responseStream;
    }

    public DataInputStream openDataInputStream() throws IOException {
        this.checkResponse();
        return this.responseStream;
    }

    public void close() throws IOException {
        if (this.sendStream != null) {
            this.sendStream.close();
            this.sendStream = null;
        }
        if (this.postStream != null) {
            this.postStream.close();
            this.postStream = null;
        }
        if (this.responseStream != null) {
            this.responseStream.close();
            this.responseStream = null;
        }
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    public OutputStream openOutputStream() throws IOException {
        return this.postStream;
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        DataOutputStream dos = new DataOutputStream(this.postStream);
        return dos;
    }

    public void setSendData(byte[] data) {
        this.sendData = data;
    }

    public String getURL() {
        return this.url;
    }

    public String getProtocol() {
        return this.isSSL ? "https" : "http";
    }

    public String getHost() {
        return this.host;
    }

    public String getFile() {
        return CommonUtils.getUrlFile(this.url);
    }

    public String getRef() {
        return this.parts.getRef();
    }

    public String getQuery() {
        return this.parts.getQuery();
    }

    public int getPort() {
        return this.port;
    }

    public String getRequestMethod() {
        return this.isPost ? "POST" : "GET";
    }

    public String getRequestProperty(String arg0) {
        return (String)this.requestHeadTable.get(arg0);
    }

    public String getResponseMessage() throws IOException {
        this.checkResponse();
        return this.responseMessage;
    }

    public long getExpiration() throws IOException {
        throw new IOException("Not supported yet.");
    }

    public long getDate() throws IOException {
        throw new IOException("Not supported yet.");
    }

    public long getLastModified() throws IOException {
        throw new IOException("Not supported yet.");
    }

    public int getHeaderFieldInt(String arg0, int arg1) throws IOException {
        try {
            String str = this.getHeaderField(arg0);
            return Integer.parseInt(str);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return arg1;
        }
    }

    public long getHeaderFieldDate(String arg0, long arg1) throws IOException {
        throw new IOException("Not supported yet.");
    }

    public String getHeaderField(int idx) throws IOException {
        Enumeration headerEnum = this.responseHeadTable.elements();
        int startIdx = 0;
        while (headerEnum.hasMoreElements()) {
            Object valueObj = headerEnum.nextElement();
            if (startIdx == idx) {
                return (String)valueObj;
            }
            ++startIdx;
        }
        return null;
    }

    public String getHeaderFieldKey(int idx) throws IOException {
        Enumeration headerEnum = this.responseHeadTable.keys();
        int startIdx = 0;
        while (headerEnum.hasMoreElements()) {
            Object keyObj = headerEnum.nextElement();
            if (startIdx == idx) {
                return (String)keyObj;
            }
            ++startIdx;
        }
        return null;
    }

    public String getType() {
        return "SocketHttpConnection";
    }

    public String getEncoding() {
        return "UTF-8";
    }

    private class UrlParts {
        String path;
        String query;
        String ref;

        UrlParts(String file) {
            int ind = file.indexOf(35);
            this.ref = ind < 0 ? null : file.substring(ind + 1);
            file = ind < 0 ? file : file.substring(0, ind);
            int q = file.lastIndexOf(63);
            if (q != -1) {
                this.query = file.substring(q + 1);
                this.path = file.substring(0, q);
            } else {
                this.path = file;
            }
        }

        String getPath() {
            return this.path;
        }

        String getQuery() {
            return this.query;
        }

        String getRef() {
            return this.ref;
        }
    }
}

