/*
 * Decompiled with CFR 0.152.
 */
package com.sina.ui;

import com.sina.ui.ComboBoxItem;
import com.sina.ui.ComboBoxListener;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import com.sina.weibo.view.AbstractView;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ComboBoxListStage
extends AbstractView {
    public ComboBoxItem comboBoxItem;
    public ComboBoxListStage instance;
    public String title;
    public int listItemHeight = G.SYS_FONTLINE_HEIGHT + 6;
    public int showHeight = G.H - G.TitleBarHeight - G.MenuBarHeight;
    public int maxListNum = this.showHeight / this.listItemHeight;
    public int offIndex;
    public int itemImageW = 20;
    public int itemImageH = 20;
    public ComboBoxListener listener;
    private int selectedIndex;

    public ComboBoxListStage(ComboBoxItem cbItem, ComboBoxListener listener1) {
        this.listener = listener1;
        this.comboBoxItem = cbItem;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < cbItem.title.length) {
            sb.append(cbItem.title[i]);
            ++i;
        }
        this.title = sb.toString();
        this.offIndex = this.comboBoxItem.selectedId;
        this.selectedIndex = 0;
        if (this.offIndex + this.maxListNum > this.comboBoxItem.textList.length - 1) {
            this.offIndex = this.comboBoxItem.textList.length - this.maxListNum;
            if (this.offIndex < 0) {
                this.offIndex = 0;
            }
            this.selectedIndex = (byte)(this.comboBoxItem.selectedId - this.offIndex);
        }
        this.instance = this;
    }

    public void keyPressed(int keyCode) {
        byte keyType = Tools.keyCompare(keyCode);
        switch (keyType) {
            case 5: 
            case 7: {
                this.comboBoxItem.selectedId = this.offIndex + this.selectedIndex;
                this.listener.OKComboBoxList(this.comboBoxItem);
                break;
            }
            case 6: {
                this.listener.CancelComboBoxList(this.comboBoxItem);
                break;
            }
            case 1: {
                --this.selectedIndex;
                if (this.selectedIndex >= 0) break;
                if (this.offIndex > 0) {
                    this.selectedIndex = 0;
                    --this.offIndex;
                    break;
                }
                this.selectedIndex = (byte)(Math.min(this.maxListNum, this.comboBoxItem.textList.length) - 1);
                this.offIndex = (byte)(this.comboBoxItem.textList.length - this.maxListNum);
                if (this.offIndex >= 0) break;
                this.offIndex = 0;
                break;
            }
            case 2: {
                ++this.selectedIndex;
                if (this.offIndex + this.selectedIndex > this.comboBoxItem.textList.length - 1) {
                    this.selectedIndex = 0;
                    this.offIndex = 0;
                    break;
                }
                if (this.selectedIndex <= this.maxListNum - 1) break;
                ++this.offIndex;
                this.selectedIndex = (byte)(this.maxListNum - 1);
            }
        }
        this.render();
    }

    public void paint(Graphics g) {
        int offx = 5;
        int offy = 5;
        g.setColor(0xEBEBEB);
        g.fillRect(0, 5, G.W, G.TitleBarHeight);
        g.setColor(0);
        g.drawString(this.title, 5, 6, 20);
        offy += G.TitleBarHeight + 2;
        g.setClip(0, G.TitleBarHeight, G.W, this.showHeight);
        int i = this.offIndex;
        int j = 0;
        while (i < this.comboBoxItem.textList.length && j < this.maxListNum) {
            Image img;
            if (j == this.selectedIndex) {
                g.setColor(G.MenuSelectColor);
            } else {
                g.setColor(G.ComboBackColor);
            }
            g.fillRect(0, offy, G.W - offx, this.listItemHeight - 1);
            String txt = this.comboBoxItem.textList[i];
            if (this.comboBoxItem.imageList != null && (img = this.comboBoxItem.imageList[i]) != null) {
                g.setClip(offx, offy + 1, this.itemImageW, this.itemImageH);
                g.drawImage(img, offx, offy + 1, 20);
                g.setClip(0, G.TitleBarHeight, G.W, this.showHeight);
                g.setColor(0);
                g.drawString(txt, offx + 4 + this.itemImageW, offy + 4, 20);
            }
            if (j == this.selectedIndex) {
                g.setColor(0xFFFFFF);
            } else {
                g.setColor(0);
            }
            g.drawString(txt, offx, offy + 4, 20);
            offy += this.listItemHeight;
            ++i;
            ++j;
        }
        if (this.comboBoxItem.textList.length > this.maxListNum) {
            Tools.drawListRollBar(g, G.TitleBarHeight + 7, this.listItemHeight, this.offIndex, this.comboBoxItem.textList.length, this.maxListNum, this.maxListNum, 0);
        }
        Tools.drawMenuBar(g, "\u9009\u62e9", "\u53d6\u6d88", null);
    }

    public void destroy() {
    }

    public void destroyApp() {
    }
}

