/*
 * Decompiled with CFR 0.152.
 */
package com.sina.ui;

import com.sina.ui.ControlItem;
import com.sina.ui.ListListener;
import com.sina.ui.RollContainer;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CommentListItem
extends ControlItem {
    private ListListener listener;
    private int index;
    private String[] content;
    private int lineHeight = G.SHOW_FONT.getHeight() + 2;
    private Image selectBack;
    private Image unselectBack;
    private boolean showBack = true;
    private String user;
    private String time;
    private int contentColor = 3160910;

    public CommentListItem(String title, String time, String content, int index, ListListener listener, RollContainer rc) {
        this.width = rc.width;
        this.index = index;
        this.listener = listener;
        this.user = title;
        this.time = time;
        this.setContent(content);
        this.update();
    }

    public void gotFocus(byte pos) {
        super.gotFocus(pos);
        this.update();
    }

    public void gotFocus() {
        super.gotFocus();
        this.update();
    }

    public void lostFocus() {
        super.lostFocus();
        this.update();
    }

    private void update() {
        int h = (this.content.length + 1) * this.lineHeight + 6;
        if (this.height < h) {
            this.height = h;
        }
    }

    public void setContent(String title) {
        this.content = Tools.stringFormatArray(title, this.width - 15, G.SHOW_FONT);
        this.update();
    }

    public void doEntry() {
        if (this.listener != null) {
            this.listener.listitemPressed(this.index);
        }
    }

    public void setSelectBack(Image path) {
        try {
            this.selectBack = path;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setUnselectBack(Image path) {
        try {
            this.unselectBack = path;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setShowBack(boolean show) {
        this.showBack = show;
    }

    public void paint(Graphics g, int clipx, int clipy) {
        int x;
        if (this.focus) {
            if (this.selectBack != null) {
                x = this.paintx;
                while (x < this.paintx + this.width) {
                    g.drawImage(this.selectBack, x, this.painty, 20);
                    x += this.selectBack.getWidth();
                }
            } else {
                Tools.drawTranceColor(g, 16774882, 15771711, this.paintx + 2, this.painty + 2, this.width - 4, this.height - 4);
            }
        } else if (this.showBack) {
            if (this.unselectBack != null) {
                x = this.paintx;
                while (x < this.paintx + this.width) {
                    g.drawImage(this.unselectBack, x, this.painty, 20);
                    x += this.unselectBack.getWidth();
                }
            } else {
                Tools.drawTranceColor(g, 0xFFFFFF, 0xACACAC, this.paintx, this.painty, this.width, this.height);
            }
        }
        g.setColor(this.contentColor);
        g.drawString(this.user, this.paintx + 10, this.painty + 5 + (this.lineHeight - g.getFont().getHeight()) / 2, 20);
        g.drawString(this.time, this.paintx + this.width - g.getFont().stringWidth(this.time) - 2, this.painty + 5 + (this.lineHeight - g.getFont().getHeight()) / 2, 20);
        int i = 0;
        while (i < this.content.length) {
            g.drawString(this.content[i], this.paintx + 10, this.painty + 5 + (this.lineHeight - g.getFont().getHeight()) / 2 + (i + 1) * this.lineHeight, 20);
            ++i;
        }
    }

    public int getID() {
        return this.index;
    }

    public void setContentColor(int color) {
        this.contentColor = color;
    }
}

