/*
 * Decompiled with CFR 0.152.
 */
package com.sina.ui;

import com.sina.ui.ControlItem;
import com.sina.ui.ListListener;
import com.sina.ui.RollContainer;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ListItem
extends ControlItem {
    public static final byte LEFT = 0;
    public static final byte MIDDLE = 1;
    public static final byte RIGHT = 2;
    private ListListener listener;
    private int index;
    private String[] title;
    private byte align;
    private Image icon;
    private int lineHeight = 22;
    private Image selectBack;
    private Image unselectBack;
    private boolean showBack = true;
    private int startColor = 0xFFFFFF;
    private int endColor = 0xACACAC;
    private int txtColor = 0;
    private boolean showLine;
    private boolean showRight;

    public ListItem(int index, ListListener listener, RollContainer rc) {
        this("", index, listener, rc);
    }

    public ListItem(String title, int index, ListListener listener, RollContainer rc) {
        this(title, index, listener, rc, 0);
    }

    public ListItem(String title, int index, ListListener listener, RollContainer rc, int type) {
        this(title, index, listener, rc, 0);
        if (type == 1) {
            this.startColor = 0xFFFFFF;
            this.endColor = 0xACACAC;
            this.txtColor = 0;
        } else if (type == 2) {
            this.startColor = 0xFFFFFF;
            this.endColor = 0xD0D0D0;
            this.txtColor = 0;
        }
    }

    public ListItem(String title, int index, ListListener listener, RollContainer rc, byte align) {
        this.width = rc.width;
        this.setTitle(title);
        this.index = index;
        this.listener = listener;
        this.align = align;
        this.update();
    }

    public void gotFocus(byte pos) {
        super.gotFocus(pos);
    }

    public void gotFocus() {
        super.gotFocus();
    }

    public void lostFocus() {
        super.lostFocus();
    }

    private void update() {
        if (this.title != null) {
            this.height = this.lineHeight * this.title.length;
        }
        if (this.height < 30) {
            this.height = 30;
            this.lineHeight = 30;
        }
    }

    public void setTitle(String title) {
        this.title = Tools.stringFormatArray(title, this.width - 13, G.SHOW_FONT);
        this.update();
    }

    public void doEntry() {
        if (this.listener != null) {
            this.listener.listitemPressed(this.index);
        }
    }

    public void setSelectBack(Image path) {
        try {
            this.selectBack = path;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setUnselectBack(Image path) {
        try {
            this.unselectBack = path;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setShowBack(boolean show) {
        this.showBack = show;
    }

    public void paint(Graphics g, int clipx, int clipy) {
        int i;
        int x;
        if (this.focus) {
            if (this.selectBack != null) {
                x = this.paintx;
                while (x < this.paintx + this.width) {
                    g.drawImage(this.selectBack, x, this.painty, 20);
                    x += this.selectBack.getWidth();
                }
            } else {
                Tools.drawTranceColor(g, 16774882, 15771711, this.paintx, this.painty, this.width, this.height);
            }
        } else if (this.showBack) {
            if (this.unselectBack != null) {
                x = this.paintx;
                while (x < this.paintx + this.width) {
                    g.drawImage(this.unselectBack, x, this.painty, 20);
                    x += this.unselectBack.getWidth();
                }
            } else {
                Tools.drawTranceColor(g, this.startColor, this.endColor, this.paintx, this.painty, this.width, this.height);
            }
        }
        g.setColor(this.txtColor);
        if (this.align == 0) {
            if (this.icon != null) {
                g.drawImage(this.icon, this.paintx + 5, this.painty + (this.lineHeight - this.icon.getHeight()) / 2, 20);
                i = 0;
                while (i < this.title.length) {
                    g.drawString(this.title[i], this.paintx + 10 + this.icon.getWidth(), this.painty + (this.lineHeight - g.getFont().getHeight()) / 2 + i * this.lineHeight, 20);
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.title.length) {
                    g.drawString(this.title[i], this.paintx + 5, this.painty + (this.lineHeight - g.getFont().getHeight()) / 2 + i * this.lineHeight, 20);
                    ++i;
                }
            }
        } else if (this.align == 1) {
            if (this.icon != null) {
                g.drawImage(this.icon, this.paintx + (this.width - g.getFont().stringWidth(this.title[0]) - this.icon.getWidth()) / 2, this.painty + (this.lineHeight - this.icon.getHeight()) / 2, 20);
                i = 0;
                while (i < this.title.length) {
                    g.drawString(this.title[i], this.paintx + (this.width - g.getFont().stringWidth(this.title[0]) + this.icon.getWidth()) / 2 + 5, this.painty + (this.lineHeight - g.getFont().getHeight()) / 2 + i * this.lineHeight, 20);
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.title.length) {
                    g.drawString(this.title[i], this.paintx + (this.width - g.getFont().stringWidth(this.title[0])) / 2, this.painty + (this.lineHeight - g.getFont().getHeight()) / 2 + i * this.lineHeight, 20);
                    ++i;
                }
            }
        } else {
            if (this.icon != null) {
                g.drawImage(this.icon, this.paintx + this.width - g.getFont().stringWidth(this.title[0]) - this.icon.getWidth() - 5, this.painty + (this.lineHeight - this.icon.getHeight()) / 2, 20);
            }
            i = 0;
            while (i < this.title.length) {
                g.drawString(this.title[i], this.paintx + this.width - g.getFont().stringWidth(this.title[0]), this.painty + (this.lineHeight - g.getFont().getHeight()) / 2 + i * this.lineHeight, 20);
                ++i;
            }
        }
        if (this.showRight) {
            g.drawImage(G.right, this.paintx + this.width - G.right.getWidth() - 5, this.painty + (this.height - G.right.getHeight()) / 2, 20);
        }
        if (this.showLine) {
            g.setColor(0xBDBDBD);
            g.drawLine(this.paintx, this.painty + this.height - 1, this.paintx + this.width, this.painty + this.height - 1);
        }
    }

    public int getID() {
        return this.index;
    }

    public void setIcon(Image smallImage) {
        this.icon = smallImage;
    }

    public void showLine() {
        this.showLine = true;
    }

    public void showRight() {
        this.showRight = true;
    }
}

