/*
 * Decompiled with CFR 0.152.
 */
package com.sina.ui;

import com.sina.ui.ControlItem;
import com.sina.ui.ListListener;
import com.sina.ui.RollContainer;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class WeiboListItem
extends ControlItem {
    private ListListener listener;
    private int index;
    private String[] content;
    private Image icon;
    private int lineHeight = G.SHOW_FONT.getHeight() + 2;
    private Image selectBack;
    private Image unselectBack;
    private boolean showBack = true;
    private boolean showPic;
    private String user;
    private String time;
    private static Image pic;

    static {
        try {
            pic = Image.createImage((String)"/pic.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WeiboListItem(String user, String time, String bowen, String zhuanfa, int index, ListListener listener, RollContainer rc) {
        this(user, time, bowen, zhuanfa, null, index, listener, rc);
    }

    public WeiboListItem(String user, String time, String bowen, String zhuanfa, Image icon, int index, ListListener listener, RollContainer rc) {
        this.width = rc.width;
        this.index = index;
        this.listener = listener;
        this.icon = icon;
        this.user = user;
        this.time = time;
        this.setContent(String.valueOf(zhuanfa) + bowen);
        this.update();
    }

    public void gotFocus(byte pos) {
        super.gotFocus(pos);
        this.update();
    }

    public void gotFocus() {
        super.gotFocus();
        this.update();
    }

    public void lostFocus() {
        super.lostFocus();
        this.update();
    }

    private void update() {
        this.height = 60;
        if (this.icon != null) {
            this.height = this.icon.getHeight() + 10;
        }
        int h = 0;
        h = G.SHOW_FONT.stringWidth(this.content[this.content.length - 1]) > this.width - 80 ? (this.content.length + 2) * this.lineHeight + 6 : (this.content.length + 1) * this.lineHeight + 6;
        if (this.height < h) {
            this.height = h;
        }
    }

    public void setContent(String title) {
        if (title.length() > 40) {
            title = String.valueOf(title.substring(0, 40)) + "...";
        }
        this.content = Tools.stringFormatArray(title, this.width - 60, G.SHOW_FONT);
        this.update();
    }

    public void doEntry() {
        if (this.listener != null) {
            this.listener.listitemPressed(this.index);
        }
    }

    public void setSelectBack(Image path) {
        try {
            this.selectBack = path;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setUnselectBack(Image path) {
        try {
            this.unselectBack = path;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setShowBack(boolean show) {
        this.showBack = show;
    }

    public void paint(Graphics g, int clipx, int clipy) {
        int x;
        if (this.focus) {
            if (this.selectBack != null) {
                x = this.paintx;
                while (x < this.paintx + this.width) {
                    g.drawImage(this.selectBack, x, this.painty, 20);
                    x += this.selectBack.getWidth();
                }
            } else {
                g.setColor(0x434343);
                g.fillRect(this.paintx, this.painty, this.width, this.height);
                Tools.drawTranceColor(g, 16774882, 15771711, this.paintx, this.painty, this.width, this.height);
            }
        } else if (this.showBack) {
            if (this.unselectBack != null) {
                x = this.paintx;
                while (x < this.paintx + this.width) {
                    g.drawImage(this.unselectBack, x, this.painty, 20);
                    x += this.unselectBack.getWidth();
                }
            } else {
                Tools.drawTranceColor(g, 0xFFFFFF, 0xACACAC, this.paintx, this.painty, this.width, this.height);
            }
        }
        g.setColor(7879725);
        g.drawString(this.user, this.paintx + 60, this.painty + 5 + (this.lineHeight - g.getFont().getHeight()) / 2, 20);
        g.setColor(7879725);
        g.drawString(this.time, this.paintx + this.width - g.getFont().stringWidth(this.time) - 2, this.painty + 5 + (this.lineHeight - g.getFont().getHeight()) / 2, 20);
        g.setColor(0xA4A4A4);
        g.drawRect(this.paintx + 4, this.painty + 4, 52, 52);
        if (this.icon != null) {
            g.drawImage(this.icon, this.paintx + 5, this.painty + 5, 20);
        } else {
            g.drawImage(G.defaultHead, this.paintx + 5, this.painty + 5, 20);
        }
        boolean startAt = false;
        int num = 0;
        int i = 0;
        while (i < this.content.length) {
            int offx = this.paintx + 60;
            int j = 0;
            while (j < this.content[i].length()) {
                char c = this.content[i].charAt(j);
                if (c == '@') {
                    startAt = true;
                    ++num;
                } else if (!(!startAt || (c >= '\u4e00' && c <= '\u9fa5' || c >= '\uff00' && c <= '\uffff' || c >= '\u0800' && c <= '\u4e00' || c >= '\u3130' && c <= '\u318f' || c >= '\uac00' && c <= '\ud7a3' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') && G.atMark.indexOf(c) < 0)) {
                    startAt = false;
                }
                if (startAt) {
                    g.setColor(G.LinkTxtColor);
                } else {
                    g.setColor(3160910);
                }
                g.drawChar(c, offx, this.painty + 5 + (this.lineHeight - g.getFont().getHeight()) / 2 + (i + 1) * this.lineHeight, 20);
                offx += g.getFont().charWidth(c);
                ++j;
            }
            ++i;
        }
        if (this.showPic) {
            g.drawImage(pic, this.paintx + this.width - pic.getWidth() - 2, this.painty + this.height - pic.getHeight() - 2, 20);
        }
    }

    public int getID() {
        return this.index;
    }

    public void setIcon(Image smallImage) {
        this.icon = smallImage;
    }

    public void showPic(boolean showPic) {
        this.showPic = showPic;
    }
}

