/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.data;

import com.sina.http.HttpEngine;
import com.sina.http.HttpListener;
import com.sina.http.URLEncoder;
import com.sina.parser.xml.XMLDataBlock;
import com.sina.parser.xml.XMLDataListener;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.data.Bowen;
import com.sina.weibo.data.Comment;
import java.io.IOException;
import java.util.Vector;

public class CommentListModel
implements XMLDataListener,
HttpListener {
    public Vector commentLsit = new Vector();
    private ClientManager cm;
    public int pagesize = 20;
    private int httpid;
    public int pages;
    public int pageId = 1;
    private Bowen bowen;

    public CommentListModel(ClientManager cm, Bowen bowen) {
        this.cm = cm;
        this.bowen = bowen;
        this.getCommentList(0);
    }

    public void getCommentList(int pageID) {
        StringBuffer send = new StringBuffer();
        send.append("pagesize=10&sid=");
        send.append(this.cm.currentAccount.sessionID);
        send.append("&gsid=");
        send.append(this.cm.currentAccount.gsid);
        send.append("&srcuid=");
        send.append(this.bowen.uid);
        send.append("&srcid=");
        send.append(this.bowen.mblogid);
        send.append("&page=");
        send.append(pageID);
        send.append("&pagesize=");
        send.append(this.pagesize);
        this.cm.httpEngine.HttpConnect(0, 0, String.valueOf(G.serverPath) + "getattcommentlist.php?" + send.toString(), null, this, HttpEngine.HIGH);
        this.cm.setWait(true);
    }

    public boolean blockArrived(XMLDataBlock data) {
        if (this.httpid == 0) {
            return this.parseCommList(data);
        }
        if (this.httpid == 1) {
            this.parseAddPinglun(data);
        }
        return true;
    }

    private void parseAddPinglun(XMLDataBlock data) {
        try {
            if (!data.getTagName().equals("rss")) {
                this.cm.showAlert("\u53d1\u9001\u5931\u8d25");
                this.cm.setWait(false);
                return;
            }
            Vector childvc = data.getChildBlocks();
            boolean err = false;
            if (childvc != null) {
                int i = 0;
                while (i < childvc.size()) {
                    XMLDataBlock itemdata = (XMLDataBlock)childvc.elementAt(i);
                    if (itemdata.getTagName().equals("sid")) {
                        this.cm.currentAccount.sessionID = itemdata.getText();
                    } else if (itemdata.getTagName().equals("result")) {
                        if ("0".equals(itemdata.getText())) {
                            err = true;
                        }
                    } else if (itemdata.getTagName().equals("errno")) {
                        err = true;
                    } else {
                        itemdata.getTagName().equals("errmsg");
                    }
                    itemdata.close();
                    ++i;
                }
            }
            data.close();
            if (!err) {
                this.cm.showAlert("\u53d1\u9001\u6210\u529f\uff01");
            } else {
                this.cm.showAlert("\u53d1\u9001\u5931\u8d25\uff01");
            }
            this.cm.setWait(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean parseCommList(XMLDataBlock data) {
        block35: {
            if (data.getTagName().equals("rss")) break block35;
            return false;
        }
        try {
            this.commentLsit.removeAllElements();
            String err = "";
            Vector childvc = data.getChildBlocks();
            if (childvc != null) {
                int i = 0;
                while (i < childvc.size()) {
                    XMLDataBlock itemdata = (XMLDataBlock)childvc.elementAt(i);
                    if (itemdata.getTagName().equals("comment")) {
                        Comment item = new Comment();
                        Vector child2 = itemdata.getChildBlocks();
                        if (child2 != null) {
                            int j = 0;
                            while (j < child2.size()) {
                                XMLDataBlock cc = (XMLDataBlock)child2.elementAt(j);
                                if (cc.getTagName().equals("nick")) {
                                    item.nick = cc.getText();
                                } else if (cc.getTagName().equals("uid")) {
                                    item.uid = cc.getText();
                                } else if (cc.getTagName().equals("couid")) {
                                    item.couid = cc.getText();
                                } else if (cc.getTagName().equals("conick")) {
                                    item.conick = cc.getText();
                                } else if (cc.getTagName().equals("content")) {
                                    item.content = cc.getText();
                                } else if (cc.getTagName().equals("commentrt")) {
                                    String s = cc.getText();
                                    item.isZhuanfa = !"0".equals(s);
                                } else if (cc.getTagName().equals("time")) {
                                    try {
                                        item.realtime = Long.parseLong(cc.getText());
                                        item.updateTime();
                                    }
                                    catch (RuntimeException runtimeException) {}
                                } else if (cc.getTagName().equals("cmtid")) {
                                    item.cmtid = cc.getText();
                                } else if (cc.getTagName().equals("cmtuid")) {
                                    item.cmtuid = cc.getText();
                                }
                                cc.close();
                                ++j;
                            }
                        }
                        if (item.conick != null && !"".equals(item.conick)) {
                            item.content = "\u56de\u590d " + item.conick + "\uff1a" + item.content;
                        }
                        this.commentLsit.addElement(item);
                    } else if (itemdata.getTagName().equals("count")) {
                        int count = Integer.parseInt(itemdata.getText());
                        this.pages = count / this.pagesize;
                        if (count % this.pagesize > 0) {
                            ++this.pages;
                        }
                    } else if (!itemdata.getTagName().equals("count") && itemdata.getTagName().equals("errmsg")) {
                        err = itemdata.getText();
                    }
                    ++i;
                }
            }
            data.close();
            if (!"".equals(err)) {
                this.cm.showAlert(err);
            } else {
                this.cm.updateView(8, 0);
            }
            this.cm.setWait(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void handleHttpError(int httpid, String errostr) {
        this.cm.showAlert("\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff01\u8bf7\u5c1d\u8bd5\u5728\u5e10\u6237\u9875\u91cd\u7f6e\u7f51\u7edc\u3002");
        this.cm.setWait(false);
    }

    public boolean receiveHttpResponse(int httpid, int type, byte[] dis) {
        this.httpid = httpid;
        try {
            return this.cm.xmlEngine.receiveHttpResponse(dis, this);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void addComment(int id, String text) {
        Comment comment = (Comment)this.commentLsit.elementAt(id);
        StringBuffer send = new StringBuffer();
        send.append("act=addReply&sid=");
        send.append(this.cm.currentAccount.sessionID);
        send.append("&gsid=");
        send.append(this.cm.currentAccount.gsid);
        send.append("&srcuid=");
        send.append(this.bowen.uid);
        send.append("&srcid=");
        send.append(this.bowen.mblogid);
        send.append("&cmtuid=");
        send.append(comment.uid);
        send.append("&cmtid=");
        send.append(comment.cmtid);
        this.cm.httpEngine.HttpConnect(1, 0, String.valueOf(G.serverPath) + "dealcomment.php?" + send.toString(), "&content=" + URLEncoder.encode(text, "UTF-8"), this, HttpEngine.HIGH);
        this.cm.setWait(true);
    }
}

