/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.view;

import com.sina.ui.BackItem;
import com.sina.ui.ControlItem;
import com.sina.ui.InputBox;
import com.sina.ui.InputListener;
import com.sina.ui.ListItem;
import com.sina.ui.ListListener;
import com.sina.ui.ListRollContainer;
import com.sina.ui.MenuItem;
import com.sina.ui.TabBar;
import com.sina.ui.WeiboListItem;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.SMSManager;
import com.sina.weibo.comm.Tools;
import com.sina.weibo.data.Account;
import com.sina.weibo.data.WebAccountListModel;
import com.sina.weibo.view.AbstractView;

public class GuanzhuListView
extends AbstractView
implements ListListener,
InputListener {
    private String[] menuItems = new String[]{"\u6253\u5f00", "\u53d1\u8868\u5fae\u535a", "\u53d1\u79c1\u4fe1", "\u641c\u7d22", "\u5207\u6362\u7528\u6237", "\u63a8\u8350\u597d\u53cb", "\u9000\u51fa"};
    private WebAccountListModel blm;
    private String touid;

    public GuanzhuListView(ClientManager cm, WebAccountListModel blm) {
        super(cm);
        this.viewID = 11;
        this.blm = blm;
        this.init();
    }

    public void keyPressed(int keyCode) {
        if (this.menu.isOpen) {
            this.menuKeyPressed(keyCode);
            return;
        }
        byte keyType = Tools.keyCompare(keyCode);
        switch (keyType) {
            case 5: 
            case 7: {
                super.keyPressed(keyCode);
                break;
            }
            case 6: {
                this.blm.getAcount(0);
                this.blm.pageId = 1;
                break;
            }
            case 3: {
                this.cm.back(false);
                break;
            }
            case 1: {
                if (!this.list.movePre()) break;
                this.list.gotFocus((byte)1);
                break;
            }
            case 2: {
                if (!this.list.moveNext()) break;
                this.list.gotFocus((byte)0);
                break;
            }
            case 4: {
                if (this.blm.type == 0) {
                    this.cm.changeStageWithId(this.viewID, 12, 0, false);
                    break;
                }
                this.cm.changeStageWithId(this.viewID, 19, 0, false);
            }
        }
    }

    public void destroy() {
    }

    public void doMenuItem(int mid) {
        switch (mid) {
            case 0: {
                this.list.doEntry();
                break;
            }
            case 1: {
                this.cm.changeStageWithId(this.viewID, 5, 0, false);
                break;
            }
            case 2: {
                ControlItem o = this.list.getFocusItem();
                if (!(o instanceof WeiboListItem)) break;
                int id = ((WeiboListItem)o).getID();
                this.touid = ((Account)this.blm.account.elementAt((int)id)).uid;
                new InputBox("\u7ed9" + ((Account)this.blm.account.elementAt((int)id)).nick + "\u56de\u4fe1\uff1a", "", 17, 0, this, 2);
                break;
            }
            case 3: {
                this.cm.search();
                break;
            }
            case 4: {
                this.cm.changeStageWithId(this.viewID, 7, 0, false);
                break;
            }
            case 5: {
                new InputBox("\u624b\u673a\u53f7\uff1a", "", 17, 3, this, 1);
                break;
            }
            case 6: {
                this.cm.quit();
            }
        }
        this.closeMenuList();
    }

    private void init() {
        BackItem li = new BackItem("\u5f53\u524d\u7528\u6237\uff1a" + this.cm.currentAccount.nick);
        li.setPaintx(0);
        li.setPainty(0);
        li.setWidth(G.W);
        this.lrc.addItem(li);
        TabBar tb = new TabBar(G.TabItems, 4 + this.blm.type);
        tb.setPainty(li.getHeight());
        this.list = new ListRollContainer(G.W, G.H - li.getHeight() - G.MenuBarHeight - tb.getHeight());
        this.list.setPainty(li.getHeight() + tb.getHeight());
        this.lrc.addItem(this.list);
        this.lrc.addItem(tb);
        this.menu.setRight("\u5237\u65b0");
        this.update(0);
    }

    public void update(int type) {
        if (this.blm.account.size() > 0) {
            if (type == 1) {
                int i = 0;
                while (i < this.blm.account.size()) {
                    WeiboListItem li = null;
                    li = this.blm.pageId > 1 ? (WeiboListItem)this.list.getItem(i + 1) : (WeiboListItem)this.list.getItem(i);
                    Account bowen = (Account)this.blm.account.elementAt(i);
                    li.setIcon(bowen.headIMG);
                    ++i;
                }
                this.render();
                return;
            }
            if (type == 0) {
                this.list.removeAll();
                if (this.blm != null && this.blm.account != null) {
                    if (this.blm.pageId > 1) {
                        ListItem li = new ListItem("\u4e0a\u4e00\u9875", -1, (ListListener)this, this.list, 1);
                        this.list.addItem(li);
                    }
                    this.blm.loadList = false;
                    int i = 0;
                    while (i < this.blm.account.size()) {
                        Account bowen = (Account)this.blm.account.elementAt(i);
                        WeiboListItem li = new WeiboListItem(bowen.nick, bowen.sex, bowen.fensishu, "", i, this, this.list);
                        li.setIcon(bowen.headIMG);
                        this.list.addItem(li);
                        ++i;
                    }
                    if (this.blm.count > this.blm.pagesize * this.blm.pageId) {
                        ListItem li = new ListItem("\u4e0b\u4e00\u9875", -2, (ListListener)this, this.list, 1);
                        this.list.addItem(li);
                    }
                }
            }
        } else {
            this.list.removeAll();
            ListItem li = new ListItem("\u8bf7\u5237\u65b0\u6570\u636e", -99, (ListListener)this, this.list, 1);
            this.list.addItem(li);
        }
        this.list.gotFocus((byte)1);
        this.render();
    }

    public void listitemPressed(int id) {
        if (id >= 0) {
            this.cm.changeStageWithObject(this.viewID, 13, this.blm.account.elementAt(id), false);
        } else if (id == -1) {
            if (this.blm.pageId > 1) {
                this.blm.getAcount(--this.blm.pageId);
            }
        } else if (id == -2) {
            this.blm.getAcount(++this.blm.pageId);
        } else if (id == -99) {
            this.blm.getAcount(0);
        }
    }

    protected void showMenu() {
        this.menu.clear();
        int i = 0;
        while (i < this.menuItems.length) {
            if (this.blm.account.size() != 0 && this.blm.type != 0 || i != 2) {
                MenuItem menuitem = new MenuItem(this.menuItems[i], i, this);
                this.menu.addItem(menuitem);
            }
            ++i;
        }
        this.openMenuList();
    }

    public void tick(long time) {
        if (this.blm.loadHead && !this.blm.loading && this.blm.account.size() > 0) {
            this.blm.loadNextHead();
        }
    }

    public void setText(String text, int id) {
        if (text != null && !"".equals(text)) {
            if (id == 1) {
                SMSManager.sendSMS("Hi\uff0c\u6211\u5f00\u901a\u4e86\u5fae\u535a\uff0c\u4f60\u53ef\u4ee5\u901a\u8fc7\u201c\u5173\u6ce8\u6211\u201d\u4e86\u89e3\u6211\u7684\u8fd1\u51b5\uff0c\u968f\u65f6\u4e0e\u6211\u4fdd\u6301\u8054\u7cfb\u3002\nhttp://t.sina.cn/" + this.cm.currentAccount.uid, text);
            } else if (id == 2) {
                this.blm.sendSixin(text, this.touid);
            }
        }
    }
}

