/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;

class FGSoundManager
implements Runnable {
    public static final boolean VERBOSE = false;
    public static final byte TYPE_WAV = 0;
    public static final byte TYPE_MIDI = 1;
    static AlertType AlertType0 = AlertType.INFO;
    static AlertType AlertType1 = AlertType.INFO;
    Vector m_sounds = new Vector();
    FGSoundData m_lastPlayedSound;
    Thread m_thread;
    public static final byte NEXT_ACTION_PLAY = 0;
    public static final byte NEXT_ACTION_STOP = 1;
    public static final byte NEXT_ACTION_TERMINATE = 3;
    private byte m_nextAction;
    private int m_nextActionID;
    public static final Object m_synch = new Object();
    private boolean m_bSoundOn = true;
    public String m_registerError;
    public String m_playError;
    private boolean m_bCreateNewPlayers;

    public void setNewPlayerCreation(boolean bl) {
        this.m_bCreateNewPlayers = bl;
    }

    public void init() {
        if (FGEngine.bInfAlertsOn) {
            switch (FGEngine.iInfAlertOne) {
                case 1: {
                    AlertType0 = AlertType.INFO;
                    break;
                }
                case 2: {
                    AlertType0 = AlertType.WARNING;
                    break;
                }
                case 3: {
                    AlertType0 = AlertType.ERROR;
                    break;
                }
                case 4: {
                    AlertType0 = AlertType.ALARM;
                    break;
                }
                case 5: {
                    AlertType0 = AlertType.CONFIRMATION;
                }
            }
            switch (FGEngine.iInfAlertTwo) {
                case 1: {
                    AlertType1 = AlertType.INFO;
                    break;
                }
                case 2: {
                    AlertType1 = AlertType.WARNING;
                    break;
                }
                case 3: {
                    AlertType1 = AlertType.ERROR;
                    break;
                }
                case 4: {
                    AlertType1 = AlertType.ALARM;
                    break;
                }
                case 5: {
                    AlertType1 = AlertType.CONFIRMATION;
                }
            }
        }
        if (!FGEngine.bInfAlertsOn || !FGEngine.bInfBeepsOn) {
            this.m_nextAction = (byte)-1;
            this.m_thread = new Thread(this);
            this.m_thread.start();
        }
        if (!FGEngine.bInfAlertsOn || !FGEngine.bInfBeepsOn) {
            this.m_bCreateNewPlayers = FGEngine.bInfSoundReload;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        this.doStop();
        Object object = m_synch;
        synchronized (object) {
            this.m_nextAction = (byte)3;
        }
    }

    public void unloadAllSounds() {
    }

    public void registerSound(String string, int n) {
        if (!FGEngine.bInfAlertsOn || !FGEngine.bInfBeepsOn) {
            byte by;
            FGString fGString = new FGString(string);
            FGEngine fGEngine = FGEngine.getEngine();
            FGFileSystem fGFileSystem = fGEngine.getFileSystem();
            FGData fGData = fGFileSystem.getFile(fGString.getNativeString());
            if (fGData == null) {
                return;
            }
            if (fGString.indexOf(new FGString(".wav")) != -1) {
                by = 0;
            } else if (fGString.indexOf(new FGString(".mid")) != -1) {
                by = 1;
            } else {
                this.registerSound(fGData, fGString.getNativeString(), n, (byte)-1);
                return;
            }
            this.registerSound(fGData, fGString.getNativeString(), n, by);
        }
    }

    public void registerSound(FGData fGData, String string, int n, byte by) {
        if (!FGEngine.bInfAlertsOn || !FGEngine.bInfBeepsOn) {
            FGSoundData fGSoundData = new FGSoundData();
            fGSoundData.m_type = by;
            fGSoundData.m_id = n;
            this.m_registerError = "np";
            try {
                String string2 = "audio/midi";
                if (fGSoundData.m_type == 0) {
                    string2 = "audio/x-wav";
                }
                if (this.m_bCreateNewPlayers) {
                    fGSoundData.m_player = null;
                    fGSoundData.m_soundData = null;
                    fGSoundData.m_filename = string;
                } else {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fGData.m_data);
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    fGSoundData.m_player = Manager.createPlayer((InputStream)dataInputStream, (String)string2);
                    fGSoundData.m_soundData = null;
                }
            }
            catch (Exception exception) {
                this.m_registerError = exception.toString();
                return;
            }
            this.m_sounds.addElement(fGSoundData);
        }
    }

    public void unregisterSound(int n) {
        if (!FGEngine.bInfAlertsOn || !FGEngine.bInfBeepsOn) {
            FGSoundData fGSoundData = this.getSound(n);
            if (fGSoundData == null) {
                return;
            }
            if (this.m_lastPlayedSound == fGSoundData) {
                this.stop();
                this.m_lastPlayedSound = null;
            }
            this.m_sounds.removeElement(fGSoundData);
        }
    }

    static void GenericAudioDoTone(int n, int n2, int n3) {
        if (n > FGEngine.iInfMaxPitch) {
            n = FGEngine.iInfMaxPitch;
        }
        if (n < FGEngine.iInfMinPitch) {
            n = FGEngine.iInfMinPitch;
        }
        if (n2 < FGEngine.iInfMinDuration) {
            n2 = FGEngine.iInfMinDuration;
        }
        if (n3 > FGEngine.iInfBeepVolume) {
            n3 = FGEngine.iInfBeepVolume;
        }
        try {
            Manager.playTone((int)n, (int)n2, (int)n3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(int n) {
        if (FGEngine.bInfAlertsOn) {
            if (n % 2 == 0) {
                AlertType0.playSound(Display.getDisplay((MIDlet)FGApp.g_app));
            } else {
                AlertType1.playSound(Display.getDisplay((MIDlet)FGApp.g_app));
            }
            return;
        }
        if (FGEngine.bInfBeepsOn) {
            if (n % 2 == 0) {
                FGSoundManager.GenericAudioDoTone(40, 200, 80);
            } else {
                FGSoundManager.GenericAudioDoTone(50, 120, 70);
            }
            return;
        }
        if (n == 1 && !FGEngine.bInfMusicOn) {
            return;
        }
        if (n >= 2 && n <= 12 && !FGEngine.bInfSFXOn) {
            return;
        }
        Object object = m_synch;
        synchronized (object) {
            this.m_nextAction = 0;
            this.m_nextActionID = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = m_synch;
        synchronized (object) {
            this.m_nextAction = 1;
        }
    }

    private FGSoundData getSound(int n) {
        if (!FGEngine.bInfAlertsOn || !FGEngine.bInfBeepsOn) {
            for (int i = 0; i < this.m_sounds.size(); ++i) {
                FGSoundData fGSoundData = (FGSoundData)this.m_sounds.elementAt(i);
                if (fGSoundData.m_id != n) continue;
                return fGSoundData;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            if (this.m_nextAction == -1) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
                continue;
            }
            Object object = m_synch;
            synchronized (object) {
                switch (this.m_nextAction) {
                    case 0: {
                        this.doPlay(this.m_nextActionID);
                        break;
                    }
                    case 1: {
                        this.doStop();
                        break;
                    }
                    case 3: {
                        return;
                    }
                }
                this.m_nextAction = (byte)-1;
                this.m_nextActionID = -1;
            }
        }
    }

    public void doPlay(int n) {
        this.m_playError = "np";
        try {
            Object object;
            this.doStop();
            if (!this.m_bSoundOn) {
                return;
            }
            FGSoundData fGSoundData = this.getSound(n);
            if (fGSoundData == null) {
                return;
            }
            this.m_lastPlayedSound = fGSoundData;
            if (fGSoundData == null) {
                return;
            }
            if (this.m_bCreateNewPlayers) {
                System.out.println("sound.m_filename" + fGSoundData.m_filename);
                object = "".getClass().getResourceAsStream("/" + fGSoundData.m_filename);
                fGSoundData.m_player = Manager.createPlayer((InputStream)fGSoundData.m_filename.getClass().getResourceAsStream("/" + fGSoundData.m_filename), (String)"audio/midi");
            }
            if (FGEngine.bInfSoundPrefetch) {
                fGSoundData.m_player.prefetch();
            }
            if (FGEngine.bInfSoundRealize) {
                fGSoundData.m_player.realize();
            }
            if (FGEngine.bInfSetVolume) {
                try {
                    object = (VolumeControl)fGSoundData.m_player.getControl("javax.microedition.media.control.VolumeControl");
                    if (object != null) {
                        object.setLevel(FGEngine.iInfMaxVolume);
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                }
            }
            fGSoundData.m_player.start();
        }
        catch (Exception exception) {
            this.m_playError = exception.toString();
        }
    }

    public void startOverLastSoundPlayed() {
        System.out.println("Startoverlastsoundplayed");
        try {
            if (this.m_lastPlayedSound != null) {
                this.m_lastPlayedSound.m_player.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doStop() {
        try {
            if (this.m_lastPlayedSound != null) {
                this.m_lastPlayedSound.m_player.stop();
                if (FGEngine.bInfSoundDeallocate) {
                    this.m_lastPlayedSound.m_player.deallocate();
                }
                this.m_lastPlayedSound.m_player.close();
                if (this.m_bCreateNewPlayers) {
                    this.m_lastPlayedSound.m_player = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSoundOn(boolean bl) {
        if (this.m_bSoundOn && !bl) {
            this.stop();
        }
        this.m_bSoundOn = bl;
    }

    public boolean getSoundOn() {
        return this.m_bSoundOn;
    }

    class FGSoundData {
        public Player m_player;
        public int m_id;
        public byte m_type;
        public String m_filename;
        FGData m_soundData;

        FGSoundData() {
        }
    }
}

