/*
 * Decompiled with CFR 0.152.
 */
class FGStdMenu {
    public static final int PIPING = 2;
    public static final int H_GUTTER = 4;
    public static final int ARROWS_V_GUTTER = 2;
    public FGMenuModel m_model = new FGMenuModel();
    FGFont m_font;
    FGFont m_titleFont;
    FGImage m_upArrowImage;
    FGImage m_downArrowImage;
    int m_backColor;
    int m_borderColor;
    int m_selectorColor;
    int m_x;
    int m_y;
    int m_menuWidth;
    int m_menuInternalWidth;
    int m_menuHeight;
    boolean m_bShowScrollArrows;
    public int m_scroll;
    int m_visibleItems;

    public void init(FGFont fGFont, FGFont fGFont2, FGImage fGImage, FGImage fGImage2, int n, int n2, int n3) {
        this.m_titleFont = fGFont;
        this.m_font = fGFont2;
        this.m_upArrowImage = fGImage;
        this.m_downArrowImage = fGImage2;
        this.m_backColor = n;
        this.m_borderColor = n2;
        this.m_selectorColor = n3;
        this.m_x = -1;
        this.m_y = -1;
        this.m_model.reset();
    }

    public FGMenuModel getModel() {
        return this.m_model;
    }

    public void handleKey(int n) {
        FGEngine fGEngine = FGEngine.getEngine();
        if (n == FGEngine.AVK_UP) {
            this.selectionUp();
        }
        if (n == FGEngine.AVK_DOWN) {
            this.selectionDown();
        }
    }

    public void selectionUp() {
        this.m_model.selectionUp();
        this.manageScroll();
    }

    public void selectionDown() {
        this.m_model.selectionDown();
        this.manageScroll();
    }

    public void manageScroll() {
        int n = this.m_model.getSelectionIndex();
        if (this.m_scroll > n) {
            this.m_scroll = n;
        } else if (this.m_scroll + this.m_visibleItems <= n) {
            this.m_scroll = n - this.m_visibleItems + 1;
        }
        if (this.m_scroll < 0) {
            this.m_scroll = 0;
        } else if (this.m_scroll > this.m_model.getNumItems() - this.m_visibleItems) {
            this.m_scroll = this.m_model.getNumItems() - this.m_visibleItems;
        }
    }

    public void modelChanged() {
        this.m_scroll = 0;
        FGEngine.getEngine();
        int n = FGEngine.getScreenWidth();
        FGEngine.getEngine();
        int n2 = FGEngine.getScreenHeight();
        int n3 = this.getTitleAreaHeight();
        int n4 = this.getElementHeight();
        int n5 = this.getArrowAreaHeight();
        int n6 = 4;
        if (n3 > 0) {
            n6 += 2;
        }
        int n7 = n2 - n3 - n6 - n4 * 2;
        System.out.println("" + n7 + " " + n4);
        int n8 = n7 / n4;
        System.out.println("" + n8);
        System.out.println("" + this.m_model.getNumItems());
        if (n8 >= this.m_model.getNumItems()) {
            this.m_bShowScrollArrows = false;
            this.m_visibleItems = this.m_model.getNumItems();
        } else {
            this.m_bShowScrollArrows = true;
            this.m_visibleItems = (n7 -= n5) / n4;
        }
        if (n5 == 0) {
            this.m_bShowScrollArrows = false;
        }
        this.m_menuHeight = n3 + n4 * this.m_visibleItems + n6;
        if (this.m_bShowScrollArrows) {
            this.m_menuHeight += n5;
        }
        this.m_menuInternalWidth = this.getInternalWidth();
        this.m_menuWidth = this.m_menuInternalWidth + 4;
    }

    public void drawSelf(FGGraphics fGGraphics) {
        int n;
        int n2;
        int n3;
        int n4;
        FGEngine.getEngine();
        int n5 = FGEngine.getScreenWidth();
        FGEngine.getEngine();
        int n6 = FGEngine.getScreenHeight();
        if (this.m_x == -1 && this.m_y == -1) {
            n4 = (n5 - this.m_menuWidth) / 2;
            n3 = (n6 - this.m_menuHeight) / 2;
        } else {
            n4 = this.m_x;
            n3 = this.m_y;
        }
        int n7 = n4 + 2;
        if (this.m_borderColor != 0xFF00FF) {
            fGGraphics.setColor(this.m_borderColor);
            fGGraphics.fillRect(n4, n3, this.m_menuWidth, this.m_menuHeight);
        }
        if (this.m_backColor != 0xFF00FF) {
            fGGraphics.setColor(this.m_backColor);
            fGGraphics.fillRect(n4 + 2, n3 + 2, this.m_menuWidth - 4, this.m_menuHeight - 4);
        }
        int n8 = n3 + 2;
        FGString fGString = this.m_model.getTitle();
        if (fGString.length() > 0) {
            this.m_titleFont.setJustify(2);
            this.m_titleFont.drawText(fGGraphics, fGString.getNativeString(), n7, n8 += this.m_titleFont.getLineSpacing(), this.m_menuInternalWidth);
            this.m_titleFont.setJustify(0);
            n8 += this.m_titleFont.getHeight();
            n8 += this.m_titleFont.getLineSpacing();
            if (this.m_borderColor != 0xFF00FF) {
                fGGraphics.setColor(this.m_borderColor);
                fGGraphics.fillRect(n4, n8, this.m_menuWidth, 2);
            }
            n8 += 2;
        }
        for (n2 = 0; n2 < this.m_visibleItems; ++n2) {
            n = this.m_scroll + n2;
            this.drawElement(fGGraphics, n, n8);
            n8 += this.getElementHeight() - 3;
        }
        if (this.m_bShowScrollArrows) {
            int n9;
            n2 = this.getArrowAreaHeight();
            if (this.m_scroll > 0) {
                n = n5 / 2 - 2 - this.m_upArrowImage.getWidth();
                n9 = n8 + (n2 - this.m_upArrowImage.getHeight()) / 2;
                this.m_upArrowImage.drawSelf(fGGraphics, n, n9);
                if (CVEngine.bWait) {
                    if (FGEngine.touchX == -100) {
                        CVEngine.bWait = false;
                    } else {
                        return;
                    }
                }
                if (FGEngine.touchX > n && FGEngine.touchX <= n + this.m_upArrowImage.getWidth() && FGEngine.touchY > n9 && FGEngine.touchY <= n9 + this.m_upArrowImage.getHeight()) {
                    FGEngine.getEngine().onKeyPressed(FGEngine.AVK_DOWN);
                    CVEngine.bWait = true;
                }
            }
            if (this.m_scroll + this.m_visibleItems < this.m_model.getNumItems()) {
                n = n5 / 2 + 2;
                n9 = n8 + (n2 - this.m_downArrowImage.getHeight()) / 2;
                this.m_downArrowImage.drawSelf(fGGraphics, n, n9);
                if (CVEngine.bWait) {
                    if (FGEngine.touchX == -100) {
                        CVEngine.bWait = false;
                    } else {
                        return;
                    }
                }
                if (FGEngine.touchX > n && FGEngine.touchX <= n + this.m_downArrowImage.getWidth() && FGEngine.touchY > n9 && FGEngine.touchY <= n9 + this.m_downArrowImage.getHeight()) {
                    FGEngine.getEngine().onKeyPressed(FGEngine.AVK_DOWN);
                    CVEngine.bWait = true;
                }
            }
            n8 += n2;
        }
    }

    public void drawElement(FGGraphics fGGraphics, int n, int n2) {
        FGEngine.getEngine();
        int n3 = FGEngine.getScreenWidth();
        int n4 = this.m_x == -1 && this.m_y == -1 ? (n3 - this.m_menuWidth) / 2 : this.m_x;
        int n5 = n4 + 2;
        if (n == this.m_model.getSelectionIndex() && this.m_selectorColor != 0xFF00FF) {
            fGGraphics.setColor(this.m_selectorColor);
            fGGraphics.fillRect(n5, n2, this.m_menuInternalWidth, this.getElementHeight());
        }
        FGString fGString = this.m_model.m_strings[n];
        this.m_font.setJustify(2);
        this.m_font.drawText(fGGraphics, fGString.getNativeString(), n4 + this.m_menuWidth / 2, n2 += this.m_font.getLineSpacing());
        this.m_font.setJustify(0);
    }

    public int getTitleAreaHeight() {
        FGString fGString = this.m_model.getTitle();
        if (fGString.length() == 0) {
            return 0;
        }
        FGEngine.getEngine();
        int n = FGEngine.getScreenWidth() - 4 - 8;
        int n2 = this.m_titleFont.getDisplayLength(this.m_model.getTitle().getNativeString(), n);
        int n3 = this.m_titleFont.getDisplayHeight(this.m_model.getTitle().getNativeString(), n);
        return n3 += this.m_titleFont.getLineSpacing() * 2;
    }

    public int getCurrentMode() {
        return -1;
    }

    public int getElementHeight() {
        return this.m_font.getHeight() + this.m_font.getLineSpacing() * 2;
    }

    public int getArrowAreaHeight() {
        int n;
        if (this.m_upArrowImage == null || this.m_downArrowImage == null) {
            return 0;
        }
        int n2 = this.m_upArrowImage.getHeight();
        if (n2 < (n = this.m_downArrowImage.getHeight())) {
            n2 = n;
        }
        return n2 += 4;
    }

    public int getInternalWidth() {
        int n;
        FGEngine.getEngine();
        int n2 = FGEngine.getScreenWidth() - 4 - 8;
        int n3 = this.m_titleFont.getDisplayLength(this.m_model.getTitle().getNativeString(), n2);
        int n4 = 0;
        for (n = 0; n < this.m_model.getNumItems(); ++n) {
            int n5 = this.m_font.getDisplayLength(this.m_model.m_strings[n].getNativeString());
            if (n5 <= n4) continue;
            n4 = n5;
        }
        n = n3;
        if (n < n4) {
            n = n4;
        }
        if ((n += 8) > n2) {
            return n2;
        }
        return n;
    }

    public int getWidth() {
        return this.m_menuWidth;
    }

    public int getHeight() {
        return this.m_menuHeight;
    }

    public void setPos(int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
    }
}

