/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.push;

import com.funambol.push.CTPListener;
import com.funambol.push.MessageParserException;
import com.funambol.push.PushConfig;
import com.funambol.push.PushNotificationListener;
import com.funambol.push.SANMessage;
import com.funambol.push.SANMessageParser;
import com.funambol.util.Base64;
import com.funambol.util.ConnectionManager;
import com.funambol.util.Log;
import com.funambol.util.MD5;
import com.funambol.util.ThreadPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.io.SocketConnection;

public class CTPService
extends Thread {
    private static final int PROTOCOL_VERSION = 16;
    protected static final int CM_AUTH = 1;
    protected static final int CM_READY = 2;
    protected static final int CM_BYE = 3;
    protected static final int ST_OK = 32;
    protected static final int ST_JUMP = 55;
    protected static final int ST_ERROR = 80;
    protected static final int ST_NOT_AUTHENTICATED = 65;
    protected static final int ST_UNAUTHORIZED = 66;
    protected static final int ST_FORBIDDEN = 67;
    protected static final int ST_SYNC = 41;
    protected static final int ST_RETRY = 83;
    private static final int P_DEVID = 1;
    private static final int P_USERNAME = 2;
    private static final int P_CRED = 3;
    private static final int P_FROM = 4;
    private static final int P_TO = 5;
    private static final int P_NONCE = 6;
    private static final int P_SAN = 7;
    private static final int P_SLEEP = 9;
    private static final int MAX_MESSAGE_SIZE = 4096;
    protected static final int DISCONNECTED = 0;
    protected static final int CONNECTING = 1;
    protected static final int CONNECTED = 2;
    protected static final int AUTHENTICATING = 3;
    protected static final int AUTHENTICATED = 4;
    protected static final int LISTENING = 5;
    private static CTPService instance = null;
    private boolean instanceRunning = false;
    private boolean done = false;
    private ThreadPool threadPool = null;
    private SocketConnection sc = null;
    private OutputStream os = null;
    private InputStream is = null;
    private PushNotificationListener pushListener = null;
    private boolean okReceived = false;
    private PushConfig config = null;
    protected int state = 0;
    private Timer timer = new Timer();
    private HeartbeatGenerator heartbeatGenerator = null;
    private CTPListener ctpListener;
    private Object lock = new Object();
    private boolean offlineMode = false;

    public void setCTPListener(CTPListener ctpListener) {
        this.ctpListener = ctpListener;
    }

    public void startService() {
        if (this.config != null) {
            this.startService(this.config);
        }
    }

    public void setOfflineMode(boolean mode) {
        this.offlineMode = mode;
        if (mode && CTPService.getInstance().isRunning()) {
            CTPService.getInstance().stopService();
        }
    }

    public boolean isOfflineMode() {
        return this.offlineMode;
    }

    private void sendBlindReadyMessage() throws IOException {
        Log.info("[CTPService.sendBlindReadyMessage]Sending blind ready message to avoid server timeout");
        CTPMessage readyMsg = new CTPMessage();
        readyMsg.setCommand(2);
        this.sendMessage(readyMsg);
        Log.info("[CTPService.sendBlindReadyMessage]Blind ready message sent");
    }

    protected CTPService() {
    }

    public static CTPService getInstance() {
        if (instance == null) {
            instance = new CTPService();
        }
        return instance;
    }

    public synchronized void restartService(PushConfig config) {
        Log.debug("[CTPService.restartService] restarting service");
        try {
            if (CTPService.getInstance().isRunning()) {
                this.stopService();
                Thread.sleep(5000L);
            }
            this.startService(config);
        }
        catch (InterruptedException ex) {
            Log.info("[CTPService.restartservice]Exception thrown while restarting CTP service: " + ex);
            ex.printStackTrace();
        }
        catch (Exception e) {
            Log.error("[CTPService.restartservice]Exception thrown while restarting CTP service: " + e);
            e.printStackTrace();
        }
    }

    public void restartService() {
        if (this.config != null) {
            this.restartService(this.config);
        } else {
            Log.debug("[CTPService.restartService] Cannot restart service: current config is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startService(PushConfig config) {
        Object object = this.lock;
        synchronized (object) {
            Log.debug("[CTPService.startService]CTPstart service called");
            this.config = config;
            if (!this.instanceRunning) {
                this.instanceRunning = true;
                this.timer = new Timer();
                this.done = false;
                if (this.threadPool != null) {
                    Log.debug("[CTPService.startService] Starting CTPService in a thread pool");
                    this.threadPool.startThread(this);
                } else {
                    Log.debug("[CTPService.startService] Starting CTPService WITHOUTH thread pool");
                    this.start();
                }
            } else {
                Log.debug("[CTPService.startService] CTPService already running");
            }
        }
    }

    public boolean isRunning() {
        return this.instanceRunning;
    }

    public void setConfig(PushConfig config) {
        this.config = config;
    }

    public boolean isPushActive() {
        return this.state == 5;
    }

    public void setPushNotificationListener(PushNotificationListener pushListener) {
        this.pushListener = pushListener;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() {
        Object object = this.lock;
        synchronized (object) {
            Log.debug("[CTPService.stopService] asked to stop");
            this.done = true;
            try {
                if (this.state >= 4) {
                    CTPMessage byeMessage = new CTPMessage();
                    byeMessage.setCommand(3);
                    this.sendMessage(byeMessage);
                }
            }
            catch (IOException e) {
                Log.error("[CTPService.stopService] Send of BYE command failed");
            }
            finally {
                this.timer.cancel();
                this.disconnect();
                this.instanceRunning = false;
            }
        }
    }

    public void run() {
        Log.debug("[CTPService.run] Starting CTPService thread");
        this.state = 0;
        int ctpRetry = this.config.getCtpRetry();
        int connectionTentatives = 0;
        this.done = false;
        boolean first = true;
        while (!this.done) {
            try {
                if (this.state != 2) {
                    Log.debug("[CTPService.run] Attempting Connection # " + connectionTentatives);
                    this.connect(connectionTentatives++);
                }
                if (this.state == 2) {
                    Log.debug("[CTPService.run]Connection Successful. Authenticating...");
                    int authStatus = this.authenticate();
                    if (authStatus == 66 || authStatus == 67) {
                        Log.debug("[CTPService.run]Authentication failed");
                        this.done = true;
                    } else if (authStatus == 32) {
                        Log.debug("[CTPService.run]Authentication Successful");
                        ctpRetry = this.config.getCtpRetry();
                        Log.debug("[CTPService.run]Starting the heartbeat generator");
                        if (this.heartbeatGenerator == null) {
                            this.heartbeatGenerator = new HeartbeatGenerator();
                        }
                        if (!this.heartbeatGenerator.isRunning()) {
                            if (this.threadPool != null) {
                                Log.debug("[CTPService.run] running heartbeat generator in a pool thread");
                                this.threadPool.startThread(this.heartbeatGenerator);
                            } else {
                                Log.debug("[CTPService.run] running heartbeat generator in a thread");
                                this.heartbeatGenerator.start();
                            }
                        } else {
                            Log.debug("[CTPService.run] heartbeat generator is altrady running, no need to start it again");
                        }
                        this.listenCTPMessages();
                    }
                }
            }
            catch (Throwable e) {
                if (!this.done) {
                    Log.error("[CTPService.run] Exception reading stream: " + e.toString());
                    e.printStackTrace();
                } else {
                    Log.debug("[CTPServicerun] Forced Disconnection , disconnecting");
                }
                this.disconnect();
            }
            try {
                if (!this.done && !first) {
                    this.disconnect();
                    Log.debug("[CTPService.run] Suspending for " + ctpRetry + " seconds");
                    this.sleepSecs(ctpRetry);
                    if (ctpRetry * 2 < this.config.getCtpMaxRetry()) {
                        ctpRetry *= 2;
                    }
                }
                if (first) {
                    first = false;
                    this.disconnect();
                }
            }
            catch (Throwable e) {
                Log.debug("[CTPService.run] throwable catched: disconnecting!");
                this.disconnect();
            }
            if (this.isOfflineMode()) {
                Log.info("[CTPService.run] application is offline, stopping service");
                this.stopService();
                continue;
            }
            if (this.done) continue;
            Log.info("[CTPService.run] application is not offline, keep on ctp'ing!");
        }
        Log.info("[CTPService.run]  Finishing CTPService thread");
    }

    public int getState() {
        return this.state;
    }

    public String getCTPStringState() {
        switch (this.state) {
            case 0: {
                return "Disconnected";
            }
            case 1: {
                return "Connecting...";
            }
            case 2: {
                return "Connected";
            }
            case 3: {
                return "Authenticating...";
            }
            case 4: {
                return "Authenticated";
            }
            case 5: {
                return "SAN Listening...";
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection() {
        if (this.os != null) {
            Log.debug("[CTPService.closeConnection]Closing output stream");
            try {
                this.os.close();
            }
            catch (IOException ioe) {
            }
            finally {
                this.os = null;
            }
        }
        if (this.is != null) {
            Log.debug("[CTPService.closeConnection]Closing input stream");
            try {
                this.is.close();
            }
            catch (IOException ioe) {
            }
            finally {
                this.is = null;
            }
        }
        Log.debug("[CTPService.closeConnection]Checking if we need to close socket...");
        if (this.sc != null) {
            Log.debug("[CTPService.closeConnection]Closing socket connection");
            try {
                this.sc.close();
            }
            catch (IOException e) {
                Log.error("[CTPService.closeConnection]Cannot force socket closure");
            }
            finally {
                this.sc = null;
            }
        } else {
            Log.debug("[CTPService.closeConnection]No need to close socket...");
        }
        this.ctpListener.CTPDisconnected();
    }

    private void sleepSecs(int secs) {
        try {
            Thread.sleep(secs * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Log.debug("[CTPService.closeConnection]Exiting from sleep");
    }

    protected void connect(int retry) throws IOException {
        String uri = "socket://" + this.config.getCtpServer() + ":" + this.config.getCtpPort();
        Log.debug("[CTPService.connect]Connecting to " + uri);
        this.state = 1;
        this.ctpListener.CTPConnecting();
        try {
            Log.debug("[CTPService.connect]Opening socket");
            this.sc = (SocketConnection)ConnectionManager.getInstance().open(uri);
            Log.debug("[CTPService.connect]Setting socket options");
            this.sc.setSocketOption((byte)1, 5);
            Log.debug("[CTPService.connect]Opening socket output stream");
            this.os = this.sc.openOutputStream();
            Log.debug("[CTPService.connect]Opening socket input stream");
            this.is = this.sc.openInputStream();
            Log.debug("[CTPService.connect]Opening socket input stream");
            this.state = 2;
            this.ctpListener.CTPConnected();
            Log.debug("[CTPService.connect]Connection Successful");
        }
        catch (IOException ioe) {
            Log.error("CTPService] Cannot open CTP connection to: " + uri);
            this.state = 0;
            this.ctpListener.CTPDisconnected();
            throw ioe;
        }
    }

    protected void disconnect() {
        if (this.state != 0) {
            Log.debug("[CTPService.listenCTPMessages]Putting CTP in in DISCONNECTED state...");
            this.state = 0;
            this.okReceived = true;
            this.closeConnection();
        } else {
            Log.debug("CTP is already in DISCONNECTED state, I've nothing to do!");
        }
    }

    public void forceDisconnect() {
        this.disconnect();
    }

    public PushConfig getConfig() {
        return this.config;
    }

    private String byteArrayToString(byte[] array) {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            String hexString = Integer.toHexString(array[i] & 0xFF);
            res.append(hexString + " ");
        }
        return res.toString();
    }

    private CTPMessage createAuthMessage() {
        CTPMessage authMessage = new CTPMessage();
        authMessage.setCommand(1);
        String username = this.config.getCtpUsername();
        String password = this.config.getCtpPassword();
        byte[] nonce = this.config.getCtpNonce();
        Log.debug("[CTPService.createAuthMessage] create credentials for " + username);
        Log.debug("[CTPService.createAuthMessage] nonce is " + new String(Base64.encode(nonce)) + " ---- " + this.byteArrayToString(nonce));
        authMessage.addParameter(1, this.config.getDeviceId().getBytes());
        authMessage.addParameter(2, username.getBytes());
        MD5 md5 = new MD5();
        byte[] credentials = md5.computeMD5Credentials(username, password, nonce);
        Log.debug("[CTPService.createAuthMessage] credentials " + new String(Base64.encode(credentials)) + " ---- " + this.byteArrayToString(credentials));
        authMessage.addParameter(3, credentials);
        return authMessage;
    }

    protected int authenticate() throws IOException {
        Log.debug("[CTPService.authenticate] Start CTP authentication");
        this.state = 3;
        this.ctpListener.CTPAuthenticating();
        CTPMessage authMessage = this.createAuthMessage();
        Log.debug("[CTPService.authenticate] Sending CTP authentication message");
        this.sendMessage(authMessage);
        Log.debug("[CTPService.authenticate] Waiting CTP response");
        CTPMessage response = this.receiveMessageWithTimeout();
        int authStatus = response.getCommand();
        switch (authStatus) {
            case 65: {
                Log.debug("[CTPService.authenticate] Client not authenticated: retry with new nonce");
                this.config.setCtpNonce(response.getNonce());
                Log.debug("[CTPService.authenticate] Re-Sending CTP authentication message");
                authMessage = this.createAuthMessage();
                this.sendMessage(authMessage);
                Log.debug("[CTPService.authenticate] Waiting CTP response");
                response = this.receiveMessageWithTimeout();
                authStatus = response.getCommand();
                if (authStatus == 32) {
                    Log.info("[CTPService.authenticate] client authenticated successfully!");
                    this.config.setCtpNonce(response.getNonce());
                    this.state = 4;
                    this.ctpListener.CTPAuthenticated();
                    this.sendBlindReadyMessage();
                    break;
                }
                Log.info("[CTPService.authenticate] CTP error: Client not authenticated. Please check your credentials.");
                break;
            }
            case 32: {
                Log.info("[CTPService.authenticate]client authenticated successfully!");
                this.config.setCtpNonce(response.getNonce());
                this.state = 4;
                this.sendBlindReadyMessage();
                this.ctpListener.CTPAuthenticated();
                break;
            }
            case 55: {
                Log.error("[CTPService.authenticate] Server requested a JUMP. Not supported yet.");
                break;
            }
            case 66: {
                Log.info("[CTPService.authenticate] Unauthorized by the Server, please check your credentials.");
                this.config.setCtpNonce(response.getNonce());
                break;
            }
            case 67: {
                Log.error("[CTPService.authenticate]Authentication forbidden by the Server, please check your credentials.");
                break;
            }
            case 80: {
                Log.info("[CTPService.authenticate] Received ERROR status from Server: restore ctp connection");
                break;
            }
            default: {
                Log.error("[CTPService.authenticate] Unexpected status received " + authStatus);
            }
        }
        return authStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(CTPMessage message) throws IOException {
        byte[] msgBytes = message.getBytes();
        Log.debug("[CTPService.sendMessage]Sending message " + this.byteArrayToString(msgBytes));
        if (this.os == null) {
            throw new IOException("Output stream is null, cannot write");
        }
        OutputStream outputStream = this.os;
        synchronized (outputStream) {
            ConnectionTimer connTimer = new ConnectionTimer();
            Log.debug("[CTPService.sendMessage]sendMessage: Programming alarm in " + connTimer.getDelay() + " msec");
            this.timer.schedule((TimerTask)connTimer, connTimer.getDelay());
            try {
                this.os.write(msgBytes);
                this.os.flush();
                connTimer.endOperation();
            }
            catch (Exception e) {
                connTimer.endOperation();
                throw new IOException("[CTPService.sendMessage]Cannot write output stream: " + e);
            }
        }
    }

    protected CTPMessage receiveMessageWithTimeout() throws IOException {
        ConnectionTimer connTimer = new ConnectionTimer();
        Log.debug("[CTPService.sendMessage]ReceivemessageWithTimeout: Programming alarm in " + connTimer.getDelay() + " msec");
        this.timer.schedule((TimerTask)connTimer, connTimer.getDelay());
        try {
            CTPMessage res = this.receiveMessage();
            connTimer.endOperation();
            return res;
        }
        catch (IOException e) {
            connTimer.endOperation();
            throw e;
        }
    }

    protected CTPMessage receiveMessage() throws IOException {
        byte[] sizeBytes = new byte[2];
        int bytesRead = this.is.read(sizeBytes, 0, 2);
        if (bytesRead != 2) {
            Log.debug("[CTPService.receiveMessage]Read " + bytesRead + " bytes");
            throw new IOException("Cannot read message size");
        }
        int size = sizeBytes[0] * 10 + sizeBytes[1];
        Log.debug("[CTPService.receiveMessage]read size is " + size);
        if (size + 2 > 4096) {
            throw new IOException("Message length exceeds MAX_MESSAGE_SIZE");
        }
        byte[] rawMessage = new byte[2 + size];
        bytesRead = this.is.read(rawMessage, 2, size);
        if (bytesRead != size) {
            throw new IOException("Cannot read message content");
        }
        rawMessage[0] = sizeBytes[0];
        rawMessage[1] = sizeBytes[1];
        CTPMessage message = new CTPMessage(rawMessage);
        Log.debug("[CTPService.receiveMessage]Received message " + this.byteArrayToString(rawMessage));
        return message;
    }

    private void listenCTPMessages() throws IOException {
        this.state = 5;
        this.ctpListener.CTPListening();
        Log.debug("[CTPService.listenCTPMessages]SAN Listening mode");
        SANMessageParser smp = new SANMessageParser();
        block9: while (!this.done) {
            CTPMessage message = null;
            try {
                Log.debug("[CTPService.listenCTPMessages]Reading message on input stream");
                message = this.receiveMessage();
                Log.debug("[CTPService.listenCTPMessages]Message received");
            }
            catch (IOException ioe) {
                Log.error("[CTPService.listenCTPMessages]Exception while reading server message:" + ioe);
                throw ioe;
            }
            int status = message.getCommand();
            switch (status) {
                case 32: {
                    this.okReceived = true;
                    Log.debug("[CTPService.listenCTPMessages]OK received");
                    continue block9;
                }
                case 41: {
                    Log.debug("[CTPService.listenCTPMessages]Notification received.");
                    if (this.pushListener != null) {
                        byte[] sanBytes = message.getParameterValue(0);
                        try {
                            SANMessage sanMessage = smp.parseMessage(sanBytes, false);
                            Log.debug("[CTPService.listenCTPMessages]Handle SAN message");
                            this.pushListener.handleMessage(sanMessage);
                        }
                        catch (MessageParserException mpe) {
                            Log.error("[CTPService.listenCTPMessages]Error parsing SAN message");
                            Log.error("[CTPService.listenCTPMessages]Sync cannot start");
                        }
                    }
                    Log.debug("[CTPService.listenCTPMessages]Sync started");
                    continue block9;
                }
                case 80: {
                    Log.error("[CTPService.listenCTPMessages]ERROR message received");
                    this.disconnect();
                    return;
                }
            }
            Log.error("[CTPService.listenCTPMessages]Bad status received " + status);
            this.disconnect();
            return;
        }
    }

    protected class CTPMessage {
        private Vector paramsValue = new Vector();
        private Vector paramsCode = new Vector();
        private int protocolVersion = 16;
        private int length = -1;
        private int commandCode = -1;
        private byte[] nonce = null;

        public CTPMessage() {
        }

        public CTPMessage(byte[] rawMessage) {
            this.parsePacket(rawMessage);
        }

        public void setCommand(int commandCode) {
            this.commandCode = commandCode;
        }

        public int getCommand() {
            return this.commandCode;
        }

        public void addParameter(int code, byte[] value) {
            this.paramsCode.addElement(new Integer(code));
            this.paramsValue.addElement(value);
        }

        public int getParametersNumber() {
            return this.paramsCode.size();
        }

        public int getParameterCode(int idx) {
            Integer code = (Integer)this.paramsCode.elementAt(idx);
            return code;
        }

        public byte[] getParameterValue(int idx) {
            byte[] value = (byte[])this.paramsValue.elementAt(idx);
            return value;
        }

        public byte[] getBytes() {
            int msgLength = 4;
            int numParams = this.paramsValue.size();
            for (int i = 0; i < numParams; ++i) {
                byte[] param = (byte[])this.paramsValue.elementAt(i);
                msgLength += 2 + param.length;
            }
            int idx = 0;
            byte[] bytes = new byte[msgLength];
            bytes[idx++] = (byte)(msgLength - 2 >> 8);
            bytes[idx++] = (byte)(msgLength - 2 & 0xFF);
            bytes[idx++] = 16;
            bytes[idx++] = (byte)this.commandCode;
            for (int i = 0; i < numParams; ++i) {
                Integer codeInt = (Integer)this.paramsCode.elementAt(i);
                byte code = codeInt.byteValue();
                byte[] param = (byte[])this.paramsValue.elementAt(i);
                byte length = (byte)param.length;
                bytes[idx++] = code;
                bytes[idx++] = length;
                System.arraycopy(param, 0, bytes, idx, param.length);
                idx += param.length;
            }
            return bytes;
        }

        public byte[] getNonce() {
            return this.nonce;
        }

        private void parsePacket(byte[] rawMessage) {
            this.length = rawMessage[0] * 10 + rawMessage[1];
            this.parseMessage(rawMessage, 2);
        }

        private int parseMessage(byte[] rawMessage, int offset) {
            this.protocolVersion = rawMessage[offset];
            offset = this.parseCommand(rawMessage, offset + 1);
            return offset;
        }

        private int parseCommand(byte[] rawMessage, int offset) {
            this.commandCode = rawMessage[offset];
            offset = this.parseParam(rawMessage, offset + 1);
            return offset;
        }

        private int parseParam(byte[] rawMessage, int offset) {
            if (offset >= rawMessage.length) {
                return offset;
            }
            byte code = rawMessage[offset];
            byte len = rawMessage[offset + 1];
            this.paramsCode.addElement(new Integer(code));
            byte[] value = new byte[len];
            System.arraycopy(rawMessage, offset + 2, value, 0, len);
            this.paramsValue.addElement(value);
            if (code == 6) {
                this.nonce = value;
            }
            offset = this.parseParam(rawMessage, offset + 2 + len);
            return offset;
        }
    }

    protected class HeartbeatGenerator
    extends Thread {
        private boolean isRunning = false;

        protected HeartbeatGenerator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Log.debug("[CTPService - HeartBeatGenerator] starting heartbeat generator");
            this.isRunning = true;
            int sleepTime = CTPService.this.config.getCtpReady();
            CTPMessage readyMsg = new CTPMessage();
            readyMsg.setCommand(2);
            try {
                while (!CTPService.this.done) {
                    CTPService.this.okReceived = false;
                    if (CTPService.this.state == 5) {
                        Log.debug("[CTPService - HeartBeatGenerator] sending ready msg");
                        CTPService.this.sendMessage(readyMsg);
                        Log.debug("[CTPService - HeartBeatGenerator] next ready msg will be sent in " + sleepTime + " seconds...");
                        CTPService.this.sleepSecs(sleepTime);
                        if (CTPService.this.okReceived) continue;
                        throw new IOException("OK not received");
                    }
                    Log.info("[CTPService - HeartBeatGenerator] sleeping 10 sec while  CTP restarts");
                    CTPService.this.sleepSecs(10);
                }
            }
            catch (IOException ioe) {
                Log.error("[CTPService - HeartBeatGenerator] error sending the heartbeat");
                CTPService.this.disconnect();
            }
            finally {
                Log.debug("[CTPService - HeartBeatGenerator] exiting heartbeat generator");
                this.isRunning = false;
            }
        }

        public boolean isRunning() {
            return this.isRunning;
        }
    }

    protected class ConnectionTimer
    extends TimerTask {
        private int delay = -1;
        private boolean terminated = false;

        public ConnectionTimer() {
            this.delay = CTPService.this.config.getCtpCmdTimeout() * 1000;
        }

        public void endOperation() {
            this.terminated = true;
        }

        public int getDelay() {
            return this.delay;
        }

        public void run() {
            if (!this.terminated) {
                Log.error("[CTPService - ConnectionTimer] An IO operation did not complete before maximum allowed time. Restart the CTPService");
                CTPService.this.disconnect();
            }
        }
    }
}

