/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.push;

import com.funambol.push.MessageParserException;
import com.funambol.push.SANMessage;
import com.funambol.push.SyncInfo;
import com.funambol.util.Log;

public class SANMessageParser {
    private String digest = null;
    private String version = null;
    private char uiMode = '\u0000';
    private char initiator = '\u0000';
    private int sessionId = 0;
    private String serverId = null;
    private int numberOfSync = 0;
    private SyncInfo[] syncInfo = null;
    private static final int DIGEST_SIZE = 128;
    private static final int VERSION_SIZE = 10;
    private static final int UI_MODE_SIZE = 2;
    private static final int INTITIATOR_SIZE = 1;
    private static final int FUTURE_USE1_SIZE = 27;
    private static final int SESSION_ID_SIZE = 16;
    private static final int SERVER_IDENTIFIER_SIZE = 8;
    private static final int NUM_SYNCS_SIZE = 4;
    private static final int FUTURE_USE2_SIZE = 4;
    private static final int SYNC_TYPE_SIZE = 4;
    private static final int FUTURE_USE3_SIZE = 4;
    private static final int CONTENT_TYPE_SIZE = 24;
    private static final int SERVER_URI_SIZE = 8;
    private final int ERR_NOT_AUTHENTICATION;
    private final int ERR_NOT_PARSER;
    private SANMessage message;

    public SANMessageParser() {
        this.ERR_NOT_AUTHENTICATION = 1;
        this.ERR_NOT_PARSER = 2;
        Log.info(this, "SANMessageParser for SAN Message");
        this.message = new SANMessage();
    }

    public SANMessage parseMessage(byte[] msg, boolean skipDigest) throws MessageParserException {
        byte[] msgToBeParsed;
        int byteToBeParsed;
        if (skipDigest) {
            byteToBeParsed = msg.length - 6;
            msgToBeParsed = new byte[byteToBeParsed];
            System.arraycopy(msg, 6, msgToBeParsed, 0, byteToBeParsed);
        } else {
            byteToBeParsed = msg.length;
            msgToBeParsed = new byte[byteToBeParsed];
            System.arraycopy(msg, 0, msgToBeParsed, 0, byteToBeParsed);
        }
        try {
            String binaryMessage = "";
            StringBuffer sb = new StringBuffer();
            String temp = "";
            for (int i = 0; i < msgToBeParsed.length; ++i) {
                byte c = msgToBeParsed[i];
                temp = Integer.toString((c & 0xFF) + 256, 2).substring(1);
                sb.append(temp);
            }
            binaryMessage = sb.toString();
            int arrayPointer = 0;
            this.digest = binaryMessage.substring(arrayPointer, arrayPointer + 128);
            this.message.setDigest(this.digest);
            this.version = binaryMessage.substring(arrayPointer += 128, arrayPointer + 10);
            int ver = Integer.parseInt(this.version, 2);
            this.version = Integer.toString(ver);
            String first = this.version.substring(0, 1);
            String second = this.version.substring(1);
            this.version = first + "." + second;
            this.message.setVersion(this.version);
            String uimode = binaryMessage.substring(arrayPointer += 10, arrayPointer + 2);
            int ui_mode = Integer.parseInt(uimode, 2);
            this.uiMode = Integer.toString(ui_mode).charAt(0);
            this.message.setUiMode(this.uiMode);
            String initiator_s = binaryMessage.substring(arrayPointer += 2, arrayPointer + 1);
            int initiator_i = Integer.parseInt(initiator_s, 2);
            this.initiator = Integer.toString(initiator_i).charAt(0);
            this.message.setInitiator(this.initiator);
            ++arrayPointer;
            String ses_id = binaryMessage.substring(arrayPointer += 27, arrayPointer + 16);
            this.sessionId = Integer.parseInt(ses_id, 2);
            this.message.setSessionId(this.sessionId);
            String servidlen = binaryMessage.substring(arrayPointer += 16, arrayPointer + 8);
            int serverid_len = Integer.parseInt(servidlen, 2);
            arrayPointer += 8;
            for (int k = 0; k < serverid_len; ++k) {
                temp = binaryMessage.substring(arrayPointer, arrayPointer + 8);
                int oneByte = Integer.parseInt(temp, 2);
                this.serverId = this.serverId + (char)oneByte;
                arrayPointer += 8;
            }
            this.message.setServerId(this.serverId);
            this.numberOfSync = Integer.parseInt(binaryMessage.substring(arrayPointer, arrayPointer + 4), 2);
            this.message.setNumberOfSync(this.numberOfSync);
            arrayPointer += 4;
            arrayPointer += 4;
            this.syncInfo = new SyncInfo[this.numberOfSync];
            for (int p = 0; p < this.numberOfSync; ++p) {
                this.syncInfo[p] = new SyncInfo();
                int syncType = Integer.parseInt(binaryMessage.substring(arrayPointer, arrayPointer + 4), 2);
                this.syncInfo[p].setSyncType(syncType += 200);
                arrayPointer += 4;
                arrayPointer += 4;
                String contentType = "";
                for (int o = 0; o < 3; ++o) {
                    int contentTypei = Integer.parseInt(binaryMessage.substring(arrayPointer, arrayPointer + 8), 2);
                    contentType = Integer.toString(contentTypei);
                    arrayPointer += 8;
                }
                this.syncInfo[p].setContentType(contentType);
                int serverurl_len = Integer.parseInt(binaryMessage.substring(arrayPointer, arrayPointer + 8), 2);
                arrayPointer += 8;
                String serverUri = "";
                for (int k = 0; k < serverurl_len; ++k) {
                    String byteData = binaryMessage.substring(arrayPointer, arrayPointer + 8);
                    int oneByte = Integer.parseInt(byteData, 2);
                    serverUri = serverUri + (char)oneByte;
                    arrayPointer += 8;
                }
                this.syncInfo[p].setServerUri(serverUri);
            }
            this.message.setSyncInfos(this.syncInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.error("Exception in SANMessageParser:" + e.toString());
            throw new MessageParserException(e.getMessage());
        }
        return this.message;
    }

    private void setSyncInfoArray(int arrayPointer, String binaryMessage) throws NumberFormatException {
        this.syncInfo = new SyncInfo[this.numberOfSync];
        for (int p = 0; p < this.numberOfSync; ++p) {
            this.syncInfo[p] = new SyncInfo();
            int syncType = Integer.parseInt(binaryMessage.substring(arrayPointer, arrayPointer + 4), 2);
            this.syncInfo[p].setSyncType(syncType += 200);
            arrayPointer += 4;
            arrayPointer += 4;
            String contentType = "";
            for (int o = 0; o < 3; ++o) {
                int contentTypei = Integer.parseInt(binaryMessage.substring(arrayPointer, arrayPointer + 8), 2);
                contentType = Integer.toString(contentTypei);
                arrayPointer += 8;
            }
            this.syncInfo[p].setContentType(contentType);
            int serverurl_len = Integer.parseInt(binaryMessage.substring(arrayPointer, arrayPointer + 8), 2);
            arrayPointer += 8;
            String serverUri = "";
            for (int k = 0; k < serverurl_len; ++k) {
                String byteData = binaryMessage.substring(arrayPointer, arrayPointer + 8);
                int oneByte = Integer.parseInt(byteData, 2);
                serverUri = serverUri + (char)oneByte;
                arrayPointer += 8;
            }
            this.syncInfo[p].setServerUri(serverUri);
        }
    }

    private int setServerId(String temp, int arrayPointer, String binaryMessage) throws NumberFormatException {
        int serverid_len = this.getServerIdLen(arrayPointer, binaryMessage);
        arrayPointer += 8;
        for (int k = 0; k < serverid_len; ++k) {
            temp = binaryMessage.substring(arrayPointer, arrayPointer + 8);
            int oneByte = Integer.parseInt(temp, 2);
            this.serverId = this.serverId + (char)oneByte;
            arrayPointer += 8;
        }
        this.message.setServerId(this.serverId);
        return arrayPointer;
    }

    private int getServerIdLen(int arrayPointer, String binaryMessage) throws NumberFormatException {
        String servidlen = binaryMessage.substring(arrayPointer, arrayPointer + 8);
        int serverid_len = Integer.parseInt(servidlen, 2);
        return serverid_len;
    }

    private void setSessionId(String binaryMessage, int arrayPointer) throws NumberFormatException {
        String ses_id = binaryMessage.substring(arrayPointer, arrayPointer + 16);
        this.sessionId = Integer.parseInt(ses_id, 2);
        this.message.setSessionId(this.sessionId);
    }

    private void setInitiator(int arrayPointer, String binaryMessage) throws NumberFormatException {
        String initiator_s = binaryMessage.substring(arrayPointer, arrayPointer + 1);
        int initiator_i = Integer.parseInt(initiator_s, 2);
        this.initiator = Integer.toString(initiator_i).charAt(0);
        this.message.setInitiator(this.initiator);
    }

    private void setUiMode(int arrayPointer, String binaryMessage) throws NumberFormatException {
        String uimode = binaryMessage.substring(arrayPointer, arrayPointer + 2);
        int ui_mode = Integer.parseInt(uimode, 2);
        this.uiMode = Integer.toString(ui_mode).charAt(0);
        this.message.setUiMode(this.uiMode);
    }

    private void setVersion(int arrayPointer, String binaryMessage) throws NumberFormatException {
        this.version = binaryMessage.substring(arrayPointer, arrayPointer + 10);
        int ver = Integer.parseInt(this.version, 2);
        this.version = Integer.toString(ver);
        String first = this.version.substring(0, 1);
        String second = this.version.substring(1);
        this.version = first + "." + second;
        this.message.setVersion(this.version);
    }

    public String getDigest() {
        return this.digest;
    }

    public String getVersion() {
        return this.version;
    }

    public char getUiMode() {
        return this.uiMode;
    }

    public int getInititator() {
        return this.initiator;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public int getNumberOfSync() {
        return this.numberOfSync;
    }

    public SyncInfo[] getSyncInfoArray() {
        return this.syncInfo;
    }
}

