/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.storage;

import com.funambol.storage.Serializable;
import com.funambol.util.Log;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ComplexSerializer {
    private static final int NULL = 0;
    private static final int INTEGER = 1;
    private static final int STRING = 2;
    private static final int SERIALIZED = 3;
    private static final int BYTE_ARRAY = 4;
    private static final int HASHTABLE = 5;
    private static final int VECTOR = 6;

    public static void serializeObject(DataOutputStream dout, Object obj) throws IOException {
        if (obj instanceof String) {
            dout.writeByte(2);
            dout.writeUTF((String)obj);
        } else if (obj instanceof Integer) {
            dout.writeByte(1);
            dout.writeInt((Integer)obj);
        } else if (obj instanceof byte[]) {
            dout.writeByte(4);
            dout.writeInt(((byte[])obj).length);
            dout.write((byte[])obj, 0, ((byte[])obj).length);
        } else if (obj instanceof Serializable) {
            dout.writeByte(3);
            dout.writeUTF(obj.getClass().getName());
            ((Serializable)obj).serialize(dout);
        } else if (obj instanceof Hashtable) {
            dout.writeByte(5);
            ComplexSerializer.serializeHashTable(dout, (Hashtable)obj);
        } else if (obj instanceof Vector) {
            dout.writeByte(6);
            ComplexSerializer.serializeVector(dout, (Vector)obj);
        } else if (obj == null) {
            dout.writeByte(0);
        } else {
            throw new IOException("Cannot serialize object of type " + obj.getClass().getName());
        }
    }

    public static Object deserializeObject(DataInputStream din) throws IOException {
        byte type = din.readByte();
        if (type == 0) {
            return null;
        }
        if (type == 1) {
            return new Integer(din.readInt());
        }
        if (type == 4) {
            byte[] array = new byte[din.readInt()];
            din.read(array);
            return array;
        }
        if (type == 2) {
            return din.readUTF();
        }
        if (type == 5) {
            return ComplexSerializer.deserializeHashTable(din);
        }
        if (type == 6) {
            return ComplexSerializer.deserializeVector(din);
        }
        if (type == 3) {
            String cname = din.readUTF();
            try {
                Class<?> cl = Class.forName(cname);
                Object obj = cl.newInstance();
                ((Serializable)obj).deserialize(din);
                return obj;
            }
            catch (IOException ioe) {
                Log.error("[deserializeObject] cname: " + cname + " - " + ioe.toString());
                throw ioe;
            }
            catch (IllegalAccessException iae) {
                String msg = "[deserializeObject] Cannot instantiate class: " + cname + " - " + iae.toString();
                Log.error(msg);
                throw new IOException(msg);
            }
            catch (Exception e) {
                String msg = "[deserializeObject] Exception on cname: " + cname + " - " + e.toString();
                Log.error(msg);
                throw new IOException(msg);
            }
        }
        throw new IOException("Deserialization error. Unknown type: [" + type + "]");
    }

    public static void serializeHashTable(DataOutputStream dout, Hashtable ht) throws IOException {
        dout.writeInt(ht.size());
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object val = ht.get(key);
            ComplexSerializer.serializeObject(dout, key);
            ComplexSerializer.serializeObject(dout, val);
        }
    }

    public static Hashtable deserializeHashTable(DataInputStream din) throws IOException {
        int size = din.readInt();
        Hashtable<Object, Object> ht = new Hashtable<Object, Object>();
        for (int i = 0; i < size; ++i) {
            Object key = ComplexSerializer.deserializeObject(din);
            Object val = ComplexSerializer.deserializeObject(din);
            ht.put(key, val);
        }
        return ht;
    }

    public static void serializeVector(DataOutputStream dout, Vector v) throws IOException {
        int n = v.size();
        try {
            dout.writeInt(n);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Log.error("IOException  in serializeVector!");
        }
        for (int i = 0; i < n; ++i) {
            ComplexSerializer.serializeObject(dout, v.elementAt(i));
        }
    }

    public static Vector deserializeVector(DataInputStream din) throws IOException {
        Vector<Object> v = new Vector<Object>();
        int n = din.readInt();
        for (int i = 0; i < n; ++i) {
            Object obj = ComplexSerializer.deserializeObject(din);
            v.addElement(obj);
        }
        return v;
    }

    public static void writeField(DataOutputStream out, String field) throws IOException {
        if (field != null) {
            out.writeBoolean(true);
            out.writeUTF(field);
        } else {
            out.writeBoolean(false);
        }
    }

    public static String readField(DataInputStream in) throws IOException {
        if (in.readBoolean()) {
            return in.readUTF();
        }
        return null;
    }

    public static void serializeObjectArray(DataOutputStream out, Object[] obj) throws IOException {
        out.writeInt(obj.length);
        for (int i = 0; i < obj.length; ++i) {
            ComplexSerializer.serializeObject(out, obj[i]);
        }
    }

    public static Object[] deserializeObjectArray(DataInputStream in) throws IOException {
        int length = in.readInt();
        Object[] obj = new Object[length];
        for (int i = 0; i < length; ++i) {
            obj[i] = ComplexSerializer.deserializeObject(in);
        }
        return obj;
    }

    public static void writeDateField(DataOutputStream out, Date field) throws IOException {
        if (field != null) {
            out.writeLong(field.getTime());
        } else {
            out.writeLong(0L);
        }
    }

    public static Date readDateField(DataInputStream in) throws IOException {
        long d = in.readLong();
        if (d > 0L) {
            return new Date(d);
        }
        return null;
    }
}

